/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.metamodel.FFile;


/**
 * Class CreateImportsOOFunction
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.1.2.1 $
 */
public abstract class CreateImportsOOFunction extends CodeGenFunction
{
   /**
    * Default Constructor
    */
   public CreateImportsOOFunction()
   {
      super (PRE_ORDER);
   }


   /**
    *Constructor for class CreateImportsOOFunction
    *
    * @param mode  No description provided
    */
   protected CreateImportsOOFunction (int mode)
   {
      super (mode);
   }


   /**
    * Get the responsible attribute of the CreateImportsOOFunction object
    *
    * @param method  No description provided
    * @return        The responsible value
    */
   public boolean isResponsible (String method)
   {
      return UMLFileOOHandler.CREATE_IMPORTS_FUNCTION.equals (method);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr    No description provided
    * @param param   No description provided
    * @param method  No description provided
    * @return        No description provided
    */
   public Object generateCode (ASGElement incr,
                               String method,
                               Object param[])
   {
      FFile umlFile = (FFile) incr;
      ImportFragment importFrag = (ImportFragment) param[0];

      generateImports (umlFile, importFrag);
      return null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param file            No description provided
    * @param importFragment  No description provided
    */
   protected abstract void generateImports (FFile file, ImportFragment importFragment);


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "CreateImportsOOFunction[]";
   }
}

/*
 * $Log: CreateImportsOOFunction.java,v $
 * Revision 1.1.2.1  2005/08/23 08:24:42  lowende
 * Removed compile warnings.
 *
 */
