/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.preferences.JavaPreferences;
import de.uni_paderborn.fujaba.uml.*;


/**
 * Class CollabStatBeginOOFunction
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.21.2.1 $
 */
public class CollabStatBeginOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (CollabStatBeginOOFunction.class);


   /**
    * Default Constructor
    */
   public CollabStatBeginOOFunction() { }


   /**
    * Get the responsible attribute of the CollabStatBeginOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.COLLAB_STAT_BEGIN.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param param       No description provided
    * @param asgElement  No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement asgElement, String methodName, Object param[])
   {
      UMLCollabStat collabStat = (UMLCollabStat) asgElement;

      if (log.isDebugEnabled())
      {
         log.debug (this + ".collabStatBegin("
            + ",collabStat=" + collabStat
            );
      }

      LinkedList statements = new LinkedList();

      String noText = collabStat.getNoText();
      String ifCondText = collabStat.getIfCondText();
      String loopVarName = collabStat.getLoopVarName();
      String loopStartVal = collabStat.getLoopStartVal();
      String loopStopVal = collabStat.getLoopStopVal();
      String assignTgtText = collabStat.getAssignTgtText();
      FType assignTgtType = collabStat.getAssignTgtType();
      String callText = collabStat.getCallText();
      String whileLoopText = collabStat.getWhileLoopText();

      OOVariable callTargetVar = null;

      UMLObject callTarget = collabStat.getCallTarget();

      boolean callOnElementsOfSet = collabStat.isCallOnElementsOfSet() &&
         callTarget != null &&
         callTarget.getType() == UMLObject.SET &&
         callTarget.getModifier() != UMLObject.DELETE;

      OOStatement.add (statements, OO.lineComment ("collabStatBegin " + noText + " is empty !"));

      if (callOnElementsOfSet)
      {
         String callTargetType = callTarget.getObjectType();
         callTargetVar = OO.variable (callTargetType, OOVariableType.iFujabaTmpObject);
      }

      // do we have a condition?
      if (ifCondText.length() != 0)
      {
         OOStatement.add (statements, OO.ifStat (ifCondText));
         OOStatement.add (statements, OO.startBlock());
      }

      // do we have a while loop?
      if (whileLoopText.length() != 0)
      {
         OOStatement.add (statements, OO.whileStat (whileLoopText));
         OOStatement.add (statements, OO.startBlock());
      }

      // do we have a loop?
      if (loopVarName.length() != 0)
      {
         // FIXME: assumimg that loopStartVal < loopStopVal !?

         OOVariable loopVar = OO.variable (loopVarName);
         OOVariable loopStartVar = OO.variable (loopStartVal);
         OOVariable loopStopVar = OO.variable (loopStopVal);

         OOStatement.add (statements, OO.varDecl (OO.type (UMLProject.get().getFromBaseTypes (UMLBaseTypes.INTEGER)),
            loopVar));
         OOStatement.add (statements, OO.forStat (OO.assign (loopVar, loopStartVar),
            OO.infixOp (loopVar,
            OOInfixOp.LESS_EQUAL_OP,
            loopStopVar),
            OO.prefixOp (OOPrefixOp.INCR_OP, loopVar)));
         OOStatement.add (statements, OO.startBlock());
      }

      // do we have to call the corresponding set-function
      int splitPoint = assignTgtText.indexOf (".");
      String commandLine = "";

      // hack , because i am currently not able to parse assignTgtText
      if (splitPoint != -1)
      {
         commandLine = assignTgtText.substring (0, splitPoint) +
            ".set" +
            assignTgtText.substring (splitPoint + 1,
            splitPoint + 2).toUpperCase() +
            assignTgtText.substring (splitPoint + 2,
            assignTgtText.length()) +
            " (";

         // do we have a call-target?
         if (callTarget != null)
         {
            commandLine += callTarget.getObjectName() + ".";
         }

         commandLine += callText + ")";
      }
      else
      {
         // do we have a call-target and the corresponding call-text?
         if (callTarget != null &&  (callText.length() != 0))
         {
            if (callOnElementsOfSet && callTargetVar != null)
            {
               commandLine += JavaPreferences.get().getInternalVariablePrefix() + "TmpObject" + callTargetVar.getFirstName() + ".";
            }
            else
            {
               commandLine += callTarget.getObjectName() + ".";
            }
         }

         if (callText.length() != 0)
         {
            commandLine += callText + "";
         }
      }

      // do we have an assign-target?
      if (assignTgtText.length() != 0)
      {
         if (assignTgtType != null)
         {
            OOStatement.add (statements, OO.varDecl (OO.type (assignTgtType), OO.variable (assignTgtText), new OOStringExpr (commandLine)));
         }
         else
         {
            OOStatement.add (statements, OO.assignStat (OO.variable (assignTgtText), OO.identifier (commandLine)));
         }
      }
      else
      {
         OOStatement.add (statements, OO.exprStat (OO.identifier (commandLine)));
      }
      OOStatement.add (statements, OO.emptyLine());

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "CollabStatBeginOOFunction[]";
   }
}

/*
 * $Log: CollabStatBeginOOFunction.java,v $
 * Revision 1.21.2.1  2005/08/23 08:24:42  lowende
 * Removed compile warnings.
 *
 */
