/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;



/**
 * @author    mksoft
 * @version   $Revision: 1.4 $
 */
public class CodeGenTargetParserPair
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private CodeGenTarget target = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private CodeGenStrategy strategy = null;


   /**
    * Constructor for class CodeGenTargetParserPair
    */
   public CodeGenTargetParserPair() { }


   /**
    * Get the valid attribute of the CodeGenTargetParserPair object
    *
    * @return   The valid value
    */
   public boolean isValid()
   {
      return  (target != null && strategy != null);
   }


   /**
    * Get the strategy attribute of the CodeGenTargetParserPair object
    *
    * @return   The strategy value
    */
   public CodeGenStrategy getStrategy()
   {
      return strategy;
   }


   /**
    * Get the target attribute of the CodeGenTargetParserPair object
    *
    * @return   The target value
    */
   public CodeGenTarget getTarget()
   {
      return target;
   }


   /**
    * @param strategy
    */
   public void setStrategy (CodeGenStrategy strategy)
   {
      this.strategy = strategy;
   }


   /**
    * @param target
    */
   public void setTarget (CodeGenTarget target)
   {
      this.target = target;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public String toString()
   {
      StringBuffer result = new StringBuffer();

      result.append ("CodeGenTargetParserPair[target=");
      result.append (target);
      result.append (",strategy=");
      result.append (strategy);
      result.append ("]");

      return result.toString();
   }

}

/*
 * $Log: CodeGenTargetParserPair.java,v $
 * Revision 1.4  2004/10/20 17:49:30  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
