/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Iterator;

import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FLinkedList;


/**
 * Class CodeGenTarget
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12 $ <h2> Associations </h2> <pre>
 *                -------- 0..1          Assoc          0..1
 * CodeGenFactory | name |----------------------------------- CodeGenTarget
 *                -------- codeGenFactory      codeGenTarget
 *
 *                     n                  Assoc                   0..1  /\
 * CodeGenTargetEntry -------------------------------------------------<  > CodeGenTarget
 *                     codeGenTargetEntry   {ordered,}   codeGenTarget  \/
 * </pre>
 */
public class CodeGenTarget
{

   /**
    * Default Constructor
    */
   public CodeGenTarget() { }


   /**
    * <pre>
    *                     n                  Assoc                   0..1  /\
    * CodeGenTargetEntry -------------------------------------------------<  > CodeGenTarget
    *                     codeGenTargetEntry   {ordered,}   codeGenTarget  \/
    * </pre>
    */
   private FLinkedList codeGenTargetEntry;


   /**
    * @param value  No description provided
    * @return       No description provided
    * @see          #codeGenTargetEntry
    */
   public boolean hasInCodeGenTargetEntry (CodeGenTargetEntry value)
   {
      return  ( (this.codeGenTargetEntry != null) &&
          (value != null) &&
         this.codeGenTargetEntry.contains (value));
   }


   /**
    * @return   No description provided
    * @see      #codeGenTargetEntry
    */
   public Iterator iteratorOfCodeGenTargetEntry()
   {
      return  ( (this.codeGenTargetEntry == null)
         ? FEmptyIterator.get()
         : this.codeGenTargetEntry.iterator());
   }


   /**
    * @return   No description provided
    * @see      #codeGenTargetEntry
    */
   public int sizeOfCodeGenTargetEntry()
   {
      return  ( (this.codeGenTargetEntry == null)
         ? 0
         : this.codeGenTargetEntry.size());
   }


   /**
    * @param value  The object added.
    * @return       No description provided
    * @see          #codeGenTargetEntry
    */
   public boolean addToCodeGenTargetEntry (CodeGenTargetEntry value)
   {
      boolean changed = false;
      if (value != null && !hasInCodeGenTargetEntry (value))
      {
         if (this.codeGenTargetEntry == null)
         {
            this.codeGenTargetEntry = new FLinkedList(); // or FTreeSet () or FLinkedList ()
         }
         changed = this.codeGenTargetEntry.add (value);
         if (changed)
         {
            value.setCodeGenTarget (this);
         }
      }
      return changed;
   }


   /**
    * @param value  No description provided
    * @return       No description provided
    * @see          #codeGenTargetEntry
    */
   public boolean removeFromCodeGenTargetEntry (CodeGenTargetEntry value)
   {
      boolean changed = false;
      if ( (this.codeGenTargetEntry != null) &&  (value != null))
      {
         changed = this.codeGenTargetEntry.remove (value);
         if (changed)
         {
            value.setCodeGenTarget (null);
         }
      }
      return changed;
   }


   /**
    * @see   #codeGenTargetEntry
    */
   public void removeAllFromCodeGenTargetEntry()
   {
      CodeGenTargetEntry tmpValue;
      Iterator iter = this.iteratorOfCodeGenTargetEntry();
      while (iter.hasNext())
      {
         tmpValue = (CodeGenTargetEntry) iter.next();
         this.removeFromCodeGenTargetEntry (tmpValue);
      }
   }


   /**
    * @param index  No description provided
    * @return       The codeGenTargetEntryAt value
    * @see          #codeGenTargetEntry
    */
   public CodeGenTargetEntry getCodeGenTargetEntryAt (int index)
   {
      if (index >= 0 && index < sizeOfCodeGenTargetEntry())
      {
         return (CodeGenTargetEntry) this.codeGenTargetEntry.get (index);
      }
      else
      {
         throw new IllegalArgumentException ("getCodeGenTargetEntryAt(" + index + ")");
      }
   }


   /**
    * @param elem  No description provided
    * @return      No description provided
    * @see         #codeGenTargetEntry
    */
   public int indexOfCodeGenTargetEntry (CodeGenTargetEntry elem)
   {
      return  ( (this.codeGenTargetEntry == null)
         ? -1
         : this.codeGenTargetEntry.indexOf (elem));
   }


   /**
    * @param elem  No description provided
    * @return      No description provided
    * @see         #codeGenTargetEntry
    */
   public int lastIndexOfCodeGenTargetEntry (CodeGenTargetEntry elem)
   {
      return  ( (this.codeGenTargetEntry == null)
         ? -1
         : this.codeGenTargetEntry.lastIndexOf (elem));
   }


   /**
    * @param lowerBound  No description provided
    * @return            No description provided
    * @see               #codeGenTargetEntry
    */
   public Iterator iteratorOfCodeGenTargetEntry (CodeGenTargetEntry lowerBound)
   {
      Iterator result = FEmptyIterator.get();
      if (codeGenTargetEntry == null)
      {
         result = FEmptyIterator.get();
      }
      else if (codeGenTargetEntry != null && lowerBound != null)
      {
         int index = codeGenTargetEntry.indexOf (lowerBound) + 1;
         result = codeGenTargetEntry.listIterator (index);
      }
      else if (codeGenTargetEntry != null && lowerBound == null)
      {
         result = codeGenTargetEntry.listIterator (0);
      }
      return result;
   }


   /**
    * @param leftObject   No description provided
    * @param rightObject  No description provided
    * @return             The beforeOfCodeGenTargetEntry value
    * @see                #codeGenTargetEntry
    */
   public boolean isBeforeOfCodeGenTargetEntry (CodeGenTargetEntry leftObject, CodeGenTargetEntry rightObject)
   {
      if (codeGenTargetEntry == null)
      {
         return false;
      }
      else
      {
         return codeGenTargetEntry.isBefore (leftObject, rightObject);
      }
   }


   /**
    * @param leftObject   No description provided
    * @param rightObject  No description provided
    * @return             The afterOfCodeGenTargetEntry value
    * @see                #codeGenTargetEntry
    */
   public boolean isAfterOfCodeGenTargetEntry (CodeGenTargetEntry leftObject, CodeGenTargetEntry rightObject)
   {
      if (codeGenTargetEntry == null)
      {
         return false;
      }
      else
      {
         return codeGenTargetEntry.isAfter (leftObject, rightObject);
      }
   }


   /**
    * @return   The firstOfCodeGenTargetEntry value
    * @see      #codeGenTargetEntry
    */
   public CodeGenTargetEntry getFirstOfCodeGenTargetEntry()
   {
      if (codeGenTargetEntry == null)
      {
         return null;
      }
      else
      {
         return (CodeGenTargetEntry) codeGenTargetEntry.getFirst();
      }
   }


   /**
    * @return   The lastOfCodeGenTargetEntry value
    * @see      #codeGenTargetEntry
    */
   public CodeGenTargetEntry getLastOfCodeGenTargetEntry()
   {
      if (codeGenTargetEntry == null)
      {
         return null;
      }
      else
      {
         return (CodeGenTargetEntry) codeGenTargetEntry.getLast();
      }
   }


   /**
    * @param object  No description provided
    * @return        The nextOfCodeGenTargetEntry value
    * @see           #codeGenTargetEntry
    */
   public CodeGenTargetEntry getNextOfCodeGenTargetEntry (CodeGenTargetEntry object)
   {
      if (codeGenTargetEntry == null)
      {
         return null;
      }
      else
      {
         return (CodeGenTargetEntry) codeGenTargetEntry.getNextOf (object);
      }
   }


   /**
    * @param object  No description provided
    * @param index   No description provided
    * @return        The nextIndexOfCodeGenTargetEntry value
    * @see           #codeGenTargetEntry
    */
   public CodeGenTargetEntry getNextIndexOfCodeGenTargetEntry (CodeGenTargetEntry object, int index)
   {
      if (codeGenTargetEntry == null)
      {
         return null;
      }
      else
      {
         return (CodeGenTargetEntry) codeGenTargetEntry.getNextOf (object, index);
      }
   }


   /**
    * @param object  No description provided
    * @return        The previousOfCodeGenTargetEntry value
    * @see           #codeGenTargetEntry
    */
   public CodeGenTargetEntry getPreviousOfCodeGenTargetEntry (CodeGenTargetEntry object)
   {
      if (codeGenTargetEntry == null)
      {
         return null;
      }
      else
      {
         return (CodeGenTargetEntry) codeGenTargetEntry.getPreviousOf (object);
      }
   }


   /**
    * @param object  No description provided
    * @param index   No description provided
    * @return        The previousIndexOfCodeGenTargetEntry value
    * @see           #codeGenTargetEntry
    */
   public CodeGenTargetEntry getPreviousIndexOfCodeGenTargetEntry (CodeGenTargetEntry object, int index)
   {
      if (codeGenTargetEntry == null)
      {
         return null;
      }
      else
      {
         return (CodeGenTargetEntry) codeGenTargetEntry.getPreviousOf (object, index);
      }
   }


   /**
    * UMLAttribute : 'name : String '
    */
   private String name;


   /**
    * Get the value of name.
    *
    * @return   Value of name.
    */
   public String getName()
   {
      return this.name;
   }


   /**
    * Set the value of name.
    *
    * @param name  Value to assign to name.
    */
   public void setName (String name)
   {
      if (name == null || !name.equals (this.name))
      {
         this.name = name;
      }
   }


   /**
    * UMLAttribute : 'fullName : String '
    */
   private String fullName;


   /**
    * Get the value of fullName.
    *
    * @return   Value of fullName.
    */
   public String getFullName()
   {
      return this.fullName;
   }


   /**
    * Set the value of fullName.
    *
    * @param fullName  Value to assign to fullName.
    */
   public void setFullName (String fullName)
   {
      if (fullName == null || !fullName.equals (this.fullName))
      {
         this.fullName = fullName;
      }
   }


   /**
    * <pre>
    *                -------- 0..1          Assoc          0..1
    * CodeGenFactory | name |----------------------------------- CodeGenTarget
    *                -------- codeGenFactory      codeGenTarget
    * </pre>
    */
   private CodeGenFactory codeGenFactory;


   /**
    * UMLMethod: '+ setCodeGenFactory (value: CodeGenFactory): Boolean'.
    *
    * @param value  The new codeGenFactory value
    * @return       No description provided
    */
   public boolean setCodeGenFactory (CodeGenFactory value)
   {
      boolean changed = false;
      if (this.codeGenFactory != value)
      {
         if (this.codeGenFactory != null)
         {
            CodeGenFactory oldValue = this.codeGenFactory;
            this.codeGenFactory = null;
            oldValue.removeFromCodeGenTarget (this);
         }
         this.codeGenFactory = value;
         if (value != null)
         {
            value.addToCodeGenTarget (this);
         }
         changed = true;
      }
      return changed;
   }


   /**
    * UMLMethod: '+ getCodeGenFactory (): CodeGenFactory'.
    *
    * @return   The codeGenFactory value
    */
   public CodeGenFactory getCodeGenFactory()
   {
      return this.codeGenFactory;
   }


   /**
    * UMLMethod: '+ removeYou (): Void'.
    */
   public void removeYou()
   {
      CodeGenFactory tmpCodeGenFactory = getCodeGenFactory();
      if (tmpCodeGenFactory != null)
      {
         setCodeGenFactory (null);
      } // if

      removeAllFromCodeGenTargetEntry();
   }


   /**
    * @return   short string representation of current object
    */

   public String toString()
   {
      StringBuffer result = new StringBuffer();

      result.append ("CodeGenTarget[name=");
      result.append (getName());
      result.append ("]");

      return result.toString();
   }
}

/*
 * $Log: CodeGenTarget.java,v $
 * Revision 1.12  2004/10/22 16:41:33  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
