/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Iterator;
import org.apache.log4j.Logger;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;

import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;


/**
 * Class CodeGenFactory (Singleton) <h2>Associations</h2> <pre>
 *                -------- 0..1       hasStrategies       0..1
 * CodeGenFactory | name |------------------------------------- CodeGenStrategy
 *                -------- codeGenFactory      codeGenStrategy
 *
 *                 0..1                        0..1
 * CodeGenFactory ---------------------------------- CodeGenStrategy
 *                 currentFactory   currentStrategy
 *
 *                -------- 0..1          Assoc          0..1
 * CodeGenFactory | name |----------------------------------- CodeGenTarget
 *                -------- codeGenFactory      codeGenTarget
 * </pre>
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.40.2.6 $
 */
public class CodeGenFactory
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (CodeGenFactory.class);

   /**
    * the Singleton instance
    */
   public static CodeGenFactory theInstance = null;


   /**
    * Default Constructor
    */
   private CodeGenFactory() { }


   /**
    * The access method for the singleton instance.
    *
    * @return   No description provided
    */
   public static CodeGenFactory get()
   {
      if (theInstance == null)
      {
         theInstance = new CodeGenFactory();
         theInstance.init();
      }

      return theInstance;
   }


   /**
    * Initializes code generation with java code generation.
    */
   private void init()
   {
      boolean success = CodeGenTargetParser.get().parseFile ("de/uni_paderborn/fujaba/codegen/javatarget.xml");

      if (success)
      {
         setCurrentTarget ("java");
      }
      else
      {
         setCurrentTarget (null);
         log.error ("parsing de/uni_paderborn/fujaba/codegen/javatarget.xml failed !");
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private CodeGenTarget currentTarget = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param targetFileName  No description provided
    */
   public void parseTargetFile (String targetFileName)
   {
      CodeGenTargetParser.get().parseFile (targetFileName);
   }


   /**
    * Sets the currentTarget attribute of the CodeGenFactory object
    *
    * @param name  The new currentTarget value
    */
   public void setCurrentTarget (String name)
   {
      CodeGenTarget newTarget = getFromCodeGenTarget (name);

      if (currentTarget != newTarget && newTarget != null)
      {
         currentTarget = newTarget;

         // set current strategy and current visitor for AAssociationEngine

         // create for code for all CodeGenTargetEntries
         Iterator iter = currentTarget.iteratorOfCodeGenTargetEntry();

         CodeGenTargetEntry tmpEntry = (CodeGenTargetEntry) iter.next();

         // set strategy
         CodeGenStrategy tmpStrategy = getFromCodeGenStrategy (tmpEntry.getStrategyName());
         setCurrentStrategy (tmpStrategy);

         // set visitor
         tmpStrategy.setCurrentVisitor (tmpStrategy.getFromCodeGenVisitor (tmpEntry.getVisitorName()));
      }
   }


   /**
    * Get the currentTarget attribute of the CodeGenFactory object
    *
    * @return   The currentTarget value
    */
   public CodeGenTarget getCurrentTarget()
   {
      return this.currentTarget;
   }


   /**
    * Generates sourcecode for a given <code>FElement</code> without storing it in a file.
    *
    * @param element  The model element for which source code will be generated.
    * @return         the generated sourcecode
    */
   public final StringBuffer generateFElement (de.uni_paderborn.fujaba.metamodel.FElement element)
   {
      return generateFElement (element, false);
   }


   /**
    * Generates sourcecode for a given <code>FElement</code> with the possibility of saving
    * it to a file.
    *
    * @param element  The model element for which source code will be generated.
    * @param save     Defines whether the generated sourcecode has to be saved or not.
    * @return         the generated sourcecode
    */
   public final StringBuffer generateFElement (de.uni_paderborn.fujaba.metamodel.FElement element, boolean save)
   {
      FElementGeneratorRunnable runnable = new FElementGeneratorRunnable (element, save);
      FujabaChangeManager.executeTransient (runnable);
      return runnable.buffer;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.40.2.6 $ $Date: 2006/03/03 16:21:04 $
    */
   private class FElementGeneratorRunnable implements Runnable
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      StringBuffer buffer;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      de.uni_paderborn.fujaba.metamodel.FElement element;


      /**
       *Constructor for class FElementGeneratorRunnable
       *
       * @param element  No description provided
       * @param save     No description provided
       */
      public FElementGeneratorRunnable (FElement element, boolean save)
      {
         this.element = element;
         this.save = save;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      boolean save;


      /**
       * Main processing method for the FElementGeneratorRunnable object
       */
      public void run()
      {
         // create buffer
         CodeGenStrategy strategy = getCurrentStrategy();

         // generate code for theIncrement
         buffer = strategy.generateFElement (element, save);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void generateFProject()
   {
      generateFProject (UMLProject.get());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theProject  No description provided
    */
   public void generateFProject (final FProject theProject)
   {
      Runnable runnable =
         new Runnable()
         {
            public void run()
            {
               generateFProjectInternal (theProject);
            }
         };
      FujabaChangeManager.executeTransient (runnable);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theProject  No description provided
    */
   void generateFProjectInternal (FProject theProject)
   {
      Iterator iter = currentTarget.iteratorOfCodeGenTargetEntry();
      CodeGenTargetEntry tmpEntry;
      String strategyName;
      String visitorName;
      CodeGenStrategy tmpStrategy;
      CodeGenVisitor tmpVisitor;

      if (log.isDebugEnabled())
      {
         log.debug ("generating code for " + currentTarget);
      }

      while (iter.hasNext())
      {
         tmpEntry = (CodeGenTargetEntry) iter.next();

         strategyName = tmpEntry.getStrategyName();
         visitorName = tmpEntry.getVisitorName();

         // set strategy
         tmpStrategy = getFromCodeGenStrategy (strategyName);
         setCurrentStrategy (tmpStrategy);

         // set visitor
         tmpVisitor = tmpStrategy.getFromCodeGenVisitor (visitorName);
         tmpStrategy.setCurrentVisitor (tmpVisitor);

         // create files for all (newStrategy,newVisitor)
         setCurrentFProject (theProject);

         getCurrentStrategy().generateFProject (theProject);

         setCurrentFProject (null);
      } //while
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FProject currentFProject;


   /**
    * Get the value of currentFProject.
    *
    * @return   Value of currentFProject.
    */
   public FProject getCurrentFProject()
   {
      return  (this.currentFProject != null ? this.currentFProject : UMLProject.get());
   }


   /**
    * Set the value of currentFProject.
    *
    * @param currentFProject  Value to assign to currentFProject.
    */
   public void setCurrentFProject (FProject currentFProject)
   {
      if (this.currentFProject != currentFProject)
      {
         this.currentFProject = currentFProject;
      }
   }


   /**
    * <pre>
    *                 0..1                        0..1
    * CodeGenFactory ---------------------------------- CodeGenStrategy
    *                 currentFactory   currentStrategy
    * </pre>
    */
   private CodeGenStrategy currentStrategy;


   /**
    * @param value  The new currentStrategy value
    * @return       No description provided
    * @see          #currentStrategy
    */
   public boolean setCurrentStrategy (CodeGenStrategy value)
   {
      if (this.currentStrategy != value)
      {
         if (this.currentStrategy != null)
         {
            CodeGenStrategy oldValue = this.currentStrategy;
            this.currentStrategy = null;
            oldValue.setCurrentFactory (null);
         }
         this.currentStrategy = value;
         if (value != null)
         {
            this.currentStrategy.setCurrentFactory (this);
         }

         return true;
      }

      return false;
   }


   /**
    * @return   The currentStrategy value
    * @see      #currentStrategy
    */
   public CodeGenStrategy getCurrentStrategy()
   {
      return this.currentStrategy;
   }


   /**
    * @return   The currentVisitor value
    * @see      #currentStrategy
    * @see      CodeGenStrategy#getCurrentVisitor
    */
   public CodeGenVisitor getCurrentVisitor()
   {
      if (getCurrentStrategy() != null)
      {
         return getCurrentStrategy().getCurrentVisitor();
      }

      return null;
   }


   /**
    * Get the currentOOVisitor attribute of the CodeGenFactory object
    *
    * @return   The currentOOVisitor value
    */
   public OOGenVisitor getCurrentOOVisitor()
   {
      if (getCurrentStrategy() != null)
      {
         if (getCurrentStrategy().getCurrentVisitor() != null
            && getCurrentStrategy().getCurrentVisitor() instanceof OOGenVisitor)
         {
            return (OOGenVisitor) getCurrentStrategy().getCurrentVisitor();
         }
      }

      return null;
   }


   /**
    * <pre>
    *                -------- 0..1       hasStrategies       0..1
    * CodeGenFactory | name |------------------------------------- CodeGenStrategy
    *                -------- codeGenFactory      codeGenStrategy
    * </pre>
    */
   private FHashMap codeGenStrategy;


   /**
    * @param value  No description provided
    * @return       No description provided
    * @see          #codeGenStrategy
    */
   public boolean hasInCodeGenStrategy (CodeGenStrategy value)
   {
      return  (
          (this.codeGenStrategy != null)
         &&  (value != null)
         &&  (value.getName() != null)
         &&  (this.codeGenStrategy.get (value.getName()) == value));
   }


   /**
    * @param key  No description provided
    * @return     No description provided
    * @see        #codeGenStrategy
    */
   public boolean hasKeyInCodeGenStrategy (String key)
   {
      return  ( (this.codeGenStrategy != null) &&  (key != null) && this.codeGenStrategy.containsKey (key));
   }


   /**
    * @return   No description provided
    * @see      #codeGenStrategy
    */
   public Iterator iteratorOfCodeGenStrategy()
   {
      return  ( (this.codeGenStrategy == null) ? FEmptyIterator.get() : this.codeGenStrategy.values().iterator());
   }


   /**
    * @return   No description provided
    * @see      #codeGenStrategy
    */
   public Iterator keysOfCodeGenStrategy()
   {
      return  ( (this.codeGenStrategy == null) ? FEmptyIterator.get() : this.codeGenStrategy.keySet().iterator());
   }


   /**
    * @return   No description provided
    * @see      #codeGenStrategy
    */
   public Iterator entriesOfCodeGenStrategy()
   {
      return  ( (this.codeGenStrategy == null) ? FEmptyIterator.get() : this.codeGenStrategy.entrySet().iterator());
   }


   /**
    * @return   No description provided
    * @see      #codeGenStrategy
    */
   public int sizeOfCodeGenStrategy()
   {
      return  ( (this.codeGenStrategy == null) ? 0 : this.codeGenStrategy.size());
   }


   /**
    * @param key  No description provided
    * @return     The fromCodeGenStrategy value
    * @see        #codeGenStrategy
    */
   public CodeGenStrategy getFromCodeGenStrategy (String key)
   {
      return  (
          ( (this.codeGenStrategy == null) ||  (key == null)) ? null : (CodeGenStrategy) this.codeGenStrategy.get (key));
   }


   /**
    * @param value  The object added.
    * @return       No description provided
    * @see          #codeGenStrategy
    */
   public boolean addToCodeGenStrategy (CodeGenStrategy value)
   {
      boolean changed = false;
      if ( (value != null) &&  (value.getName() != null))
      {
         if (this.codeGenStrategy == null)
         {
            this.codeGenStrategy = new FHashMap();
         }
         CodeGenStrategy oldValue = (CodeGenStrategy) this.codeGenStrategy.put (value.getName(), value);
         if (oldValue != value)
         {
            if (oldValue != null)
            {
               oldValue.setCodeGenFactory (null);
            }
            value.setCodeGenFactory (this);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * @param value  No description provided
    * @return       No description provided
    * @see          #codeGenStrategy
    */
   public boolean removeFromCodeGenStrategy (CodeGenStrategy value)
   {
      boolean changed = false;
      if ( (this.codeGenStrategy != null) &&  (value != null) &&  (value.getName() != null))
      {
         CodeGenStrategy oldValue = (CodeGenStrategy) this.codeGenStrategy.get (value.getName());
         if (oldValue == value)
         {
            this.codeGenStrategy.remove (value.getName());
            value.setCodeGenFactory (null);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * @param key  No description provided
    * @return     No description provided
    * @see        #codeGenStrategy
    */
   public boolean removeKeyFromCodeGenStrategy (String key)
   {
      boolean changed = false;
      if ( (this.codeGenStrategy != null) &&  (key != null))
      {
         CodeGenStrategy tmpValue = (CodeGenStrategy) this.codeGenStrategy.get (key);
         if (tmpValue != null)
         {
            this.codeGenStrategy.remove (key);
            tmpValue.setCodeGenFactory (null);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * @see   #codeGenStrategy
    */
   public void removeAllFromCodeGenStrategy()
   {
      CodeGenStrategy tmpValue;
      Iterator iter = this.iteratorOfCodeGenStrategy();
      while (iter.hasNext())
      {
         tmpValue = (CodeGenStrategy) iter.next();
         this.removeFromCodeGenStrategy (tmpValue);
      }

   }


   /**
    * <pre>
    *                -------- 0..1          Assoc          0..1
    * CodeGenFactory | name |----------------------------------- CodeGenTarget
    *                -------- codeGenFactory      codeGenTarget
    * </pre>
    */
   private FHashMap codeGenTarget;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInCodeGenTarget (CodeGenTarget value)
   {
      return  (
          (this.codeGenTarget != null)
         &&  (value != null)
         &&  (value.getName() != null)
         &&  (this.codeGenTarget.get (value.getName()) == value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public boolean hasKeyInCodeGenTarget (String key)
   {
      return  ( (this.codeGenTarget != null) &&  (key != null) && this.codeGenTarget.containsKey (key));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfCodeGenTarget()
   {
      return  ( (this.codeGenTarget == null) ? FEmptyIterator.get() : this.codeGenTarget.values().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator keysOfCodeGenTarget()
   {
      return  ( (this.codeGenTarget == null) ? FEmptyIterator.get() : this.codeGenTarget.keySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator entriesOfCodeGenTarget()
   {
      return  ( (this.codeGenTarget == null) ? FEmptyIterator.get() : this.codeGenTarget.entrySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfCodeGenTarget()
   {
      return  ( (this.codeGenTarget == null) ? 0 : this.codeGenTarget.size());
   }


   /**
    * Get the fromCodeGenTarget attribute of the CodeGenFactory object
    *
    * @param key  No description provided
    * @return     The fromCodeGenTarget value
    */
   public CodeGenTarget getFromCodeGenTarget (String key)
   {
      return  ( ( (this.codeGenTarget == null) ||  (key == null)) ? null : (CodeGenTarget) this.codeGenTarget.get (key));
   }


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToCodeGenTarget (CodeGenTarget value)
   {
      boolean changed = false;
      if ( (value != null) &&  (value.getName() != null))
      {
         if (this.codeGenTarget == null)
         {
            this.codeGenTarget = new FHashMap(); // or FTreeMap ()
         }
         CodeGenTarget oldValue = (CodeGenTarget) this.codeGenTarget.put (value.getName(), value);
         if (oldValue != value)
         {
            if (oldValue != null)
            {
               oldValue.setCodeGenFactory (null);
            }
            value.setCodeGenFactory (this);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromCodeGenTarget (CodeGenTarget value)
   {
      boolean changed = false;
      if ( (this.codeGenTarget != null) &&  (value != null) &&  (value.getName() != null))
      {
         CodeGenTarget oldValue = (CodeGenTarget) this.codeGenTarget.get (value.getName());
         if (oldValue == value)
         {
            this.codeGenTarget.remove (value.getName());
            value.setCodeGenFactory (null);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public boolean removeKeyFromCodeGenTarget (String key)
   {
      boolean changed = false;
      if ( (this.codeGenTarget != null) &&  (key != null))
      {
         CodeGenTarget tmpValue = (CodeGenTarget) this.codeGenTarget.get (key);
         if (tmpValue != null)
         {
            this.codeGenTarget.remove (key);
            tmpValue.setCodeGenFactory (null);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromCodeGenTarget()
   {
      CodeGenTarget tmpValue;
      Iterator iter = this.iteratorOfCodeGenTarget();
      while (iter.hasNext())
      {
         tmpValue = (CodeGenTarget) iter.next();
         this.removeFromCodeGenTarget (tmpValue);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      removeAllFromCodeGenStrategy();

      removeAllFromCodeGenTarget();
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "CodeGenFactory[]";
   }
}

/*
 * $Log: CodeGenFactory.java,v $
 * Revision 1.40.2.6  2006/03/03 16:21:04  lowende
 * Compile warnings removed.
 *
 */
