/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Iterator;

import java.util.Set;
import de.upb.tools.fca.FEmptyIterator;

import de.upb.tools.fca.FHashSet;


/**
 * @author    christian.schneider@uni-kassel.de
 * @version   $Revision: 1.2.2.1 $ $Date: 2005/10/27 18:27:40 $
 */
public class CodeGenException extends RuntimeException
{
   /**
    * Constructs a new runtime exception with <code>null</code> as its
    * detail message.  The cause is not initialized, and may subsequently be
    * initialized by a call to initCause().
    */
   public CodeGenException() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Set exceptions;


   /**
    * Returns the cause of this throwable or <code>null</code> if the
    * cause is nonexistent or unknown.  (The cause is the throwable that
    * caused this throwable to get thrown.)
    * <p/>
    * <p>This implementation returns the cause that was supplied via one of
    * the constructors requiring a <tt>Throwable</tt>, or that was set after
    * creation with the {@link #initCause(Throwable)} method.  While it is
    * typically unnecessary to override this method, a subclass can override
    * it to return a cause set by some other means.  This is appropriate for
    * a "legacy chained throwable" that predates the addition of chained
    * exceptions to <tt>Throwable</tt>.  Note that it is <i>not</i>
    * necessary to override any of the <tt>PrintStackTrace</tt> methods,
    * all of which invoke the <tt>getCause</tt> method to determine the
    * cause of a throwable.
    *
    * @return   the cause of this throwable or <code>null</code> if the
    *         cause is nonexistent or unknown.
    * @since    1.4
    */
   public Throwable getCause()
   {
      if (super.getCause() != null)
      {
         return super.getCause();
      }
      else if (sizeOfExceptions() > 0)
      {
         return (Throwable) iteratorOfExceptions().next();
      }
      else
      {
         return null;
      }
   }


   /**
    * Access method for a To N-association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToExceptions (Exception value)
   {
      if (value instanceof CodeGenException)
      {
         CodeGenException cge = (CodeGenException) value;
         boolean changed = false;
         for (Iterator it = cge.iteratorOfExceptions(); it.hasNext(); )
         {
            Exception exception = (Exception) it.next();
            changed |= addToExceptions (exception);
         }
         return changed;
      }
      else
      {
         boolean changed = false;
         if (value != null)
         {
            if (this.exceptions == null)
            {
               this.exceptions = new FHashSet();
            }
            changed = this.exceptions.add (value);
         }
         return changed;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInExceptions (Exception value)
   {
      return  ( (this.exceptions != null) &&
          (value != null) &&
         this.exceptions.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfExceptions()
   {
      if (this.exceptions == null)
      {
         return FEmptyIterator.get();
      }
      else
      {
         return this.exceptions.iterator();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromExceptions()
   {
      Exception tmpValue;
      Iterator iter = this.iteratorOfExceptions();
      while (iter.hasNext())
      {
         tmpValue = (Exception) iter.next();
         this.removeFromExceptions (tmpValue);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromExceptions (Exception value)
   {
      boolean changed = false;
      if ( (this.exceptions != null) &&  (value != null))
      {
         changed = this.exceptions.remove (value);
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfExceptions()
   {
      return  ( (this.exceptions == null)
         ? 0
         : this.exceptions.size());
   }


   /**
    * Returns the detail message string of this throwable.
    *
    * @return   the detail message string of this <tt>Throwable</tt> instance
    *         (which may be <tt>null</tt>).
    */
   public String getMessage()
   {
      StringBuffer buffer = new StringBuffer();
      Iterator it = this.iteratorOfExceptions();

      buffer.append ("[");
      while (it.hasNext())
      {
         Exception e = (Exception) it.next();
         buffer.append (e);

         if (it.hasNext())
         {
            buffer.append (", ");
         }
      }
      buffer.append ("]");

      return buffer.toString();
   }


   /**
    * Prints the stack trace of this throwable.
    */
   public void printStackTrace()
   {
      Iterator it = this.iteratorOfExceptions();

      System.err.println ("[");
      while (it.hasNext())
      {
         Exception e = (Exception) it.next();
         e.printStackTrace();

         if (it.hasNext())
         {
            System.err.println();
         }
      }
      System.err.println ("]");
   }
}

/*
 * $Log: CodeGenException.java,v $
 * Revision 1.2.2.1  2005/10/27 18:27:40  fklar
 * + slightly improved output of method 'getMessage'
 * + added possibility to print the stack trace
 *
 */
