/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLAttrExprPair;
import de.uni_paderborn.fujaba.uml.UMLObject;


/**
 * Class AtPostVariableOOFunction
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.16 $
 */
public class AtPostVariableOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (AtPostVariableOOFunction.class);


   /**
    * Default Constructor
    */
   public AtPostVariableOOFunction() { }


   /**
    * Get the responsible attribute of the AtPostVariableOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.AT_POST_VARIABLE.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param param       No description provided
    * @param asgElement  No description provided
    * @return            an <code>FLinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement asgElement, String methodName, Object param[])
   {
      UMLAttrExprPair umlAttrExprPair = (UMLAttrExprPair) asgElement;
      UMLObject umlObject = umlAttrExprPair.getRevAttrs();

      if (log.isDebugEnabled())
      {
         log.debug (this + ".atPostVariable(" + umlAttrExprPair + ")");
      }

      LinkedList statements = new LinkedList();

      // don't assign values to elements of sets to be deleted
      if (! (umlObject.getModifier() == UMLObject.DELETE && umlObject.isSet()))
      {
         OOVariable objectVar;
         if (umlObject.isSet())
         {
            objectVar = OO.variable (umlObject.getObjectType(), OOVariableType.iFujabaTmpObject);
         }
         else
         {
            objectVar = OO.variable (umlObject.getObjectName());
         }

         OOStatement.add (statements, OO.lineComment ("assign statement"));

         if (umlObject.isOptionalAtPost() && !umlObject.isSet())
         {
            OOStatement.add (statements, OO.ifStat (OO.notNullExpr (objectVar)));
            OOStatement.add (statements, OO.startBlock());
         }

         OOMethod setMethod = OO.method (umlAttrExprPair.getName(), OOMethodType.SET_METHOD);
         OOStatement.add (statements, OO.callStat (objectVar, setMethod, OO.identifier (umlAttrExprPair.getExpression())));

         if (umlObject.isOptionalAtPost() && !umlObject.isSet())
         {
            OOStatement.add (statements, OO.endBlock ("if"));
         }

         OOStatement.add (statements, OO.emptyLine());
      }

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "AtPostVariableOOFunction[]";
   }
}

/*
 * $Log: AtPostVariableOOFunction.java,v $
 * Revision 1.16  2004/10/20 17:49:29  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
