/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.basic;

import java.util.Comparator;

import de.uni_paderborn.fujaba.metamodel.FElement;


/**
 * This class is used as a comparator for UMLIncrements to sort them by name.
 *
 * @author    $Author: zuendorf $
 * @version   $Revision: 1.12 $
 */
public class IncrementComparator implements Comparator
{
   /**
    * Constructor for class IncrementComparator
    */
   public IncrementComparator() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param o1  No description provided
    * @param o2  No description provided
    * @return    No description provided
    */
   public int compare (Object o1, Object o2)
   {
      if (o1 instanceof FElement &&
         o2 instanceof FElement)
      {
         String name1 =  ((FElement) o1).getName();
         String name2 =  ((FElement) o2).getName();

         if (name1 != null && name2 != null &&
            !name1.equals ("") &&
            !name2.equals ("") &&
            !name1.equals ("no Name") &&
            !name2.equals ("no Name"))
         {
            return name1.compareTo (name2);
         }
         else
         {
            name1 =  ((FElement) o1).toString();
            name2 =  ((FElement) o2).toString();
            if (name1 != null && name2 != null)
            {
               return name1.compareTo (name2);
            }
         } // end of else

      } // end of if ()

      if (o1 != null && o2 == null)
      {
         return 1;
      } // end of if ()

      if (o1 == null && o2 != null)
      {
         return -1;
      } // end of if ()

      if (o1 == null && o2 == null)
      {
         return 0;
      } // end of if ()

      return o1.hashCode() - o2.hashCode();
   } // compare
}

/*
 * $Log: IncrementComparator.java,v $
 * Revision 1.12  2005/03/02 13:23:20  zuendorf
 * Alt Left Right to switch between panels
 *
 */
