/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.basic;

import java.util.Iterator;
import java.util.NoSuchElementException;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author       $Author: schneider $
 * @version      $Revision: 1.9 $
 * @deprecated   please use {@link de.upb.tools.fca.IteratorConcatenation}
 */
public class CombinedIterator implements Iterator
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Iterator first = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Iterator second = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean firstDone = false;


   /**
    * Constructor for class CombinedIterator
    *
    * @param first   No description provided
    * @param second  No description provided
    */
   public CombinedIterator (Iterator first, Iterator second)
   {
      this.first = first;
      this.second = second;
      firstDone =  (first == null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public boolean hasNext()
   {
      if (!firstDone && first.hasNext())
      {
         return true;
      }

      firstDone = true;
      return  (second != null && second.hasNext());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Object next()
   {
      if (!firstDone && first.hasNext())
      {
         return first.next();
      }
      else
      {
         firstDone = true;
         if (second != null && second.hasNext())
         {
            return second.next();
         }
         else
         {
            throw new NoSuchElementException();
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void remove()
   {
      try
      {
         if (!firstDone)
         {
            first.remove();
         }
         else
         {
            second.remove();
         }
      }
      catch (IllegalStateException ise)
      {
         throw new IllegalStateException();
      }
      catch (UnsupportedOperationException uoe)
      {
         throw new UnsupportedOperationException();
      }
   }
}

/*
 * $Log: CombinedIterator.java,v $
 * Revision 1.9  2004/10/20 17:49:27  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
