/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.basic;

import java.util.ListIterator;
import java.util.NoSuchElementException;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.6 $
 */
public abstract class AbstractListIterator implements ListIterator
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int pos;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int start;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean first = true;


   /**
    * Constructor for class AbstractListIterator
    */
   public AbstractListIterator()
   {
      this (0);
   }


   /**
    * Constructor for class AbstractListIterator
    *
    * @param start  No description provided
    */
   public AbstractListIterator (int start)
   {
      if (start < 0)
      {
         start = 0;
      }
      //else if (start > size())
      //throw new IndexOutOfBoundsException();

      this.start = start;
      pos = start;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param index                       No description provided
    * @return                            No description provided
    * @throws IndexOutOfBoundsException  Exception description not provided
    */
   protected abstract Object get (int index) throws IndexOutOfBoundsException;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected abstract int size();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void reset()
   {
      pos = start;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int currentIndex()
   {
      return pos;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public boolean hasNext()
   {
      return  ( (pos < size() - 1) ||  (first && pos == size() - 1));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Object next()
   {
      if (hasNext())
      {
         if (first)
         {
            first = false;
         }
         else
         {
            pos++;
         }

         return get (pos);
      }
      else
      {
         throw new NoSuchElementException();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int nextIndex()
   {
      return  ( (first ? pos : pos + 1));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public boolean hasPrevious()
   {
      return  (pos > 0);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Object previous()
   {
      if (hasPrevious())
      {
         pos--;
         first = false;
         return get (pos);
      }
      else
      {
         throw new NoSuchElementException();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int previousIndex()
   {
      return  (pos - 1);
   }
}

/*
 * $Log: AbstractListIterator.java,v $
 * Revision 1.6  2004/10/20 17:49:26  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
