/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.asg;

import java.util.Iterator;

import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * @author    joerg
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 * @version   $Revision: 1.1.2.1 $ $Date: 2005/07/04 15:16:36 $
 */
public class ASGToolBox
{
   /**
    * Get the diagramOfDiagramItem attribute of the Utility class
    *
    * @param item  No description provided
    * @return      The diagramOfDiagramItem value
    */
   public static ASGDiagram getDiagramOfDiagramItem (ASGElement item)
   {
      ASGDiagram diag = null;
      if (item.sizeOfDiagrams() == 1)
      {
         diag = (ASGDiagram) item.iteratorOfDiagrams().next();
      }
      else
      {
         throw new RuntimeException ("INTERNAL ERROR: UMLDiagramItem "
            + item + " in more than one UMLDiagram!");
      }
      return diag;
   }


   /**
    * Get the singleSelectedDiagramItem attribute of the Utility class
    *
    * @return            The singleSelectedDiagramItem value
    * @throws Exception  Exception description not provided
    */
   public static ASGElement getSingleSelectedDiagramItem() throws Exception
   {
      // there must only be one selected UMLDiagramItem
      Iterator iter
          = SelectionManager.get().iteratorOfSelectionAsIncrements();
      LogicUnparseInterface incr;

      if (iter.hasNext())
      {
         incr = (LogicUnparseInterface) iter.next();
      }
      else
      {
         throw new Exception ("Select an item, please.");
      }
      if (iter.hasNext())
      {
         throw new Exception ("Select only one item, please.");
      }

      ASGElement item = null;
      if (incr instanceof ASGElement)
      {
         item = (ASGElement) incr;
      }
      else
      {
         throw new Exception ("Select an item, please.");
      }

      return item;
   }

}

/*
 * $Log: ASGToolBox.java,v $
 * Revision 1.1.2.1  2005/07/04 15:16:36  joerg
 * Moved usecase package to plugin module.
 *
 */
