/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.asg;

import java.awt.*;
import java.util.Iterator;
import java.util.Map;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.5 $ $Date: 2004/11/10 15:48:32 $
 */
public class ASGCollapsableUnparseInformation extends ASGUnparseInformation
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient ASGUnparseInformation sibling;


   /**
    * ASGCollapsableUnparseInformation translates old fpr files to the new
    * ASGUnparseInformation/ASGInformation structure
    *
    * @deprecated   kept only for compatibility issues
    */
   public ASGCollapsableUnparseInformation()
   {
      sibling = new ASGUnparseInformation();
   }


   /**
    * Sets the aSGElement attribute of the ASGCollapsableUnparseInformation object
    *
    * @param key    The new aSGElement value
    * @param value  The new aSGElement value
    * @return       No description provided
    */
   public boolean setASGElement (ASGElement key, ASGElement value)
   {
      if (key != null && value != null)
      {
         ASGUnparseInformation unparseInfo = value.getFromUnparseInformations (key);
         //ASGUnparseInformation exists, copy entries
         if (unparseInfo != null && unparseInfo != sibling)
         {
            Iterator iter = unparseInfo.keysOfASGInformation();
            while (iter.hasNext())
            {
               String propertyKey = (String) iter.next();
               ASGInformation existingInfo = sibling.getFromASGInformation (propertyKey);
               if (existingInfo == null)
               {
                  sibling.addToASGInformation (propertyKey, unparseInfo.getFromASGInformation (propertyKey));
               }
               else
               {
                  ASGInformation info = unparseInfo.getFromASGInformation (propertyKey);
                  Iterator iter2 = info.keysOfInformation();
                  while (iter2.hasNext())
                  {
                     String infoKey = (String) iter2.next();
                     existingInfo.addToInformation (infoKey, info.getFromInformation (infoKey));
                  }
               }
            }
         }

         sibling.setASGElement (key, value);
         return true;
      }
      return false;
   }


   /**
    * Adds a Point (location) for a specific FSAObject (propertyName), kept for
    * loading old fprs
    *
    * @param key    The object added.
    * @param value  The object added.
    * @return       No description provided
    * @deprecated   use ASGInformation
    */
   public boolean addToPoints (String key, Point value)
   {
      sibling.addToPoints (key, value);
      return true;
   }


   /**
    * Adds a Point (location) for a specific FSAObject (propertyName), kept for
    * loading old fprs
    *
    * @param entry  Map.Entry that hold the pair
    * @return       No description provided
    * @deprecated   use ASGInformation
    */
   protected boolean addToPoints (Map.Entry entry)
   {
      sibling.addToPoints (entry);
      return true;
   }
}

/*
 * $Log: ASGCollapsableUnparseInformation.java,v $
 * Revision 1.5  2004/11/10 15:48:32  cschneid
 * fixed storage of layout (UnparseInformation)
 *
 */
