/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;

import javax.swing.*;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.FujabaApp;
import de.uni_paderborn.fujaba.basic.CommandLineParser;
import de.uni_paderborn.fujaba.basic.ProcessOutputViewer;
import de.uni_paderborn.fujaba.gui.ComboDialog;
import de.uni_paderborn.fujaba.gui.FileComboDialog;
import de.uni_paderborn.fujaba.metamodel.FFile;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.lib.plugins.PluginJarFile;
import de.upb.lib.plugins.PluginManager;


/**
 * Run a Java Class
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.21.2.2 $
 */
public class RunAction extends AbstractAction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (RunAction.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static volatile FileComboDialog myFile;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      String file = selectMainClass();

      if (file != null)
      {
         FrameMain frameMain = FrameMain.get();

         String expPath = GeneralPreferences.get().getExportFolder();
         String userCmdLine;
         String pathSeparator = System.getProperty ("path.separator");
         String fileSeparator = System.getProperty ("file.separator");

         frameMain.setCursorWait();

         String classPath = getClassPath (expPath, pathSeparator, true);

         //Add all Packages to compile
         Iterator iter = UMLProject.get().iteratorOfFiles();
         StringBuffer compileDirs = new StringBuffer();

         while (iter.hasNext())
         {
            FFile curFile = (FFile) iter.next();
            if (!curFile.isCodeGenDenied() && curFile.necessaryToCreateFile())
            {
               FPackage pack = curFile.getFPackage();
               StringBuffer packageDir = new StringBuffer();

               if (pack != null)
               {
                  packageDir.append (expPath);

                  if (pack.getPackagePath().trim().equals ("."))
                  {
                     packageDir.append (fileSeparator + "*.java");
                  }
                  else
                  {
                     packageDir.append (fileSeparator + pack.getPackagePath() + fileSeparator + "*.java");
                  }

                  if (compileDirs.indexOf (packageDir.toString()) == -1)
                  {
                     if (System.getProperty ("os.name").startsWith ("Windows"))
                     {
                        compileDirs.append ("\"" + packageDir.toString() + "\" ");
                     }
                     else
                     {
                        compileDirs.append (packageDir.toString() + " ");
                     }
                  }
               }
            }
         }

         boolean win32 = System.getProperty ("os.name").startsWith ("Windows");

         userCmdLine = "java ";
         String outPath = "";
         if (outPath.length() != 0)
         {
            userCmdLine += " -d ";

            if (win32)
            {
               userCmdLine += "\""; //Support for long file and directory names
            }

            userCmdLine += outPath;

            if (win32)
            {
               userCmdLine += "\""; //Support for long file and directory names
            }
         }

         userCmdLine += " -classpath ";

         if (win32)
         {
            userCmdLine += "\""; //Support for long file and directory names
         }

         userCmdLine += classPath;

         if (win32)
         {
            userCmdLine += "\" "; //Support for long file and directory names
         }
         else
         {
            userCmdLine += " ";
         }

         userCmdLine += file;

         try
         {
            ProcessOutputViewer myView = new ProcessOutputViewer();
            //myView.setMouseListener (new CompileRunMouseListener());

            if (e == null)
            {
               myView.compileAndWaitForResult (userCmdLine);
            }
            else
            {
               myView.executeCommand (userCmdLine);
            }
         }
         finally
         {
            frameMain.setCursorDefault();
         }
      }
   } // actionPerformed


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static String selectMainClass()
   {
      CommandLineParser myParser = null;

      String expPath = GeneralPreferences.get().getExportFolder();
      myParser = new CommandLineParser (expPath, "*.class", CommandLineParser.PATH_LIST);

      if (myFile == null)
      {
         myFile = new FileComboDialog (null, "Please choose a class:",
            "Run", null);
      }

      myFile.setFileList (myParser.getFileArray());

      myFile.show();

      if (myFile.getSelectedFile() != null &&  (myFile.getPressed() != ComboDialog.CANCEL_PRESSED))
      {
         String inputValue = myFile.getSelectedFile().getName();
         inputValue = inputValue.substring (0, inputValue.lastIndexOf (".class"));
         return inputValue.trim();
      }
      else
      {
         return null;
      }
   }


   /**
    * Get the classPath attribute of the RunAction class
    *
    * @param exportPath                No description provided
    * @param pathSeparator             No description provided
    * @param includingSystemClassPath  No description provided
    * @return                          The classPath value
    */
   public static String getClassPath (String exportPath, String pathSeparator, boolean includingSystemClassPath)
   {
      StringBuffer classPath = new StringBuffer();

      String fileSeparator = System.getProperty ("file.separator");

      PluginManager pluginManager = FujabaApp.getPluginManager();
      Iterator iter = pluginManager.iteratorOfJarFiles();
      while (iter.hasNext())
      {
         PluginJarFile jarFile = (PluginJarFile) iter.next();
         String jarFileName = jarFile.getFileName();
         if (jarFileName.endsWith (".xml"))
         {
            if (jarFile.getProperty() != null)
            {
               jarFileName = jarFileName.substring (0, jarFileName.lastIndexOf (fileSeparator) + 1)
                  + jarFile.getProperty().getPluginJarFile();
            }
            else
            {
               jarFileName = null;
            }
         }
         if (jarFileName != null)
         {
            classPath.append (jarFileName + pathSeparator);
         }
      }

      classPath.append (exportPath + pathSeparator);

      if (includingSystemClassPath)
      {

         String cp = System.getProperty ("java.class.path");
         if (log.isInfoEnabled())
         {
            log.info ("system property java.class.path: " + System.getProperty ("java.class.path"));
         }

         if (!System.getProperty ("file.separator").equals (pathSeparator))
         {
            cp = cp.replaceAll ("\"" + System.getProperty ("file.separator") + "\"", pathSeparator);
         }

         if (cp == null)
         {
            JOptionPane.showMessageDialog (FrameMain.get(), "Java classpath system property not set! \n" +
               "Using Fujaba path as default.", "Compile",
               JOptionPane.ERROR_MESSAGE);
            classPath.append (System.getProperty ("user.dir"));
         }

         classPath.append (cp + pathSeparator);
      }

      classPath.append ("libs" + fileSeparator + "RuntimeTools.jar" + pathSeparator
         + "libs" + fileSeparator + "junit.jar");

      return classPath.toString();
   }

}

/*
 * $Log: RunAction.java,v $
 * Revision 1.21.2.2  2005/09/30 18:44:21  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
