/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app.action;

import java.awt.event.ActionEvent;
import java.io.FileWriter;

import javax.swing.*;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.basic.ProcessOutputViewer;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * Creates a jar from class files
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.16.2.1 $
 */
public class CreateJarAction extends AbstractAction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (CreateJarAction.class);


   /**
    * perform action
    *
    * @param e  event
    */
   public void actionPerformed (ActionEvent e)
   {
      String expPath = GeneralPreferences.get().getExportFolder();
      String userCmdLine;
      String fileSeparator = System.getProperty ("file.separator");

      String expDir = expPath;
      expPath += fileSeparator;

      //select main class
      String mainClass = RunAction.selectMainClass();
      if (mainClass != null && mainClass.startsWith (expPath))
      {
         mainClass = mainClass.substring (expPath.length());
      }
      if (log.isInfoEnabled())
      {
         log.info ("Main-Class = " + mainClass);
      }

      //get class-path
      String classPath = RunAction.getClassPath (expPath, ";", false);
      classPath = "\"" + classPath.replaceAll (";", "\" \"") + "\"";

      //create manifest
      String manifestName = expPath + "MANIFEST.PRJ";
      try
      {
         FileWriter fw = new FileWriter (manifestName);

         fw.write ("Implementation-Title: " + UMLProject.get().getName() + "\n");
         if (mainClass != null)
         {
            fw.write ("Main-Class: " + mainClass + "\n");
         }

         //fw.write("Class-Path: " + classPath + "\n" );
         fw.write ("Class-Path: Fujaba.jar FujabaLibraries.jar libs/RuntimeTools.jar\n");

         fw.close();
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
         log.error ("failed to create MANIFEST.PRJ in export path - using Fujabas MANIFEST");
         manifestName = "MANIFEST";
      }

      //create jar
      userCmdLine = "jar cvfm \"" + expPath + "../" + UMLProject.get().getName() + ".jar\" \"" + manifestName + "\" -C \"" + expDir + "\" .";

      ProcessOutputViewer myView = new ProcessOutputViewer();
      myView.executeCommand (userCmdLine);
   }
}

/*
 * $Log: CreateJarAction.java,v $
 * Revision 1.16.2.1  2005/09/30 18:44:21  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
