/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app.action;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

import javax.swing.JTextArea;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.basic.IncrSelector;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public class CompileRunMouseListener extends MouseAdapter
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (CompileRunMouseListener.class);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void mouseClicked (MouseEvent event)
   {
      JTextArea normalOutput = (JTextArea) event.getSource();
      int pos = normalOutput.getCaret().getDot();
      String line = "";
      int off = -1;
      try
      {
         off = normalOutput.getLineOfOffset (pos);
      }
      catch (javax.swing.text.BadLocationException e)
      {
         log.error ("Error in CaretListener");
         return;
      }

      boolean done = false;
      while ( (off >= 0) && !done)
      {
         try
         {
            int start = normalOutput.getLineStartOffset (off);
            int end = normalOutput.getLineEndOffset (off);
            line = normalOutput.getText (start, end - start).trim();
         }
         catch (javax.swing.text.BadLocationException e)
         {
            log.error ("Error in CaretListener");
            return;
         }
         if (line.startsWith ("at "))
         {
            line = line.substring (line.lastIndexOf ("(") + 1, line.indexOf (")"));
         }
         StringTokenizer st = new StringTokenizer (line, ":");
         if (st.countTokens() >= 1)
         {
            String file = st.nextToken();
            if ( (file.length() == 1) &&  (st.countTokens() > 1))
            {
               file += ":" + st.nextToken();
            }
            try
            {
               String lineNrSt = st.nextToken (" :");
               String error;
               if (st.hasMoreTokens())
               {
                  error = st.nextToken().trim();
               }
               else
               {
                  do
                  {
                     try
                     {
                        off--;
                        int start = normalOutput.getLineStartOffset (off);
                        int end = normalOutput.getLineEndOffset (off);
                        line = normalOutput.getText (start, end - start).trim();
                     }
                     catch (javax.swing.text.BadLocationException e)
                     {
                        log.error ("Error in CaretListener");
                     }
                  } while (line.startsWith ("at "));
                  error = line;
               }
               if (file.endsWith (".java"))
               {
                  try
                  {
                     int lineNr = Integer.parseInt (lineNrSt);
                     String id = CompileAction.getIncrementIdForGeneratedCodeLine (file, lineNr);
                     IncrSelector.get().selectIncrByID (id);
                     FrameMain.get().setStatusLabel ("Error: " + error);
                     done = true;
                  }
                  catch (NumberFormatException e)
                  {
                     e.printStackTrace();
                  }
               }
            }
            catch (NoSuchElementException e)
            {
            }
         }
         off--;
      }
   }

}

/*
 * $Log: CompileRunMouseListener.java,v $
 * Revision 1.11  2005/02/24 15:54:53  lowende
 * Removed some compile warnings.
 *
 */
