/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app;

import java.awt.*;


/**
 * A column layout manager for JPanels.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 */
public class PanelColumnLayout implements LayoutManager
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int xInset = 5;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int yInset = 5;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int yGap = 2;


   /**
    * Access method for an one to n association.
    *
    * @param s  The object added.
    * @param c  The object added.
    */
   public void addLayoutComponent (String s, Component c) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param c  No description provided
    */
   public void layoutContainer (Container c)
   {
      Insets insets = c.getInsets();
      int height = yInset + insets.top;

      Component[] children = c.getComponents();
      Dimension compSize = null;
      for (int i = 0; i < children.length; i++)
      {
         compSize = children[i].getPreferredSize();
         children[i].setSize (compSize.width, compSize.height);
         children[i].setLocation (xInset + insets.left, height);
         height += compSize.height + yGap;
      }

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param c  No description provided
    * @return   No description provided
    */
   public Dimension minimumLayoutSize (Container c)
   {
      Insets insets = c.getInsets();
      int height = yInset + insets.top;
      int width = 0 + insets.left + insets.right;

      Component[] children = c.getComponents();
      Dimension compSize = null;
      for (int i = 0; i < children.length; i++)
      {
         compSize = children[i].getPreferredSize();
         height += compSize.height + yGap;
         width = Math.max (width, compSize.width + insets.left + insets.right + xInset * 2);
      }
      height += insets.bottom;

      return new Dimension (width, height);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param c  No description provided
    * @return   No description provided
    */
   public Dimension preferredLayoutSize (Container c)
   {
      return minimumLayoutSize (c);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param c  No description provided
    */
   public void removeLayoutComponent (Component c) { }

}

/*
 * $Log: PanelColumnLayout.java,v $
 * Revision 1.10  2004/10/20 17:49:23  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
