/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;

import java.util.Vector;

import javax.swing.*;

import de.uni_paderborn.fujaba.basic.FD;
import de.uni_paderborn.fujaba.preferences.DebugPreferences;
import de.uni_paderborn.fujaba.preferences.PlugInsPreferences;
import de.uni_paderborn.fujaba.preferences.gui.ServerListParser;
import de.upb.lib.plugins.KernelInterface;
import de.upb.lib.plugins.PluginManager;


/**
 * @author    sinan To change the template for this generated type comment go to Window&gt;Preferences&gt;Java&gt;Code
 *      Generation&gt;Code and Comments
 * @version   $Revision: 1.5 $ $Date: 2005/03/08 09:49:32 $
 */
public class KernelInterfaceImpl implements KernelInterface
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Version fujabaVersion = Version.get();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PluginManager manager;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static volatile KernelInterfaceImpl theInstance;


   /**
    * Constructor for class KernelInterfaceImpl
    */
   private KernelInterfaceImpl()
   {
      manager = PluginManager.getInstance (this);
      if (FD.isOn (DebugPreferences.DEBUG_LEVEL_PLUGINS))
      {
         manager.setDebugLevel (PluginManager.DEBUG_ON);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static KernelInterfaceImpl get()
   {
      if (theInstance == null)
      {
         theInstance = new KernelInterfaceImpl();
      }
      return theInstance;
   }


   /**
    * Get the majorVersion attribute of the KernelInterfaceImpl object
    *
    * @return   The majorVersion value
    */
   public int getMajorVersion()
   {
      return fujabaVersion.getMajor();
   }


   /**
    * Get the minorVersion attribute of the KernelInterfaceImpl object
    *
    * @return   The minorVersion value
    */
   public int getMinorVersion()
   {
      return fujabaVersion.getMinor();
   }


   /**
    * Get the buildNumber attribute of the KernelInterfaceImpl object
    *
    * @return   The buildNumber value
    */
   public int getBuildNumber()
   {
      return fujabaVersion.getBuild();
   }


   /**
    * Get the revisionNumber attribute of the KernelInterfaceImpl object
    *
    * @return   The revisionNumber value
    */
   public int getRevisionNumber()
   {
      return fujabaVersion.getRevision();
   }


   /**
    * Get the pluginServerURLs attribute of the KernelInterfaceImpl object
    *
    * @return   The pluginServerURLs value
    */
   public Vector getPluginServerURLs()
   {
      Vector urls = PlugInsPreferences.get().getPluginDownloadURLs();
      if (urls.size() == 0)
      {
         // no urls specified - try to download the list of servers
         try
         {
            ServerListParser serverListParser = new ServerListParser();
            Iterator urlIter = serverListParser.getURLs (new URL (PlugInsPreferences.PLUGIN_SERVER_LIST));
            if (urlIter != null)
            {
               while (urlIter.hasNext())
               {
                  urls.add (urlIter.next());
               }
               PlugInsPreferences.get().setPluginDownloadURLs (urls);
            }
            else
            {
               JOptionPane.showMessageDialog (FrameMain.get(), "An error occurred while retrieving the server list." +
                  " Are you connected to the Internet? Consult the console for a more detailed message.", "Error", JOptionPane.ERROR_MESSAGE);
            }
         }
         catch (MalformedURLException e)
         {
            JOptionPane.showMessageDialog (FrameMain.get(), "An internal error occurred while retrieving the server list." +
               " Please inform the Fujaba developers: " + e.toString(), "Error", JOptionPane.ERROR_MESSAGE);
         }
      }
      return urls;
   }


   /**
    * Get the manager attribute of the KernelInterfaceImpl object
    *
    * @return   The manager value
    */
   public PluginManager getManager()
   {
      return manager;
   }

}

/*
 * $Log: KernelInterfaceImpl.java,v $
 * Revision 1.5  2005/03/08 09:49:32  cschneid
 * plugins server list downloaded if empty (empty by default)
 *
 */
