/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app;

import javax.swing.*;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.8.2.1 $
 */
public class FujabaDialogTest
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (FujabaDialogTest.class);


   /**
    * The main program for the FujabaDialogTest class
    *
    * @param args  The command line arguments
    */
   public static void main (String[] args)
   {
      if (args.length != 1)
      {
         if (log.isInfoEnabled())
         {
            log.info ("call FujabaDialogTest with the dialog to show");
         }
         return;
      }

      try
      {
         Class cls = Class.forName (args[0]);
         Object obj = cls.newInstance();
         if (obj instanceof FujabaDialog)
         {
             ((FujabaDialog) obj).showCentered();
         }
         else if (obj instanceof JDialog)
         {
             ((JDialog) obj).show();
         }
         else
         {
            if (log.isInfoEnabled())
            {
               log.info (args[0] + "is not a dialog!");
            }
         }
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
   }
}

/*
 * $Log: FujabaDialogTest.java,v $
 * Revision 1.8.2.1  2005/09/30 18:39:54  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
