/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.ant;

import java.io.File;

import org.apache.tools.ant.BuildException;

import de.uni_paderborn.fujaba.codegen.CodeGenFactory;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * generate source code for input fprfile to destination directory.
 * <p>
 *
 * @author    $Author$
 * @version   $Revision$
 */
public class FprGenTask extends AbstractGenTask
{

   /**
    * the fujaba project filename
    */
   private String fprFilename = null;


   /**
    * try to generate code for <code>fprFilename</code> to directory <code>destDirname</code> .
    */
   protected void executeImpl()
   {
      File fprFile = new File (getFprFilename());

      UMLProject fprProject = UMLProject.loadProject (fprFile);

      File destDir = new File (getDestDirname());

      // set new destination directory
      fprProject.setRootDir (destDir.getAbsolutePath());

      // generate complete project
      CodeGenFactory.get().generateFProject (fprProject);

   }


   /**
    * validate task input configuration.
    *
    * @throws BuildException  if configuration is invalid .
    */
   protected void validate()
   {
      super.validate();
      // check for existing fpr file
      File fprFile = new File (getFprFilename());

      if (!fprFile.exists())
      {
         throw new BuildException ("fprFile:'" + fprFile.getAbsolutePath() + "' does not exist.");
      }
   }


   /**
    * @return   Returns the fprFilename.
    */
   public String getFprFilename()
   {
      return this.fprFilename;
   }


   /**
    * @param fprFilename  The fprFilename to set.
    */
   public void setFprFilename (String fprFilename)
   {
      if (this.fprFilename != fprFilename)
      {
         this.fprFilename = fprFilename;
      }
   }

}

/*
 * $Log$
 * Revision 1.1.2.6  2006/03/03 16:21:03  lowende
 * Compile warnings removed.
 *
 */
