/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.upb.lib.userinterface;

import java.util.Iterator;

import javax.swing.*;


/**
 * @author    $Author: lowende $
 * @version   $Revision: 1.9 $
 */
/*
 *  package
 */
class ToolbarContainer extends SectionContainer
{
   /**
    * Constructor for class ToolbarContainer
    *
    * @param id  No description provided
    */
   public ToolbarContainer (String id)
   {
      setId (id);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean rolloverButtons = false;


   /**
    * Sets the rolloverButtons attribute of the ToolbarContainer object
    *
    * @param value  The new rolloverButtons value
    */
   public void setRolloverButtons (boolean value)
   {
      rolloverButtons = value;
   }


   /**
    * Get the rolloverButtons attribute of the ToolbarContainer object
    *
    * @return   The rolloverButtons value
    */
   public boolean isRolloverButtons()
   {
      return rolloverButtons;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public JComponent generateComponent()
   {
      JToolBar toolBar = new JToolBar();

      if (getName() != null)
      {
         toolBar.setName (getName());
      }
      toolBar.setVisible (isVisible());

      Iterator iter = iteratorOfSections();
      while (iter.hasNext())
      {
         Section section = (Section) iter.next();

         Iterator iterItems = section.iteratorOfItems();
         while (iterItems.hasNext())
         {
            SectionItem sectionItem = (SectionItem) iterItems.next();
            AbstractButton button = (AbstractButton) sectionItem.generateComponent();
            toolBar.add (button);

            // Workaround for swing bug, button looses rolloverEnabled property
            // after adding it to a JToolBar
            if (isRolloverButtons())
            {
               button.setRolloverEnabled (true);
            }
         }

         if (iter.hasNext())
         {
            toolBar.addSeparator();
         }
      }

      return toolBar;
   } // generateComponent

}

/*
 * $Log: ToolbarContainer.java,v $
 * Revision 1.9  2004/08/02 07:34:15  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
