/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.upb.lib.userinterface;

import java.util.Iterator;

import de.upb.tools.fca.*;


/**
 * <h2>Associations</h2> <pre>
 *                  ------ 0..1        sections         0..1
 * SectionContainer | id |----------------------------------- Section
 *                  ------ container   {ordered}    sections
 * </pre>
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.7 $
 */
/*
 *  package
 */
abstract class SectionContainer extends SectionItem
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String name = "";


   /**
    * Get the name attribute of the SectionContainer object
    *
    * @return   The name value
    */
   public String getName()
   {
      return this.name;
   }


   /**
    * Sets the name attribute of the SectionContainer object
    *
    * @param newName  The new name value
    */
   public void setName (String newName)
   {
      if ( (this.name == null) ||  (this.name != null && !this.name.equals (newName)))
      {
         this.name = newName;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean visible = true;


   /**
    * Sets the visible attribute of the SectionContainer object
    *
    * @param value  The new visible value
    */
   public void setVisible (boolean value)
   {
      this.visible = value;
   }


   /**
    * Get the visible attribute of the SectionContainer object
    *
    * @return   The visible value
    */
   public boolean isVisible()
   {
      return visible;
   }


   /**
    * <pre>
    *                  ------ 0..1        sections         0..1
    * SectionContainer | id |----------------------------------- Section
    *                  ------ container   {ordered}    sections
    * </pre>
    */
   private FHashMap sections;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInSections (Section value)
   {
      return  ( (this.sections != null) &&
          (value != null) &&  (value.getId() != null) &&
          (this.sections.get (value.getId()) == value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public boolean hasKeyInSections (String key)
   {
      return  ( (this.sections != null) &&
          (key != null) &&
         this.sections.containsKey (key));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfSections()
   {
      return  ( (this.sections == null)
         ? FEmptyIterator.get()
         : this.sections.values().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator keysOfSections()
   {
      return  ( (this.sections == null)
         ? FEmptyIterator.get()
         : this.sections.keySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator entriesOfSections()
   {
      return  ( (this.sections == null)
         ? FEmptyIterator.get()
         : this.sections.entrySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfSections()
   {
      return  ( (this.sections == null)
         ? 0
         : this.sections.size());
   }


   /**
    * Get the fromSections attribute of the SectionContainer object
    *
    * @param key  No description provided
    * @return     The fromSections value
    */
   public Section getFromSections (String key)
   {
      return  ( ( (this.sections == null) ||  (key == null))
         ? null
         : (Section) this.sections.get (key));
   }


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToSections (Section value)
   {
      boolean changed = false;
      if ( (value != null) &&  (value.getId() != null))
      {
         if (this.sections == null)
         {
            this.sections = new FHashMap();
         }
         Section oldValue = (Section) this.sections.put (value.getId(), value);
         if (oldValue != value)
         {
            if (oldValue != null)
            {
               oldValue.setContainer (null);
            }
            value.setContainer (this);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromSections (Section value)
   {
      boolean changed = false;
      if ( (this.sections != null) &&  (value != null) &&  (value.getId() != null))
      {
         Section oldValue = (Section) this.sections.get (value.getId());
         if (oldValue == value)
         {
            this.sections.remove (value.getId());
            value.setContainer (null);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public boolean removeKeyFromSections (String key)
   {
      boolean changed = false;
      if ( (this.sections != null) &&  (key != null))
      {
         Section tmpValue = (Section) this.sections.get (key);
         if (tmpValue != null)
         {
            this.sections.remove (key);
            tmpValue.setContainer (null);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromSections()
   {
      Section tmpValue;
      Iterator iter = this.iteratorOfSections();
      while (iter.hasNext())
      {
         tmpValue = (Section) iter.next();
         this.removeFromSections (tmpValue);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      removeAllFromSections();
   }

}

/*
 * $Log: SectionContainer.java,v $
 * Revision 1.7  2004/08/02 07:34:15  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
