/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.upb.lib.userinterface;

import java.util.Iterator;
import java.util.Map;

import javax.swing.*;

import org.apache.log4j.Logger;
import de.upb.lib.plugins.PluginManager;

import de.upb.tools.fca.FHashMap;


/**
 * @author    $Author: schneider $
 * @version   $Revision: 1.11 $
 */
/*
 *  package
 */
class MenuContainer extends SectionContainer
{
   /**
    * Constructor for class MenuContainer
    *
    * @param id  No description provided
    */
   public MenuContainer (String id)
   {
      setId (id);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int mnemonic;


   /**
    * Sets the mnemonic attribute of the MenuContainer object
    *
    * @param value  The new mnemonic value
    */
   public void setMnemonic (int value)
   {
      this.mnemonic = value;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Icon icon;


   /**
    * Sets the icon attribute of the MenuContainer object
    *
    * @param value  The new icon value
    */
   public void setIcon (Icon value)
   {
      this.icon = value;
   }


   /**
    * logging
    */
   private final static Logger LOGGER = Logger.getLogger (PluginManager.class);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public JComponent generateComponent()
   {
      JMenu menu = new JMenu();

      Map mnemonics = new FHashMap();
      boolean hadCollision = false;
      StringBuffer mnemonicsText = new StringBuffer();

      if (getName() != null)
      {
         menu.setText (getName());
      }
      else
      {
         menu.setText (getId());
      }

      menu.setVisible (isVisible());
      menu.setEnabled (isVisible());
      menu.setMnemonic (mnemonic);
      menu.setIcon (icon);

      Iterator iter = iteratorOfSections();
      while (iter.hasNext())
      {
         Section section = (Section) iter.next();

         ButtonGroup buttonGroup = null;

         Iterator iterItems = section.iteratorOfItems();
         while (iterItems.hasNext())
         {
            SectionItem sectionItem = (SectionItem) iterItems.next();
            JComponent component = sectionItem.generateComponent();
            menu.add (component);
            if (component instanceof JMenuItem)
            {
               JMenuItem item = (JMenuItem) component;
               final Action action = item.getAction();
               if (action != null)
               {
                  Integer mnemonic = (Integer) action.getValue (Action.MNEMONIC_KEY);
                  if (mnemonic != null && mnemonic.intValue() != -1)
                  {
                     mnemonicsText.append ((char) mnemonic.intValue());
                     Action collidingAction = (Action) mnemonics.get (mnemonic);
                     if (collidingAction == null)
                     {
                        mnemonics.put (mnemonic, action);
                     }
                     else
                     {
                        LOGGER.error ("Action '" + action.getValue ("id") + "' has same mnemonic as" +
                           " '" + collidingAction.getValue ("id") + "' in menu" +
                           " '" + this.getId() + "'");
                        action.putValue (Action.MNEMONIC_KEY, new Integer (-1));
                        hadCollision = true;
                     }
                  }
               }
            }

            if (component instanceof JRadioButtonMenuItem)
            {
               if (buttonGroup == null)
               {
                  buttonGroup = new ButtonGroup();
               }
               buttonGroup.add ((AbstractButton) component);
            }
         }

         if (iter.hasNext())
         {
            menu.addSeparator();
         }
      }

      if (hadCollision)
      {
         LOGGER.error ("used mnemonics in menu" +
            " '" + this.getId() + "': " + mnemonicsText);
      }

      return menu;
   } // generateComponent

}

/*
 * $Log: MenuContainer.java,v $
 * Revision 1.11  2004/10/04 13:27:28  schneider
 * report used mnemonics
 *
 */
