/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.upb.lib.userinterface;




/**
 * This class is meant to be the interface between the userinterface framework and the application
 * using this framework. The application uses this interface to pass information to the performed
 * action about the object the action is related to.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.5 $
 */
public interface EventSource
{
   /**
    * Returns the object that originated the event. This could be an iterator for a whole selection
    * of objects. Handed over to the action by the event.
    *
    * @return   The source value
    */
   public Object getSource();


   /**
    * Handed over to the action as the command string for the event. This string allows a "modal"
    * component to specify one of several commands, depending on its state. For example, a
    * single button might toggle between "show details" and "hide details". The source object
    * and the event would be the same in each case, but the command string would identify the
    * intended action.
    *
    * @return   The actionCommand value
    */
   public String getActionCommand();

}

/*
 * $Log: EventSource.java,v $
 * Revision 1.5  2004/08/02 07:34:15  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
