/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.upb.lib.plugins;

import java.io.*;
import java.util.jar.*;


/**
 * Stores a jar file needed by a plugin.
 *
 * @author    Student research group Reddmom
 * @version   $Revision: 1.7 $
 */
public class PluginJarFile
{
   /**
    * Role attribute of the directed file association between the PluginJarFile and the File.
    * <pre>
    *       0..1       file       0..1
    * File <--------------------------- PluginJarFile
    *       file         pluginJarFile
    * </pre>
    */
   private File file;


   /**
    * Access method to get the file.
    *
    * @return   the file
    */
   public File getFile()
   {
      return this.file;
   }


   /**
    * Access method to set the file.
    *
    * @param value  the new file
    * @return       true if the file was set
    */
   public boolean setFile (File value)
   {
      boolean changed = false;
      if ( (this.file == null && value != null) ||
          (this.file != null && !this.file.equals (value)))
      {
         this.file = value;
         changed = true;
      }

      return changed;
   }


   /**
    * The file name of the jar file.
    */
   private String fileName = "";


   /**
    * Access method to get the file name.
    *
    * @return   the file name
    */
   public String getFileName()
   {
      return this.fileName;
   }


   /**
    * returns an InputStream to read the specified jar entry.
    *
    * @param name  the name of the Jar Entry.
    * @return      the input stream
    */
   public InputStream getEntryStream (String name)
   {
      InputStream retStream = null;
      JarFile tmpJar = null;
      JarEntry tmpEntry = null;

      if (getFile() != null)
      {
         try
         {
            tmpJar = new JarFile (getFile());
            tmpEntry = tmpJar.getJarEntry (name);
            if (tmpEntry != null)
            {
               retStream = tmpJar.getInputStream (tmpEntry);
            } // end of if ()
         }
         catch (Throwable e)
         {

         } // end of catch
      } // end of if ()
      return retStream;
   } // getEntryStream


   /**
    * Access method to set a new file name.
    *
    * @param newFileName  the new file name
    */
   public void setFileName (String newFileName)
   {
      if ( (this.fileName == null) ||
          (this.fileName != null &&
         !this.fileName.equals (newFileName)))
      {
         this.fileName = newFileName;
      }
   }


   /**
    * Role attribute of the jarFiles association between PluginProperty and PluginJarFile.
    * <pre>
    *                 0..1    jarFiles     n
    * PluginProperty ------------------------ PluginJarFile
    *                 property      jarFiles
    * </pre>
    */
   private PluginProperty property;


   /**
    * Access method to get the property.
    *
    * @return   the property
    */
   public PluginProperty getProperty()
   {
      return this.property;
   }


   /**
    * Access method to set the property.
    *
    * @param value  the new property
    * @return       true if the property was set
    */
   public boolean setProperty (PluginProperty value)
   {
      boolean changed = false;
      if (this.property != value)
      {
         if (this.property != null)
         {
            PluginProperty oldValue = this.property;
            this.property = null;
            oldValue.removeFromJarFiles (this);
         }
         this.property = value;
         if (value != null)
         {
            value.addToJarFiles (this);
         }
         changed = true;
      }

      return changed;
   }


   /**
    * Role attribute of the jarFiles associtiation between the PluginManager and PluginJarFile.
    * <pre>
    *               ------------ 0..1   jarFiles   0..1
    * PluginManager | fileName |------------------------ PluginJarFile
    *               ------------ manager       jarFiles
    * </pre>
    */
   private PluginManager manager;


   /**
    * Access method to set a new Manager.
    *
    * @param value  the new manager
    * @return       true if the manager was set
    */
   public boolean setManager (PluginManager value)
   {
      boolean changed = false;
      if (this.manager != value)
      {
         if (this.manager != null)
         {
            PluginManager oldValue = this.manager;
            this.manager = null;
            oldValue.removeFromJarFiles (this);
         }
         this.manager = value;
         if (value != null)
         {
            value.addToJarFiles (this);
         }
         changed = true;
      }

      return changed;
   }


   /**
    * Access method to get the current PluginManager.
    *
    * @return   the currently PluginManager.
    */
   public PluginManager getManager()
   {
      return this.manager;
   }


   /**
    * Remove all references to other instances so that the garbage collector can free this
    * instance.
    */
   public void removeYou()
   {
      PluginManager tmpManager = getManager();
      if (tmpManager != null)
      {
         setManager (null);
      }

      PluginProperty tmpProperty = getProperty();
      if (tmpProperty != null)
      {
         setProperty (null);
      }

      File tmpFile = getFile();
      if (tmpFile != null)
      {
         setFile (null);
      }
   } // removeYou

}

/*
 * $Log: PluginJarFile.java,v $
 * Revision 1.7  2004/08/02 07:34:14  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
