/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.upb.lib.plugins;

import java.util.Iterator;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JOptionPane;


/**
 * No comment provided by developer, please add a comment to improve
 * documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12 $
 */
public final class PluginDownloader
{
   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    */
   public final static int NEW_PLUGIN = 0;

   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    */
   public final static int UPDATE_PLUGIN = 1;

   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    */
   public final static int UP_TO_DATE_PLUGIN = 2;


   /**
    * Retrieves all available plugins on the different servers and returns a
    * vector with an entry of all plugins of each site.
    *
    * @param manager  No description provided
    * @return         A vector of vectors. For the format of the contained vectors
    * 	see XMLToPluginProperties#parsePluginList(String)
    */
   public final static Vector getDownloadablePlugins (PluginManager manager)
   {
      Vector allPlugins = null;
      try
      {
         Vector urlVector = manager.getKernelInterface().getPluginServerURLs();
         allPlugins = new Vector (urlVector.size());

         for (int i = 0; i < urlVector.size(); i++)
         {
            XMLToPluginProperty parser = new XMLToPluginProperty (manager);
            Vector parsedPlugins = parser.parsePluginList ((String) urlVector.elementAt (i));
            allPlugins.add (parsedPlugins);
         }
      }
      catch (Exception ex)
      {
         JOptionPane.showMessageDialog (new JFrame(),
            "<html>An error is occured while generating download information<br>" + "Error: "
            + ex + "</html>", "Error", JOptionPane.ERROR_MESSAGE);
         ex.printStackTrace();
      }

      return allPlugins;
   }


   /**
    * Get the pluginState attribute of the PluginDownloader object
    *
    * @param pluginProperty  No description provided
    * @param manager         No description provided
    * @return                The pluginState value
    */
   public final static int getPluginState (PluginProperty pluginProperty, PluginManager manager)
   {
      PluginProperty loadedPlugin = null;

      if (manager.getFromProperties (pluginProperty.getPluginID()) == null)
      {
         return NEW_PLUGIN;
      }
      else
      {
         // plug-in is loaded. Is there an update
         loadedPlugin = manager.getFromProperties (pluginProperty.getPluginID());
         if (loadedPlugin.getMajor() < pluginProperty.getMajor()
            || loadedPlugin.getMinor() < pluginProperty.getMinor()
            || loadedPlugin.getBuildNumber() < pluginProperty.getBuildNumber())
         {
            return UPDATE_PLUGIN;
         }
         else
         {
            return UP_TO_DATE_PLUGIN;
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String INSTALLED_PLUGIN = "Installed Plugins";


   /**
    * @param manager
    * @return         Vector of all installed plugins. First element is a String.
    */
   public final static Vector getInstalledPlugins (PluginManager manager)
   {
      Vector result = new Vector();

      result.add (INSTALLED_PLUGIN);

      Iterator iter = manager.iteratorOfProperties();

      while (iter.hasNext())
      {
         result.add (iter.next());
      }

      return result;
   }

}

/*
 * $Log: PluginDownloader.java,v $
 * Revision 1.12  2006/02/07 17:04:13  lowende
 * Applied patch send by Felix Klar: Connection error handling in plugin download dialog enhanced.
 *
 */
