/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.upb.lib.plugins;

import java.util.Vector;


/**
 * @author    alptekin
 * @version   $Revision: 1.1 $
 */
public interface KernelInterface
{
   /**
    * returns the kernel major number
    *
    * @return   kernelMajorNumber
    */
   public int getMajorVersion();


   /**
    * returns the kernel minor number
    *
    * @return   kernelMinorNumber
    */
   public int getMinorVersion();


   /**
    * returns the kernel build number
    *
    * @return   kernelBuildNumber
    */
   public int getBuildNumber();


   /**
    * returns kernel revision number
    *
    * @return   kernelRevisionNumber
    */
   public int getRevisionNumber();


   /**
    * returns a vector (list) of plug-in servers. The entries are String objects representing
    * an URL
    *
    * @return   pluginServerURLs
    */
   public Vector getPluginServerURLs();

}

/*
 * $Log: KernelInterface.java,v $
 * Revision 1.1  2004/02/24 12:28:41  alptekin
 * making plugin mechanism independent, adding interface to be used by all apps (Fujaba,Dobs etc.), new gui
 *
 */
