/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.upb.lib.plugins;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.URL;
import java.util.zip.*;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.15 $
 */
public class DownloadProgress extends JFrame
{
   /**
    * the url of a plug-in to be downloaded and installed
    */
   private URL url;

   /**
    * The default dir to install the plug-ins in fujaba
    */
   public final static String EXTRACT_TO_DIR = "./plugins/";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JProgressBar progressBar;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean abortDownload = false;


   /**
    * Constructor for class DownloadProgress
    *
    * @param pluginURL  the url of a plug-in to be downloaded
    * @param title      the dialog title
    */
   public DownloadProgress (URL pluginURL, String title)
   {
      super (title);

      url = pluginURL;

      addWindowListener (
         new WindowAdapter()
         {
            public void windowClosing (WindowEvent e)
            {
               cancelPressed();
            } // windowClosing

         });

      JPanel container = new JPanel();
      container.setLayout (new BorderLayout());

      JPanel progressPanel = new JPanel();
      progressPanel.setLayout (new FlowLayout (FlowLayout.LEFT));

      progressBar = new JProgressBar (0, 10);
      progressBar.setValue (0);
      progressBar.setStringPainted (true);
      progressBar.setBorderPainted (true);
      progressBar.setPreferredSize (new Dimension (400, 30));
      JLabel status = new JLabel ("Progress: ");

      progressPanel.add (getProgressBar(), FlowLayout.LEFT);

      JPanel panel = new JPanel();
      panel.setLayout (new GridLayout (5, 0));
      JLabel label1 = new JLabel ("Downloading plug-in: " + pluginURL.getFile());
      JLabel label2 = new JLabel ("Plug-in downloading in progress. Please wait...");
      panel.add (new JLabel (" "));
      panel.add (label1);
      panel.add (label2);
      panel.add (new JLabel (" "));
      panel.add (status);

      container.add (panel, BorderLayout.NORTH);
      container.add (progressPanel, BorderLayout.CENTER);
      container.add (createButtonPanel(), BorderLayout.SOUTH);

      getContentPane().add (container);
      setSize (600, 190);
      centerFrame();
   }


   /**
    * Get the url attribute of the DownloadProgress object
    *
    * @return   The url value
    */
   URL getUrl()
   {
      return url;
   }


   /**
    * Get the abortDownload attribute of the DownloadProgress object
    *
    * @return   The abortDownload value
    */
   boolean isAbortDownload()
   {
      return abortDownload;
   }


   /**
    * Get the progressBar attribute of the DownloadProgress object
    *
    * @return   The progressBar value
    */
   JProgressBar getProgressBar()
   {
      return progressBar;
   }


   /**
    * Downloads the specified plug-in.
    */
   public void download()
   {
      DownloadThread dt = new DownloadThread();
      dt.start();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createButtonPanel()
   {
      JPanel buttonPanel = new JPanel();
      buttonPanel.setLayout (new FlowLayout (FlowLayout.CENTER));

      JButton cancel = new JButton ("Cancel");
      cancel.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               cancelPressed();
            }
         }
         );
      cancel.setToolTipText ("Cancel plugin downloading");
      buttonPanel.add (cancel);

      return buttonPanel;
   } // createButtonPanel


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void centerFrame()
   {
      Dimension screenSize = this.getToolkit().getScreenSize();
      Dimension size = this.getSize();

      int y =  (screenSize.height - size.height) / 2;
      int x =  (screenSize.width - size.width) / 2;

      setLocation (x, y);
   } // centerDialog


   /**
    * Cancel the download and installation process of a plug-in
    */
   void cancelPressed()
   {
      this.abortDownload = true;
      JOptionPane.showInternalMessageDialog (this, "Download process canceled by user.", "Information", JOptionPane.INFORMATION_MESSAGE);
      close();
   } // cancelPressed


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void close()
   {
      hide();
      dispose();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.15 $
    */
   private class DownloadThread extends Thread
   {
      /**
       * Main processing method for the DownloadThread object
       */
      public void run()
      {
         unzip();
         close();
      }


      /**
       * installs the plug-in in the fujaba plug-in directory
       */
      private void unzip()
      {
         int read = 0;
         int progress = 0;
         byte[] data = new byte[1024];
         ZipEntry entry = null;
         try
         {
            // open zip url and connect it with stream
            ZipInputStream in = new ZipInputStream (getUrl().openStream());
            // read all entries form archive stream
            while ( (entry = in.getNextEntry()) != null && !isAbortDownload())
            {
               getProgressBar().setValue (progress++);

               // create directory of file
               File parent = new File (EXTRACT_TO_DIR + entry.getName()).getParentFile();
               parent.mkdirs();

               if (entry.isDirectory())
               {
                  File file = new File (EXTRACT_TO_DIR + entry.getName());
                  file.mkdir();
                  continue;
               }
               // create new file for current entry
               FileOutputStream out = new FileOutputStream (EXTRACT_TO_DIR + entry.getName());
               // read from stream and write to created file
               while ( (read = in.read (data, 0, 1024)) != -1)
               {
                  out.write (data, 0, read);
               }
               out.close();
            }
            in.close();
            getProgressBar().setValue (getProgressBar().getMaximum());
            Thread.sleep (1000);
         }
         catch (Exception e)
         {
            String pluginName = "";
            if (entry != null)
            {
               pluginName = "\"" + entry.getName() + "\"<br>";
            }

            JOptionPane.showMessageDialog (new JFrame(), "<html>An error occured while downloading plug-in:<br>" +
               pluginName +
               "Error: " + e + "</html>", "Error", JOptionPane.ERROR_MESSAGE);

            e.printStackTrace();
         }
      }
   }

}

/*
 * $Log: DownloadProgress.java,v $
 * Revision 1.15  2006/02/07 17:04:13  lowende
 * Applied patch send by Felix Klar: Connection error handling in plugin download dialog enhanced.
 *
 */
