/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.upb.lib.plugins;

import de.uni_paderborn.lib.classloader.UPBClassLoader;


/**
 * Basic implementation of the PluginInterface.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public abstract class AbstractPlugin implements PluginInterface
{
   /**
    * Stores the installation path of the plugin.
    */
   private String installationPath = null;

   /**
    * Stores the plugin pluginID. The pluginID is the pluginClass attribute of the plugin.xml
    * document. This attribute is used to identify a plug-in unique
    */
   private String pluginID = null;

   /**
    * The class loader which is responsible for the plug-in
    */
   private UPBClassLoader classLoader = null;


   /**
    * registers the plug-in id by the given string pluginID
    *
    * @param pluginID  the plug-in id
    */
   public void setPluginID (String pluginID)
   {
      if (this.pluginID == null && pluginID != null)
      {
         this.pluginID = pluginID;
      }
   }


   /**
    * @return   the plug-in id specified by a string pluginID.
    */
   public String getPluginID()
   {
      return pluginID;
   }


   /**
    * Sets the key attribute of the AbstractPlugin object
    *
    * @param key  The new key value
    */
   public void setKey (String key)
   {
      setPluginID (key);
   }


   /**
    * Get the key attribute of the AbstractPlugin object
    *
    * @return   The key value
    */
   public String getKey()
   {
      return getPluginID();
   }


   /**
    * @return   the class loader which is responsible for this plug-in
    */
   public UPBClassLoader getClassLoader()
   {
      if (classLoader != null)
      {
         return this.classLoader;
      }
      else if (pluginID != null)
      {
         return UPBClassLoader.get (pluginID);
      }
      else
      {
         return UPBClassLoader.get();
      }
   }


   /**
    * Returns the initialization path of the plugin.
    *
    * @return       the initialization path
    * @deprecated   use public String getInstallationPath()
    */
   public String getInitializationPath()
   {
      return getInstallationPath();
   } // getInitializationPath


   /**
    * returns the installation path
    *
    * @return   the installation path
    */
   public String getInstallationPath()
   {
      return installationPath;
   }


   /**
    * registers the new installation path of this plug-in
    *
    * @param newPath  The new installationPath value
    */
   public void setInstallationPath (String newPath)
   {
      if (installationPath == null && newPath != null)
      {
         installationPath = newPath;
      }
   } // setInstallationPath


   /**
    * Set a new initialization path for the plugin.
    *
    * @param newPath  the new path for the plugin
    * @deprecated     use public void setInstallationPath(String newPath)
    */
   public void setInitializationPath (String newPath)
   {
      setInstallationPath (newPath);
   } // setInitializationPath


   /**
    * Initialize the plugin after creation. All properties as initialization path have to be
    * set before this method is called.
    *
    * @return   Always true.
    */
   public boolean initialize()
   {
      return true;
   } // initialize


   /**
    * Terminates the plugin before application exit.
    */
   public void terminate()
   {
   } // terminate

}

/*
 * $Log: AbstractPlugin.java,v $
 * Revision 1.11  2004/09/22 08:51:20  lowende
 * Compile errors and warnings removed.
 *
 */
