/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.upb.lib.html;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;

import javax.swing.*;



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.2 $
 */
public class NavigationToolBar extends JToolBar
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton back;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton forward;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton home;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private HtmlPanel htmlPanel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ImageIcon backImg, forwardImg, homeImg;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int pageIndex = 0;


   /**
    * Constructor for class NavigationToolBar
    */
   public NavigationToolBar()
   {
      try
      {
         jbInit();
      }
      catch (Exception ex)
      {
         // exception handling
      }
   }


   /**
    * Constructor for class NavigationToolBar
    *
    * @param htmlPanel  No description provided
    */
   public NavigationToolBar (HtmlPanel htmlPanel)
   {
      try
      {
         this.htmlPanel = htmlPanel;
         jbInit();
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void jbInit()
   {
      backImg = new ImageIcon (Toolkit.getDefaultToolkit().createImage (de.upb.lib.html.NavigationToolBar.class.getResource ("back.gif")));
      forwardImg = new ImageIcon (Toolkit.getDefaultToolkit().createImage (de.upb.lib.html.NavigationToolBar.class.getResource ("forward.gif")));
      homeImg = new ImageIcon (Toolkit.getDefaultToolkit().createImage (de.upb.lib.html.NavigationToolBar.class.getResource ("home.gif")));
      back = new JButton (backImg);
      back.setToolTipText ("Back");
      back.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               goBack (e);
            }
         });
      back.setEnabled (false);
      forward = new JButton (forwardImg);
      forward.setToolTipText ("Forward");
      forward.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               goForward (e);
            }
         });
      forward.setEnabled (false);
      home = new JButton (homeImg);
      home.setToolTipText ("Go to main documentation page");
      home.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               goHome (e);
            }
         });
      this.setRollover (true);
      this.add (back);
      this.add (forward);
      this.addSeparator();
      this.add (home);
   }


   /**
    * Get the backButton attribute of the NavigationToolBar object
    *
    * @return   The backButton value
    */
   public JButton getBackButton()
   {
      return back;
   }


   /**
    * Get the pageIndex attribute of the NavigationToolBar object
    *
    * @return   The pageIndex value
    */
   public int getPageIndex()
   {
      return pageIndex;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void incPageIndex()
   {
      pageIndex++;
   }


   /**
    * Get the forwardButton attribute of the NavigationToolBar object
    *
    * @return   The forwardButton value
    */
   public JButton getForwardButton()
   {
      return forward;
   }


   /**
    * Sets the buttonEnablity attribute of the NavigationToolBar object
    *
    * @param backEnabled     The new buttonEnablity value
    * @param forwardEnabled  The new buttonEnablity value
    * @param homeEnabled     The new buttonEnablity value
    */
   public void setButtonEnablity (boolean backEnabled, boolean forwardEnabled, boolean homeEnabled)
   {
      back.setEnabled (backEnabled);
      forward.setEnabled (forwardEnabled);
      home.setEnabled (homeEnabled);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   void goBack (ActionEvent e)
   {
      if (pageIndex > 0)
      {
         try
         {
            pageIndex--;
            back.setEnabled (! (pageIndex == 0));
            URL url = (URL)  (htmlPanel.history.get (pageIndex));
            htmlPanel.html.setPage (url);
            forward.setEnabled (true);
         }
         catch (Exception ex)
         {
            ex.printStackTrace();
         }
      }
      else
      {
         back.setEnabled (false);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   void goForward (ActionEvent e)
   {
      if (pageIndex < htmlPanel.history.size() - 1)
      {
         try
         {
            pageIndex++;
            URL url = (URL)  (htmlPanel.history.get (pageIndex));
            htmlPanel.html.setPage (url);
            back.setEnabled (true);
            forward.setEnabled (! (pageIndex >= htmlPanel.history.size() - 1));
         }
         catch (Exception ex)
         {
            ex.printStackTrace();
         }
      }
      else
      {
         forward.setEnabled (false);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   void goHome (ActionEvent e)
   {
      try
      {
         String fujabaDir = System.getProperty ("fujaba.dir");
         URL url = null;
         if (fujabaDir != null)
         {
            try
            {
               url = new URL ("file:" + fujabaDir + "/doc/fujaba/Fujaba.html");
            }
            catch (Exception except)
            {
               except.printStackTrace();
               throw new RuntimeException ("Check fujaba script for -Dfujaba.dir option!");
            }
         }
         else
         {
            url = HtmlDialog.class.getResource ("../../../../doc/fujaba/Fujaba.html");
            if (url == null)
            {
               try
               {
                  url = new URL ("file:./doc/fujaba/Fujaba.html");
               }
               catch (Exception except)
               {
                  except.printStackTrace();
                  throw new RuntimeException ("Check fujaba script for -Dfujaba.dir option!");
               }
            }
         }
         this.htmlPanel.html.setPage (url);
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
         //	   throw new RuntimeException ("unexpected error");
      }
   }

}

/*
 * $Log: NavigationToolBar.java,v $
 * Revision 1.2  2004/08/02 07:34:14  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
