/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.upb.lib.html;

import java.awt.*;
import java.awt.event.*;
import java.net.*;

import javax.swing.*;


/**
 * Dialog for the html pages.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.2 $
 */
public class HtmlDialog extends JDialog
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private HtmlPanel html;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton close = new JButton ("Close");


   /**
    * Constructor for an HtmlDialog
    *
    * @param owner       the owner of the dialog
    * @param url         the URL of the file to display
    * @param dialogName  the name to give the dialog
    * @param modal       whether the dialog should be modal or not
    */
   public HtmlDialog (JFrame owner, URL url, String dialogName, boolean modal)
   {
      super (owner, dialogName, modal);

      JPanel container = new JPanel();
      container.setLayout (new BorderLayout());

      html = new HtmlPanel (url);

      JPanel buttonPanel = new JPanel();
      buttonPanel.setLayout (new FlowLayout (FlowLayout.RIGHT));

      close.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               ClosePressed();
            }
         }
         );
      buttonPanel.add (close);

      getRootPane().setDefaultButton (close);

      container.add (html, BorderLayout.CENTER);
      container.add (buttonPanel, BorderLayout.SOUTH);

      getContentPane().add (container);
      pack();
      centerDialog();
   }


   /**
    * Access method for an one to n association.
    *
    * @param al  The object added.
    */
   public void addCloseButtonAction (ActionListener al)
   {
      if (close != null)
      {
         close.addActionListener (al);
      }
   }


   /**
    * Constructor for an HtmlDialog without an owner
    *
    * @param url         the URL of the file to display
    * @param dialogName  the name to give the dialog
    * @param modal       whether the dialog should be modal or not
    */
   public HtmlDialog (URL url, String dialogName, boolean modal)
   {
      // If no frame is passed to the JDialog, the resulting Frame can be pushed in the background
      this (null, url, dialogName, modal);
   }


   /**
    * Constructor for a non-modal HtmlDialog without an owner
    *
    * @param url         the URL of the file to display
    * @param dialogName  the name to give the dialog
    */
   public HtmlDialog (URL url, String dialogName)
   {
      this (url, dialogName, false);
   }


   /**
    * Get the htmlPanel attribute of the HtmlDialog object
    *
    * @return   The htmlPanel value
    */
   public HtmlPanel getHtmlPanel()
   {
      return html;
   }


   /**
    * Sets the htmlPanel attribute of the HtmlDialog object
    *
    * @param html  The new htmlPanel value
    */
   public void setHtmlPanel (HtmlPanel html)
   {
      this.html = html;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void centerDialog()
   {
      Dimension screenSize = this.getToolkit().getScreenSize();
      setSize (screenSize.width * 2 / 3, screenSize.height * 2 / 3);
      Dimension size = this.getSize();

      int y =  (screenSize.height - size.height) / 2;
      int x =  (screenSize.width - size.width) / 2;

      this.setLocation (x, y);
   }


   /**
    * Close is pressed.
    */
   public void ClosePressed()
   {
      this.setVisible (false);
      this.dispose();
   }
}

/*
 * $Log: HtmlDialog.java,v $
 * Revision 1.2  2004/08/02 07:34:14  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
