/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.util;



/**
 * Some utility functions to manipulate Strings.
 *
 * @author    Fujaba development group
 * @version   $Revision: 1.3 $
 */
public class StringManipulation
{
   /**
    * changes the windows backslashes in system independent slashes in file names.
    *
    * @param fileName  the specified file name
    * @return          the corrected file name
    */
   public final static String fixFileNameSeparators (String fileName)
   {
      StringBuffer fixedFileName = new StringBuffer();
      String fileSeparator = System.getProperty ("file.separator");

      if (fileSeparator.equals ("/"))
      {
         // search for backslashes and replace by file separator
         int index = fileName.indexOf ("\\");
         while (index >= 0)
         {
            fixedFileName.append (fileName.substring (0, index)).
               append (fileSeparator);

            if (fileName.length() > index)
            {
               fileName = fileName.substring (index + 1);
               index = fileName.indexOf ("\\");
            }
            else
            {
               index = -1;
            }
         }
         fixedFileName.append (fileName);
      }
      else
      {
         // search for slashes and replace by file separator
         int index = fileName.indexOf ("/");
         while (index >= 0)
         {
            fixedFileName.append (fileName.substring (0, index)).
               append (fileSeparator);

            if (fileName.length() > index)
            {
               fileName = fileName.substring (index + 1);
               index = fileName.indexOf ("/");
            }
            else
            {
               index = -1;
            }
         }
         fixedFileName.append (fileName);
      }

      return fixedFileName.toString();
   } // fixFileNameSeparators

}

/*
 * $Log: StringManipulation.java,v $
 * Revision 1.3  2004/08/02 07:34:13  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
