/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.javax.swing.table;

import java.awt.Component;
import java.awt.event.*;

import javax.swing.*;


/**
 * a Combobox Cell Editor.
 *
 * @author    Fujaba Development Group
 * @version   $Revision: 1.5 $
 */
public class ComboBoxCellEditor extends BasicTableCellEditor
{
   /**
    * the internal used combo box.
    */
   private JComboBox combo = null;


   /**
    * the standard constructor of this editor. initializes all components of the editor.
    */
   public ComboBoxCellEditor()
   {
      combo = new JComboBox();
      combo.addItemListener (createComboBoxListener());
   }


   /**
    * sets the model of the internal combo box. over this method the user can configure the
    * items of the combo box.
    *
    * @param model  the model which stores the items of the combo box
    */
   public void setModel (ComboBoxModel model)
   {
      combo.setModel (model);
   }


   /**
    * overrides getTableCellEditorComponent of the interface TableCellEditor.
    *
    * @param table       the table of the editor
    * @param value       the value which must be edited
    * @param isSelected  is the cell selected ?
    * @param row         the current row in the table
    * @param column      the current column in the table
    * @return            the editor component
    * @see               javax.swing.table.TableCellEditor#getTableCellEditorComponent
    * @see               javax.swing.table.TableCellEditor
    */
   public Component getTableCellEditorComponent (JTable table,
                                                 Object value,
                                                 boolean isSelected,
                                                 int row,
                                                 int column)
   {
      Object selected;
      selected = table.getValueAt (row, column);
      combo.setBackground (table.getSelectionBackground());
      combo.setSelectedItem (selected);

      return combo;
   }


   /**
    * overrides getCellEditorValue of the interface TableCellEditor.
    *
    * @return   the editor value
    * @see      javax.swing.CellEditor#getCellEditorValue
    * @see      javax.swing.CellEditor
    */
   public Object getCellEditorValue()
   {
      return combo.getSelectedItem();
   }


   /**
    * internal used listener to get changes from the internal used check box. This method is
    * called by the standard constructor of this class.
    *
    * @return   the ActionListener for the checkbox.
    */
   private ItemListener createComboBoxListener()
   {
      ItemListener listener =
         new ItemListener()
         {
            public void itemStateChanged (ItemEvent event)
            {
               stopCellEditing();
            }
         };
      return listener;
   }
}

/*
 * $Log: ComboBoxCellEditor.java,v $
 * Revision 1.5  2004/08/02 07:34:13  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
