/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.javax.swing.table;

import java.util.*;

import javax.swing.event.*;
import javax.swing.table.TableCellEditor;

import de.uni_paderborn.lib.javax.swing.FireEventComponent;


/**
 * An implementation of the TableCellEditor interface.
 *
 * @author    Fujaba Development Group
 * @version   $Revision: 1.5 $
 * @see       javax.swing.table.TableCellEditor
 */
public abstract class BasicTableCellEditor extends FireEventComponent
    implements TableCellEditor
{
   /**
    * initializes the components of this editor.
    */
   public BasicTableCellEditor() { }


   /**
    * overrides isCellEditable of the interface TableCellEditor.
    *
    * @param event  is the cell editable for the given event object
    * @return       always true
    * @see          javax.swing.CellEditor#isCellEditable
    */
   public boolean isCellEditable (EventObject event)
   {
      return true;
   }


   /**
    * overrides shouldSelectCell of the interface TableCellEditor.
    *
    * @param event  is the cell selectable for the given event
    * @return       always true
    * @see          javax.swing.CellEditor#shouldSelectCell
    */
   public boolean shouldSelectCell (EventObject event)
   {
      return true;
   }


   /**
    * overrides addCellEditorListener of the interface TableCellEditor.
    *
    * @param listener  the listener to be added
    * @see             javax.swing.CellEditor#addCellEditorListener
    */
   public void addCellEditorListener (CellEditorListener listener)
   {
      addListener (listener);
   }


   /**
    * overrides removeCellEditorListener of the interface TableCellEditor.
    *
    * @param listener  the listener to be removed
    * @see             javax.swing.CellEditor#removeCellEditorListener
    */
   public void removeCellEditorListener (CellEditorListener listener)
   {
      removeListener (listener);
   }


   /**
    * overrides stopCellEditing of the interface TableCellEditor. inform all listeners that
    * editing has stopped.
    *
    * @return   always true
    * @see      javax.swing.CellEditor#stopCellEditing
    */
   public boolean stopCellEditing()
   {
      CellEditorListener listener = null;
      ChangeEvent event = null;

      Iterator iter = getListeners().iterator();

      while (iter.hasNext())
      {
         listener = (CellEditorListener) iter.next();
         event = new ChangeEvent (this);

         listener.editingStopped (event);
      }
      return true;
   }


   /**
    * overrides cancelCellEditing of the interface TableCellEditor. inform all listeners that
    * editing has canceled.
    *
    * @see   javax.swing.CellEditor#cancelCellEditing
    */
   public void cancelCellEditing()
   {
      CellEditorListener listener = null;
      ChangeEvent event = null;

      Iterator iter = getListeners().iterator();

      while (iter.hasNext())
      {
         listener = (CellEditorListener) iter.next();
         event = new ChangeEvent (this);

         listener.editingCanceled (event);
      }
   }

}

/*
 * $Log: BasicTableCellEditor.java,v $
 * Revision 1.5  2004/08/02 07:34:13  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
