/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.javax.swing.event;


import javax.swing.event.MouseInputAdapter;


/**
 * Defines an application independent mechanism to handle mouse events on an application panel.
 *
 * @author    Fujaba development group
 * @version   $Revision: 1.5 $
 */
public abstract class UPBMouseInputAdapter
    extends MouseInputAdapter
{
   /**
    * default constructor is empty.
    */
   public UPBMouseInputAdapter() { }


   /**
    * stop the adapter.
    */
   public abstract void stop();


   /**
    * start the adapter.
    */
   public abstract void start();

}

/*
 * $Log: UPBMouseInputAdapter.java,v $
 * Revision 1.5  2004/08/02 07:34:12  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
