/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.java.io;

import java.io.*;


/**
 * Implementation of a file filter for jar files.
 *
 * @author    student research group Reddmom
 * @version   $Revision: 1.5 $
 */
public class GIFJPGFileFilter implements FileFilter
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static GIFJPGFileFilter filter = null;


   /**
    * The default constructor is empty.
    */
   private GIFJPGFileFilter() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static GIFJPGFileFilter get()
   {
      if (filter == null)
      {
         filter = new GIFJPGFileFilter();
      } // end of if ()
      return filter;
   }


   /**
    * Overrides the method accept of the interface FileFilter.
    *
    * @param pathName  the given File
    * @return          true if the given file is a valid jar file and its name matches the
    *      filter that is set.
    */
   public boolean accept (File pathName)
   {
      if (pathName != null &&
         pathName.isFile() &&
         pathName.getName() != null)
      {
         String name = pathName.getName().toUpperCase();
         return  (name.endsWith (".GIF") ||
            name.endsWith (".JPG"));
      }
      return false;
   }
}

/*
 * $Log: GIFJPGFileFilter.java,v $
 * Revision 1.5  2004/08/02 07:34:12  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
