/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.java.io;

import java.io.File;
import java.util.Comparator;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.4 $
 */
public class FileComparator implements Comparator
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static FileComparator comparator = null;


   /**
    * Constructor for class FileComparator
    */
   private FileComparator() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static FileComparator get()
   {
      if (comparator == null)
      {
         comparator = new FileComparator();
      } // end of if ()
      return comparator;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param o1  No description provided
    * @param o2  No description provided
    * @return    No description provided
    */
   public int compare (Object o1, Object o2)
   {
      File file1 = null;
      File file2 = null;

      String name1 = null;
      String name2 = null;

      if ( (o1 instanceof File) &&
          (o2 instanceof File))
      {
         file1 = (File) o1;
         file2 = (File) o2;

         return file1.compareTo (file2);
      } // end of if ()
      else if (o1 instanceof File)
      {
         file1 = (File) o1;
         return file1.compareTo (o2);
      } // end of if ()
      else if (o2 instanceof File)
      {
         file2 = (File) o2;
         return  (-file2.compareTo (o1));
      } // end of if ()
      else
      {
         if (o1 != null)
         {
            name1 = o1.toString();
            return name1.compareTo (o2);
         } // end of if ()
         else if (o2 != null)
         {
            name2 = o2.toString();
            return  (-name2.compareTo (o1));
         } // end of if ()
      } // end of else
      return 0;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param o  No description provided
    * @return   No description provided
    */
   public boolean equals (Object o)
   {
      return  (o == this);
   }

}

/*
 * $Log: FileComparator.java,v $
 * Revision 1.4  2004/08/02 07:34:12  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
