/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.basic;

import java.awt.*;
import java.net.URL;
import java.util.Hashtable;

import javax.swing.ImageIcon;

import de.uni_paderborn.lib.classloader.UPBClassLoader;
import de.uni_paderborn.lib.util.StringManipulation;


/**
 * Caches the images of an application.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.16 $
 */
public class ImageResourceManager
{
   /**
    * A 16x16 empty transparent icon.
    */
   private final static String defaultIcon = "de/uni_paderborn/fujaba/app/images/none.gif";

   /**
    * The singleton instance.
    */
   private static ImageResourceManager theImageResourceManager;


   /**
    * The <b>private</b> constructor. Use get() to get an instance of this class.
    *
    * @see   #get
    */
   private ImageResourceManager()
   {
      imageIcons = new Hashtable();
      images = new Hashtable();
   } // constructor


   /**
    * Provides a singleton instance of this class.
    *
    * @return   the singleton instance
    */
   public static ImageResourceManager get()
   {
      if (theImageResourceManager == null)
      {
         theImageResourceManager = new ImageResourceManager();
      }

      return theImageResourceManager;
   }


   /**
    * Stores all image icons, the key is the filename or the url.
    */
   private Hashtable imageIcons;


   /**
    * Get the imageIcon attribute of the ImageResourceManager object
    *
    * @param key       No description provided
    * @param fileName  No description provided
    * @return          The imageIcon value
    */
   public ImageIcon getImageIcon (String key, String fileName)
   {
      return getImageIcon (UPBClassLoader.get (key), fileName);
   }


   /**
    * Returns the image icon specified by fileName.
    *
    * @param fileName  the specified file name of the image
    * @param loader    No description provided
    * @return          the image
    */
   public ImageIcon getImageIcon (ClassLoader loader, String fileName)
   {
      ImageIcon image = null;

      if (fileName != null && !"".equals (fileName))
      {
         String fixedFileName = StringManipulation.fixFileNameSeparators (fileName);

         image = (ImageIcon) imageIcons.get (fileName);

         if (image == null)
         {
            URL url = loader.getResource (fileName);

            if (url == null)
            {
               url = loader.getResource (fixedFileName);
            }

            if (url != null)
            {
               image = getImageIcon (url);
            }
            else
            {
               image = new ImageIcon (fixedFileName);
            }

            if ( (image == null) ||  ( (image.getIconHeight() <= 0) ||  (image.getIconWidth() <= 0)))
            {
               System.err.println ("Icon " + fileName + " not found!");
               url = UPBClassLoader.get().getResource (defaultIcon);

               image = getImageIcon (url);
               if (image != null)
               {
                  imageIcons.put (fileName, image);
               }
               else
               {
                  System.err.println ("Default icon " + defaultIcon + " not found!");
               }
            }
            else
            {
               imageIcons.put (fileName, image);
            }
         }
      }

      return image;
   } // getImageIcon (String)


   /**
    * Returns the image icon specified by url.
    *
    * @param url  the specified url of the image
    * @return     the image
    */
   public ImageIcon getImageIcon (URL url)
   {
      ImageIcon image = null;
      if (url != null)
      {
         image = (ImageIcon) imageIcons.get (url);

         if (image == null)
         {
            image = new ImageIcon (url);
            imageIcons.put (url, image);
         }
      }

      return image;
   } // getImageIcon (URL)


   /**
    * Stores all images, the key is the filename or the url.
    */
   private Hashtable images;


   /**
    * get an image specified by the filename.
    *
    * @param fileName  the specified file name
    * @return          The image specified by fileName.
    */
   public Image getImage (String fileName)
   {
      Image image = null;

      String fixedFileName = StringManipulation.fixFileNameSeparators (fileName);

      if (fixedFileName != null)
      {
         image = (Image) images.get (fixedFileName);

         if (image == null)
         {
            image = Toolkit.getDefaultToolkit().createImage (fixedFileName);
            images.put (fixedFileName, image);
         }
      }
      return image;
   } // getImage (String)


   /**
    * get an image specified by the url.
    *
    * @param url  the specified url.
    * @return     The image specified by url.
    */
   public Image getImage (URL url)
   {
      Image image = null;
      if (url != null)
      {
         image = (Image) images.get (url);

         if (image == null)
         {
            image = Toolkit.getDefaultToolkit().createImage (url);
            images.put (url, image);
         }
      }

      return image;
   } // getImage (URL)


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      imageIcons.clear();
      images.clear();
   }

}

/*
 * $Log: ImageResourceManager.java,v $
 * Revision 1.16  2004/07/05 12:41:23  lowende
 * Visibility of internal methods restricted.
 *
 */
