package de.upb.inferenceengine.engines;

import de.upb.tools.fca.FEmptyIterator;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLAttr;

public class SingleReferenceEngine
extends GFRNEngine
{
   private  SingleReferenceEngine()
   {
   }

   private static SingleReferenceEngine theSingleReferenceEngine;

   public static SingleReferenceEngine get()
   {
      if (theSingleReferenceEngine == null)
      {
         theSingleReferenceEngine = new SingleReferenceEngine ();
      }
      return theSingleReferenceEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation singleReference = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         singleReference = this.annotateUsingReferencesRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( singleReference != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (singleReference) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            singleReference = this.annotateUsingFieldRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( singleReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (singleReference) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               singleReference = this.annotateUsingReferencingClassRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            return (singleReference) ;
         }
      }
   }


   private GFRNAnnotation annotateUsingFieldRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterReferencingFieldAnnotationsSingleReference = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      SingleReferenceAnnotation singleReference = null ;
      UMLAttr referencingField = null ;
      UMLClass referencingClass = null ;
      UMLClass referredClass = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("field", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
             
            // explicit type cast
            referencingField = (UMLAttr) fujaba__tmpTypeCastObject ;
             
            // bind referredClass: UMLClass
            fujaba__TmpObject = referencingField.getAttrType () ;
            JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
            referredClass = (UMLClass) fujaba__TmpObject ;
             
            // bind referencingClass: UMLClass
            referencingClass = referencingField.getParent () ;
            JavaSDM.ensure ( referencingClass != null ) ;
             
            {
               //  for each flow
               try
               {
                  fujaba__Success = false ;
                   
                  // check object referencingClass is really bound
                  JavaSDM.ensure ( referencingClass != null ) ;
                   
                  // check object referencingField is really bound
                  JavaSDM.ensure ( referencingField != null ) ;
                   
                  // check object referredClass is really bound
                  JavaSDM.ensure ( referredClass != null ) ;
                   
                  // bind singleReference: SingleReferenceAnnotation
                  fujaba__IterReferencingFieldAnnotationsSingleReference = referencingField.iteratorOfAnnotations () ;
                  while ( !(fujaba__Success) && fujaba__IterReferencingFieldAnnotationsSingleReference.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterReferencingFieldAnnotationsSingleReference.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof SingleReferenceAnnotation ) ;
                        singleReference = (SingleReferenceAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between singleReference and referencingField
                        JavaSDM.ensure ( singleReference.hasInElements ("field", referencingField) ) ;
                         
                        // check To-Many-Link 'elements' between singleReference and referencingClass
                        JavaSDM.ensure ( singleReference.hasInElements ("referencingClass", referencingClass) ) ;
                         
                        // check To-Many-Link 'elements' between singleReference and referredClass
                        JavaSDM.ensure ( singleReference.hasInElements ("references", referredClass) ) ;
                         
                        fujaba__Success = true ;
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( !(fujaba__Success) )
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // check object referencingClass is really bound
                     JavaSDM.ensure ( referencingClass != null ) ;
                      
                     // check object referencingField is really bound
                     JavaSDM.ensure ( referencingField != null ) ;
                      
                     // check object referredClass is really bound
                     JavaSDM.ensure ( referredClass != null ) ;
                      
                     // create object
                     singleReference = new SingleReferenceAnnotation ( ) ;
                      
                     // assign statement
                     singleReference.setClassification (0);
                      
                     // create link
                     singleReference.addToElements ("referencingClass", referencingClass);
                      
                     // create link
                     singleReference.addToElements ("field", referencingField);
                      
                     // create link
                     singleReference.addToElements ("references", referredClass);
                      
                     // create link
                     singleReference.addToBoundObjects ("referredClass", referredClass);
                      
                     // create link
                     singleReference.addToBoundObjects ("referencingField", referencingField);
                      
                     // create link
                     singleReference.addToBoundObjects ("referencingClass", referencingClass);
                      
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  try
                  {
                     fujaba__Success = false ;
                      
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  return (singleReference) ;
               }
            } //  end for each flow
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object singleReference is really bound
            JavaSDM.ensure ( singleReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("field", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (singleReference) ;
   }


   private GFRNAnnotation annotateUsingReferencesRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterReferencingFieldAnnotationsSingleReference = null ;
      Iterator fujaba__IterReferredClassRevAttrTypeReferencingField = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      SingleReferenceAnnotation singleReference = null ;
      UMLAttr referencingField = null ;
      UMLClass referencingClass = null ;
      UMLClass referredClass = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("references", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            referredClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind referencingField: UMLAttr
            fujaba__IterReferredClassRevAttrTypeReferencingField = referredClass.iteratorOfRevAttrType () ;
            while ( fujaba__IterReferredClassRevAttrTypeReferencingField.hasNext () )
            {
               try
               {
                  referencingField = (UMLAttr) fujaba__IterReferredClassRevAttrTypeReferencingField.next () ;
                   
                  // bind referencingClass: UMLClass
                  referencingClass = referencingField.getParent () ;
                  JavaSDM.ensure ( referencingClass != null ) ;
                   
                  {
                     //  for each flow
                     try
                     {
                        fujaba__Success = false ;
                         
                        // check object referencingClass is really bound
                        JavaSDM.ensure ( referencingClass != null ) ;
                         
                        // check object referencingField is really bound
                        JavaSDM.ensure ( referencingField != null ) ;
                         
                        // check object referredClass is really bound
                        JavaSDM.ensure ( referredClass != null ) ;
                         
                        // bind singleReference: SingleReferenceAnnotation
                        fujaba__IterReferencingFieldAnnotationsSingleReference = referencingField.iteratorOfAnnotations () ;
                        while ( !(fujaba__Success) && fujaba__IterReferencingFieldAnnotationsSingleReference.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterReferencingFieldAnnotationsSingleReference.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof SingleReferenceAnnotation ) ;
                              singleReference = (SingleReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between singleReference and referencingField
                              JavaSDM.ensure ( singleReference.hasInElements ("field", referencingField) ) ;
                               
                              // check To-Many-Link 'elements' between singleReference and referencingClass
                              JavaSDM.ensure ( singleReference.hasInElements ("referencingClass", referencingClass) ) ;
                               
                              // check To-Many-Link 'elements' between singleReference and referredClass
                              JavaSDM.ensure ( singleReference.hasInElements ("references", referredClass) ) ;
                               
                              fujaba__Success = true ;
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                        fujaba__Success = false ;
                     }
                      
                     if ( !(fujaba__Success) )
                     {
                        try
                        {
                           fujaba__Success = false ;
                            
                           // check object referencingClass is really bound
                           JavaSDM.ensure ( referencingClass != null ) ;
                            
                           // check object referencingField is really bound
                           JavaSDM.ensure ( referencingField != null ) ;
                            
                           // check object referredClass is really bound
                           JavaSDM.ensure ( referredClass != null ) ;
                            
                           // create object
                           singleReference = new SingleReferenceAnnotation ( ) ;
                            
                           // assign statement
                           singleReference.setClassification (0);
                            
                           // create link
                           singleReference.addToElements ("referencingClass", referencingClass);
                            
                           // create link
                           singleReference.addToElements ("field", referencingField);
                            
                           // create link
                           singleReference.addToElements ("references", referredClass);
                            
                           // create link
                           singleReference.addToBoundObjects ("referredClass", referredClass);
                            
                           // create link
                           singleReference.addToBoundObjects ("referencingField", referencingField);
                            
                           // create link
                           singleReference.addToBoundObjects ("referencingClass", referencingClass);
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        try
                        {
                           fujaba__Success = false ;
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        return (singleReference) ;
                     }
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object singleReference is really bound
            JavaSDM.ensure ( singleReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("references", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (singleReference) ;
   }


   private GFRNAnnotation annotateUsingReferencingClassRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterReferencingClassAnnotationsSingleReference = null ;
      Iterator fujaba__IterReferencingClassAttrsReferencingField = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      SingleReferenceAnnotation singleReference = null ;
      UMLAttr referencingField = null ;
      UMLClass referencingClass = null ;
      UMLClass referredClass = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("referencingClass", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            referencingClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind referencingField: UMLAttr
            fujaba__IterReferencingClassAttrsReferencingField = referencingClass.iteratorOfAttrs () ;
            while ( fujaba__IterReferencingClassAttrsReferencingField.hasNext () )
            {
               try
               {
                  referencingField = (UMLAttr) fujaba__IterReferencingClassAttrsReferencingField.next () ;
                   
                  // bind referredClass: UMLClass
                  fujaba__TmpObject = referencingField.getAttrType () ;
                  JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  referredClass = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     try
                     {
                        fujaba__Success = false ;
                         
                        // check object referencingClass is really bound
                        JavaSDM.ensure ( referencingClass != null ) ;
                         
                        // check object referencingField is really bound
                        JavaSDM.ensure ( referencingField != null ) ;
                         
                        // check object referredClass is really bound
                        JavaSDM.ensure ( referredClass != null ) ;
                         
                        // bind singleReference: SingleReferenceAnnotation
                        fujaba__IterReferencingClassAnnotationsSingleReference = referencingClass.iteratorOfAnnotations () ;
                        while ( !(fujaba__Success) && fujaba__IterReferencingClassAnnotationsSingleReference.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterReferencingClassAnnotationsSingleReference.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof SingleReferenceAnnotation ) ;
                              singleReference = (SingleReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between singleReference and referencingClass
                              JavaSDM.ensure ( singleReference.hasInElements ("referencingClass", referencingClass) ) ;
                               
                              // check To-Many-Link 'elements' between singleReference and referencingField
                              JavaSDM.ensure ( singleReference.hasInElements ("field", referencingField) ) ;
                               
                              // check To-Many-Link 'elements' between singleReference and referredClass
                              JavaSDM.ensure ( singleReference.hasInElements ("references", referredClass) ) ;
                               
                              fujaba__Success = true ;
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                        fujaba__Success = false ;
                     }
                      
                     if ( !(fujaba__Success) )
                     {
                        try
                        {
                           fujaba__Success = false ;
                            
                           // check object referencingClass is really bound
                           JavaSDM.ensure ( referencingClass != null ) ;
                            
                           // check object referencingField is really bound
                           JavaSDM.ensure ( referencingField != null ) ;
                            
                           // check object referredClass is really bound
                           JavaSDM.ensure ( referredClass != null ) ;
                            
                           // create object
                           singleReference = new SingleReferenceAnnotation ( ) ;
                            
                           // assign statement
                           singleReference.setClassification (0);
                            
                           // create link
                           singleReference.addToElements ("referencingClass", referencingClass);
                            
                           // create link
                           singleReference.addToElements ("field", referencingField);
                            
                           // create link
                           singleReference.addToElements ("references", referredClass);
                            
                           // create link
                           singleReference.addToBoundObjects ("referredClass", referredClass);
                            
                           // create link
                           singleReference.addToBoundObjects ("referencingField", referencingField);
                            
                           // create link
                           singleReference.addToBoundObjects ("referencingClass", referencingClass);
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        try
                        {
                           fujaba__Success = false ;
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        return (singleReference) ;
                     }
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object singleReference is really bound
            JavaSDM.ensure ( singleReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("referencingClass", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (singleReference) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("referencingClass", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLAttr )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("field", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("references", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      return (FEmptyIterator.get()) ;
   }


}
