package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLClass;

public class MultiLevelGeneralizationEngine
extends GFRNEngine
{
   private  MultiLevelGeneralizationEngine()
   {
   }

   private static MultiLevelGeneralizationEngine theMultiLevelGeneralizationEngine;

   public static MultiLevelGeneralizationEngine get()
   {
      if (theMultiLevelGeneralizationEngine == null)
      {
         theMultiLevelGeneralizationEngine = new MultiLevelGeneralizationEngine ();
      }
      return theMultiLevelGeneralizationEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation multiLevelGeneralization = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         multiLevelGeneralization = this.annotateUsingTrigger_GeneralizationRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( multiLevelGeneralization != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (multiLevelGeneralization) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            multiLevelGeneralization = this.annotateUsingSuperClassRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( multiLevelGeneralization != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (multiLevelGeneralization) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               multiLevelGeneralization = this.annotateUsingTrigger_GeneralizationRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( multiLevelGeneralization != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (multiLevelGeneralization) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  multiLevelGeneralization = this.annotateUsingSubClassRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               return (multiLevelGeneralization) ;
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingSubClassRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterGeneralization7ElementsSuperClass = null ;
      Iterator fujaba__IterGeneralization8ElementsIntermediateClass = null ;
      Iterator fujaba__IterIntermediateClassAnnotationsGeneralization7 = null ;
      Iterator fujaba__IterSubClassAnnotationsGeneralization8 = null ;
      Iterator fujaba__IterSuperClassAnnotationsMultiLevelGeneralization = null ;
      GeneralizationAnnotation generalization7 = null ;
      GeneralizationAnnotation generalization8 = null ;
      MultiLevelGeneralizationAnnotation multiLevelGeneralization = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLClass intermediateClass = null ;
      UMLClass subClass = null ;
      UMLClass superClass = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("subClass", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            subClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind generalization8: GeneralizationAnnotation
            fujaba__IterSubClassAnnotationsGeneralization8 = subClass.iteratorOfAnnotations () ;
            while ( fujaba__IterSubClassAnnotationsGeneralization8.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterSubClassAnnotationsGeneralization8.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                  generalization8 = (GeneralizationAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between generalization8 and subClass
                  JavaSDM.ensure ( generalization8.hasInElements ("subClass", subClass) ) ;
                   
                  // bind intermediateClass: UMLClass
                  fujaba__IterGeneralization8ElementsIntermediateClass = generalization8.iteratorOfElements ("superClass") ;
                  while ( fujaba__IterGeneralization8ElementsIntermediateClass.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterGeneralization8ElementsIntermediateClass.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        intermediateClass = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(subClass.equals (intermediateClass)) ) ;
                         
                        // bind generalization7: GeneralizationAnnotation
                        fujaba__IterIntermediateClassAnnotationsGeneralization7 = intermediateClass.iteratorOfAnnotations () ;
                        while ( fujaba__IterIntermediateClassAnnotationsGeneralization7.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterIntermediateClassAnnotationsGeneralization7.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                              generalization7 = (GeneralizationAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between generalization7 and intermediateClass
                              JavaSDM.ensure ( generalization7.hasInElements ("subClass", intermediateClass) ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(generalization8.equals (generalization7)) ) ;
                               
                              // bind superClass: UMLClass
                              fujaba__IterGeneralization7ElementsSuperClass = generalization7.iteratorOfElements ("superClass") ;
                              while ( fujaba__IterGeneralization7ElementsSuperClass.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterGeneralization7ElementsSuperClass.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                    superClass = (UMLClass) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(intermediateClass.equals (superClass)) && !(subClass.equals (superClass)) ) ;
                                     
                                    {
                                       //  for each flow
                                       try
                                       {
                                          fujaba__Success = false ;
                                           
                                          // check object superClass is really bound
                                          JavaSDM.ensure ( superClass != null ) ;
                                           
                                          // check object subClass is really bound
                                          JavaSDM.ensure ( subClass != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(superClass.equals (subClass)) ) ;
                                           
                                          // bind multiLevelGeneralization: MultiLevelGeneralizationAnnotation
                                          fujaba__IterSuperClassAnnotationsMultiLevelGeneralization = superClass.iteratorOfAnnotations () ;
                                          while ( !(fujaba__Success) && fujaba__IterSuperClassAnnotationsMultiLevelGeneralization.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterSuperClassAnnotationsMultiLevelGeneralization.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof MultiLevelGeneralizationAnnotation ) ;
                                                multiLevelGeneralization = (MultiLevelGeneralizationAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between multiLevelGeneralization and superClass
                                                JavaSDM.ensure ( multiLevelGeneralization.hasInElements ("superClass", superClass) ) ;
                                                 
                                                // check To-Many-Link 'elements' between multiLevelGeneralization and subClass
                                                JavaSDM.ensure ( multiLevelGeneralization.hasInElements ("subClass", subClass) ) ;
                                                 
                                                fujaba__Success = true ;
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                          fujaba__Success = false ;
                                       }
                                        
                                       if ( !(fujaba__Success) )
                                       {
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object superClass is really bound
                                             JavaSDM.ensure ( superClass != null ) ;
                                              
                                             // check object subClass is really bound
                                             JavaSDM.ensure ( subClass != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(superClass.equals (subClass)) ) ;
                                              
                                             // check object intermediateClass is really bound
                                             JavaSDM.ensure ( intermediateClass != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(superClass.equals (intermediateClass)) && !(subClass.equals (intermediateClass)) ) ;
                                              
                                             // create object
                                             multiLevelGeneralization = new MultiLevelGeneralizationAnnotation ( ) ;
                                              
                                             // assign statement
                                             multiLevelGeneralization.setClassification (0);
                                              
                                             // create link
                                             multiLevelGeneralization.addToElements ("superClass", superClass);
                                              
                                             // create link
                                             multiLevelGeneralization.addToElements ("subClass", subClass);
                                              
                                             // create link
                                             multiLevelGeneralization.addToBoundObjects ("superClass", superClass);
                                              
                                             // create link
                                             multiLevelGeneralization.addToBoundObjects ("intermediateClass", intermediateClass);
                                              
                                             // create link
                                             multiLevelGeneralization.addToBoundObjects ("subClass", subClass);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object generalization7 is really bound
                                             JavaSDM.ensure ( generalization7 != null ) ;
                                              
                                             // check object generalization8 is really bound
                                             JavaSDM.ensure ( generalization8 != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(generalization7.equals (generalization8)) ) ;
                                              
                                             // check object multiLevelGeneralization is really bound
                                             JavaSDM.ensure ( multiLevelGeneralization != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(generalization7.equals (multiLevelGeneralization)) && !(generalization8.equals (multiLevelGeneralization)) ) ;
                                              
                                             // create link
                                             multiLevelGeneralization.addToAntecedentAnnos (generalization7);
                                              
                                             // create link
                                             multiLevelGeneralization.addToAntecedentAnnos (generalization8);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          return (multiLevelGeneralization) ;
                                       }
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiLevelGeneralization is really bound
            JavaSDM.ensure ( multiLevelGeneralization != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("subClass", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiLevelGeneralization) ;
   }


   private GFRNAnnotation annotateUsingSuperClassRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterGeneralization3ElementsIntermediateClass = null ;
      Iterator fujaba__IterGeneralization4ElementsSubClass = null ;
      Iterator fujaba__IterIntermediateClassAnnotationsGeneralization4 = null ;
      Iterator fujaba__IterSubClassAnnotationsMultiLevelGeneralization = null ;
      Iterator fujaba__IterSuperClassAnnotationsGeneralization3 = null ;
      GeneralizationAnnotation generalization3 = null ;
      GeneralizationAnnotation generalization4 = null ;
      MultiLevelGeneralizationAnnotation multiLevelGeneralization = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLClass intermediateClass = null ;
      UMLClass subClass = null ;
      UMLClass superClass = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("superClass", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            superClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind generalization3: GeneralizationAnnotation
            fujaba__IterSuperClassAnnotationsGeneralization3 = superClass.iteratorOfAnnotations () ;
            while ( fujaba__IterSuperClassAnnotationsGeneralization3.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterSuperClassAnnotationsGeneralization3.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                  generalization3 = (GeneralizationAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between generalization3 and superClass
                  JavaSDM.ensure ( generalization3.hasInElements ("superClass", superClass) ) ;
                   
                  // bind intermediateClass: UMLClass
                  fujaba__IterGeneralization3ElementsIntermediateClass = generalization3.iteratorOfElements ("subClass") ;
                  while ( fujaba__IterGeneralization3ElementsIntermediateClass.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterGeneralization3ElementsIntermediateClass.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        intermediateClass = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(superClass.equals (intermediateClass)) ) ;
                         
                        // bind generalization4: GeneralizationAnnotation
                        fujaba__IterIntermediateClassAnnotationsGeneralization4 = intermediateClass.iteratorOfAnnotations () ;
                        while ( fujaba__IterIntermediateClassAnnotationsGeneralization4.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterIntermediateClassAnnotationsGeneralization4.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                              generalization4 = (GeneralizationAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between generalization4 and intermediateClass
                              JavaSDM.ensure ( generalization4.hasInElements ("superClass", intermediateClass) ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(generalization3.equals (generalization4)) ) ;
                               
                              // bind subClass: UMLClass
                              fujaba__IterGeneralization4ElementsSubClass = generalization4.iteratorOfElements ("subClass") ;
                              while ( fujaba__IterGeneralization4ElementsSubClass.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterGeneralization4ElementsSubClass.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                    subClass = (UMLClass) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(superClass.equals (subClass)) && !(intermediateClass.equals (subClass)) ) ;
                                     
                                    {
                                       //  for each flow
                                       try
                                       {
                                          fujaba__Success = false ;
                                           
                                          // check object superClass is really bound
                                          JavaSDM.ensure ( superClass != null ) ;
                                           
                                          // check object subClass is really bound
                                          JavaSDM.ensure ( subClass != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(superClass.equals (subClass)) ) ;
                                           
                                          // bind multiLevelGeneralization: MultiLevelGeneralizationAnnotation
                                          fujaba__IterSubClassAnnotationsMultiLevelGeneralization = subClass.iteratorOfAnnotations () ;
                                          while ( !(fujaba__Success) && fujaba__IterSubClassAnnotationsMultiLevelGeneralization.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterSubClassAnnotationsMultiLevelGeneralization.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof MultiLevelGeneralizationAnnotation ) ;
                                                multiLevelGeneralization = (MultiLevelGeneralizationAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between multiLevelGeneralization and subClass
                                                JavaSDM.ensure ( multiLevelGeneralization.hasInElements ("subClass", subClass) ) ;
                                                 
                                                // check To-Many-Link 'elements' between multiLevelGeneralization and superClass
                                                JavaSDM.ensure ( multiLevelGeneralization.hasInElements ("superClass", superClass) ) ;
                                                 
                                                fujaba__Success = true ;
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                          fujaba__Success = false ;
                                       }
                                        
                                       if ( !(fujaba__Success) )
                                       {
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object superClass is really bound
                                             JavaSDM.ensure ( superClass != null ) ;
                                              
                                             // check object subClass is really bound
                                             JavaSDM.ensure ( subClass != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(superClass.equals (subClass)) ) ;
                                              
                                             // check object intermediateClass is really bound
                                             JavaSDM.ensure ( intermediateClass != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(superClass.equals (intermediateClass)) && !(subClass.equals (intermediateClass)) ) ;
                                              
                                             // create object
                                             multiLevelGeneralization = new MultiLevelGeneralizationAnnotation ( ) ;
                                              
                                             // assign statement
                                             multiLevelGeneralization.setClassification (0);
                                              
                                             // create link
                                             multiLevelGeneralization.addToElements ("superClass", superClass);
                                              
                                             // create link
                                             multiLevelGeneralization.addToElements ("subClass", subClass);
                                              
                                             // create link
                                             multiLevelGeneralization.addToBoundObjects ("superClass", superClass);
                                              
                                             // create link
                                             multiLevelGeneralization.addToBoundObjects ("intermediateClass", intermediateClass);
                                              
                                             // create link
                                             multiLevelGeneralization.addToBoundObjects ("subClass", subClass);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object generalization3 is really bound
                                             JavaSDM.ensure ( generalization3 != null ) ;
                                              
                                             // check object generalization4 is really bound
                                             JavaSDM.ensure ( generalization4 != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(generalization3.equals (generalization4)) ) ;
                                              
                                             // check object multiLevelGeneralization is really bound
                                             JavaSDM.ensure ( multiLevelGeneralization != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(generalization3.equals (multiLevelGeneralization)) && !(generalization4.equals (multiLevelGeneralization)) ) ;
                                              
                                             // create link
                                             multiLevelGeneralization.addToAntecedentAnnos (generalization3);
                                              
                                             // create link
                                             multiLevelGeneralization.addToAntecedentAnnos (generalization4);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          return (multiLevelGeneralization) ;
                                       }
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiLevelGeneralization is really bound
            JavaSDM.ensure ( multiLevelGeneralization != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("superClass", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiLevelGeneralization) ;
   }


   private GFRNAnnotation annotateUsingTrigger_GeneralizationRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterGeneralization1ElementsIntermediateClass = null ;
      Iterator fujaba__IterGeneralization1ElementsSuperClass = null ;
      Iterator fujaba__IterGeneralization2ElementsSubClass = null ;
      Iterator fujaba__IterIntermediateClassAnnotationsGeneralization2 = null ;
      Iterator fujaba__IterSubClassAnnotationsMultiLevelGeneralization = null ;
      GeneralizationAnnotation generalization1 = null ;
      GeneralizationAnnotation generalization2 = null ;
      MultiLevelGeneralizationAnnotation multiLevelGeneralization = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLClass intermediateClass = null ;
      UMLClass subClass = null ;
      UMLClass superClass = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization1 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind superClass: UMLClass
            fujaba__IterGeneralization1ElementsSuperClass = generalization1.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization1ElementsSuperClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization1ElementsSuperClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  superClass = (UMLClass) fujaba__TmpObject ;
                   
                  // bind intermediateClass: UMLClass
                  fujaba__IterGeneralization1ElementsIntermediateClass = generalization1.iteratorOfElements ("subClass") ;
                  while ( fujaba__IterGeneralization1ElementsIntermediateClass.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterGeneralization1ElementsIntermediateClass.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        intermediateClass = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(superClass.equals (intermediateClass)) ) ;
                         
                        // bind generalization2: GeneralizationAnnotation
                        fujaba__IterIntermediateClassAnnotationsGeneralization2 = intermediateClass.iteratorOfAnnotations () ;
                        while ( fujaba__IterIntermediateClassAnnotationsGeneralization2.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterIntermediateClassAnnotationsGeneralization2.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                              generalization2 = (GeneralizationAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between generalization2 and intermediateClass
                              JavaSDM.ensure ( generalization2.hasInElements ("superClass", intermediateClass) ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(generalization1.equals (generalization2)) ) ;
                               
                              // bind subClass: UMLClass
                              fujaba__IterGeneralization2ElementsSubClass = generalization2.iteratorOfElements ("subClass") ;
                              while ( fujaba__IterGeneralization2ElementsSubClass.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterGeneralization2ElementsSubClass.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                    subClass = (UMLClass) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(superClass.equals (subClass)) && !(intermediateClass.equals (subClass)) ) ;
                                     
                                    {
                                       //  for each flow
                                       try
                                       {
                                          fujaba__Success = false ;
                                           
                                          // check object superClass is really bound
                                          JavaSDM.ensure ( superClass != null ) ;
                                           
                                          // check object subClass is really bound
                                          JavaSDM.ensure ( subClass != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(superClass.equals (subClass)) ) ;
                                           
                                          // bind multiLevelGeneralization: MultiLevelGeneralizationAnnotation
                                          fujaba__IterSubClassAnnotationsMultiLevelGeneralization = subClass.iteratorOfAnnotations () ;
                                          while ( !(fujaba__Success) && fujaba__IterSubClassAnnotationsMultiLevelGeneralization.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterSubClassAnnotationsMultiLevelGeneralization.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof MultiLevelGeneralizationAnnotation ) ;
                                                multiLevelGeneralization = (MultiLevelGeneralizationAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between multiLevelGeneralization and subClass
                                                JavaSDM.ensure ( multiLevelGeneralization.hasInElements ("subClass", subClass) ) ;
                                                 
                                                // check To-Many-Link 'elements' between multiLevelGeneralization and superClass
                                                JavaSDM.ensure ( multiLevelGeneralization.hasInElements ("superClass", superClass) ) ;
                                                 
                                                fujaba__Success = true ;
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                          fujaba__Success = false ;
                                       }
                                        
                                       if ( !(fujaba__Success) )
                                       {
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object superClass is really bound
                                             JavaSDM.ensure ( superClass != null ) ;
                                              
                                             // check object subClass is really bound
                                             JavaSDM.ensure ( subClass != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(superClass.equals (subClass)) ) ;
                                              
                                             // check object intermediateClass is really bound
                                             JavaSDM.ensure ( intermediateClass != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(superClass.equals (intermediateClass)) && !(subClass.equals (intermediateClass)) ) ;
                                              
                                             // create object
                                             multiLevelGeneralization = new MultiLevelGeneralizationAnnotation ( ) ;
                                              
                                             // assign statement
                                             multiLevelGeneralization.setClassification (0);
                                              
                                             // create link
                                             multiLevelGeneralization.addToElements ("superClass", superClass);
                                              
                                             // create link
                                             multiLevelGeneralization.addToElements ("subClass", subClass);
                                              
                                             // create link
                                             multiLevelGeneralization.addToBoundObjects ("superClass", superClass);
                                              
                                             // create link
                                             multiLevelGeneralization.addToBoundObjects ("intermediateClass", intermediateClass);
                                              
                                             // create link
                                             multiLevelGeneralization.addToBoundObjects ("subClass", subClass);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object generalization1 is really bound
                                             JavaSDM.ensure ( generalization1 != null ) ;
                                              
                                             // check object generalization2 is really bound
                                             JavaSDM.ensure ( generalization2 != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(generalization1.equals (generalization2)) ) ;
                                              
                                             // check object multiLevelGeneralization is really bound
                                             JavaSDM.ensure ( multiLevelGeneralization != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(generalization1.equals (multiLevelGeneralization)) && !(generalization2.equals (multiLevelGeneralization)) ) ;
                                              
                                             // create link
                                             multiLevelGeneralization.addToAntecedentAnnos (generalization1);
                                              
                                             // create link
                                             multiLevelGeneralization.addToAntecedentAnnos (generalization2);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          return (multiLevelGeneralization) ;
                                       }
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiLevelGeneralization is really bound
            JavaSDM.ensure ( multiLevelGeneralization != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_Generalization", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiLevelGeneralization) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("superClass", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("subClass", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof GeneralizationAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof GeneralizationAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterGeneralization10ElementsIntermediateClass = null ;
      Iterator fujaba__IterGeneralization9ElementsIntermediateClass = null ;
      Iterator fujaba__IterSubClassAnnotationsGeneralization9 = null ;
      Iterator fujaba__IterSuperClassAnnotationsGeneralization10 = null ;
      GeneralizationAnnotation generalization10 = null ;
      GeneralizationAnnotation generalization9 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLClass intermediateClass = null ;
      UMLClass subClass = null ;
      UMLClass superClass = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("Generalization") || annotation.equals ("MultiLevelGeneralization") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            superClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (superClass);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            subClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind generalization9: GeneralizationAnnotation
            fujaba__IterSubClassAnnotationsGeneralization9 = subClass.iteratorOfAnnotations () ;
            while ( fujaba__IterSubClassAnnotationsGeneralization9.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterSubClassAnnotationsGeneralization9.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                  generalization9 = (GeneralizationAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between generalization9 and subClass
                  JavaSDM.ensure ( generalization9.hasInElements ("subClass", subClass) ) ;
                   
                  // bind intermediateClass: UMLClass
                  fujaba__IterGeneralization9ElementsIntermediateClass = generalization9.iteratorOfElements ("superClass") ;
                  while ( fujaba__IterGeneralization9ElementsIntermediateClass.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterGeneralization9ElementsIntermediateClass.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        intermediateClass = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(subClass.equals (intermediateClass)) ) ;
                         
                        {
                           //  for each flow
                           set.add (intermediateClass);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization9 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind intermediateClass: UMLClass
            fujaba__IterGeneralization9ElementsIntermediateClass = generalization9.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization9ElementsIntermediateClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization9ElementsIntermediateClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  intermediateClass = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (intermediateClass);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("Generalization") || annotation.equals ("MultiLevelGeneralization") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            superClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind generalization10: GeneralizationAnnotation
            fujaba__IterSuperClassAnnotationsGeneralization10 = superClass.iteratorOfAnnotations () ;
            while ( fujaba__IterSuperClassAnnotationsGeneralization10.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterSuperClassAnnotationsGeneralization10.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                  generalization10 = (GeneralizationAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between generalization10 and superClass
                  JavaSDM.ensure ( generalization10.hasInElements ("superClass", superClass) ) ;
                   
                  // bind intermediateClass: UMLClass
                  fujaba__IterGeneralization10ElementsIntermediateClass = generalization10.iteratorOfElements ("subClass") ;
                  while ( fujaba__IterGeneralization10ElementsIntermediateClass.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterGeneralization10ElementsIntermediateClass.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        intermediateClass = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(superClass.equals (intermediateClass)) ) ;
                         
                        {
                           //  for each flow
                           set.add (intermediateClass);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            subClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (subClass);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization10 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind intermediateClass: UMLClass
            fujaba__IterGeneralization10ElementsIntermediateClass = generalization10.iteratorOfElements ("subClass") ;
            while ( fujaba__IterGeneralization10ElementsIntermediateClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization10ElementsIntermediateClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  intermediateClass = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (intermediateClass);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
