package de.upb.inferenceengine.engines;

import de.upb.inferenceengine.visitors.*;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.upb.javaast.methodast.LoopNode;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.ASTRootNode;
import de.upb.javaast.methodast.IdentifierNode;
import de.upb.javaast.methodast.MethodCallNode;

public class MultiDelegationEngine
extends GFRNEngine
{
   private  MultiDelegationEngine()
   {
   }

   private static MultiDelegationEngine theMultiDelegationEngine;

   public static MultiDelegationEngine get()
   {
      if (theMultiDelegationEngine == null)
      {
         theMultiDelegationEngine = new MultiDelegationEngine ();
      }
      return theMultiDelegationEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation multiDelegation = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         multiDelegation = this.annotateUsingTrigger_MultiReferenceRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( multiDelegation != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (multiDelegation) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            multiDelegation = this.annotateUsingCallerClassRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( multiDelegation != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (multiDelegation) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               multiDelegation = this.annotateUsingCallerRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( multiDelegation != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (multiDelegation) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  multiDelegation = this.annotateUsingCalleeClassRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               try
               {
                  fujaba__Success = false ;
                   
                  // constraint
                  JavaSDM.ensure ( multiDelegation != null ) ;
                   
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( fujaba__Success )
               {
                  return (multiDelegation) ;
               }
               else
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // collabStatBegin 1 is empty !
                     multiDelegation = this.annotateUsingCalleeRole(asgElement);
                      
                     // collabStatEnd
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  return (multiDelegation) ;
               }
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingCalleeClassRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterLoopToMethodCallNode8 = null ;
      ASTPathVisitor fujaba__IterRootToLoop = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterCalleeClassAnnotationsMultiReference7 = null ;
      Iterator fujaba__IterCalleeClassMethodsCallee = null ;
      Iterator fujaba__IterCallerAnnotationsMultiDelegation = null ;
      Iterator fujaba__IterCallerClassMethodsCaller = null ;
      Iterator fujaba__IterMultiReference7ElementsRefField = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.LoopNode loop = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode8 = null ;
      MultiDelegationAnnotation multiDelegation = null ;
      MultiReferenceAnnotation multiReference7 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr refField = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("calleeClass", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            calleeClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind callee: UMLMethod
            fujaba__IterCalleeClassMethodsCallee = calleeClass.iteratorOfMethods () ;
            while ( fujaba__IterCalleeClassMethodsCallee.hasNext () )
            {
               try
               {
                  callee = (UMLMethod) fujaba__IterCalleeClassMethodsCallee.next () ;
                   
                  // bind multiReference7: MultiReferenceAnnotation
                  fujaba__IterCalleeClassAnnotationsMultiReference7 = calleeClass.iteratorOfAnnotations () ;
                  while ( fujaba__IterCalleeClassAnnotationsMultiReference7.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterCalleeClassAnnotationsMultiReference7.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof MultiReferenceAnnotation ) ;
                        multiReference7 = (MultiReferenceAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between multiReference7 and calleeClass
                        JavaSDM.ensure ( multiReference7.hasInElements ("references", calleeClass) ) ;
                         
                        // bind refField: UMLAttr
                        fujaba__IterMultiReference7ElementsRefField = multiReference7.iteratorOfElements ("field") ;
                        while ( fujaba__IterMultiReference7ElementsRefField.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterMultiReference7ElementsRefField.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                              refField = (UMLAttr) fujaba__TmpObject ;
                               
                              // bind callerClass: UMLClass
                              callerClass = refField.getParent () ;
                              JavaSDM.ensure ( callerClass != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(calleeClass.equals (callerClass)) ) ;
                               
                              // bind caller: UMLMethod
                              fujaba__IterCallerClassMethodsCaller = callerClass.iteratorOfMethods () ;
                              while ( fujaba__IterCallerClassMethodsCaller.hasNext () )
                              {
                                 try
                                 {
                                    caller = (UMLMethod) fujaba__IterCallerClassMethodsCaller.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(callee.equals (caller)) ) ;
                                     
                                    // bind root: ASTRootNode
                                    root = caller.getASTRootNode () ;
                                    JavaSDM.ensure ( root != null ) ;
                                     
                                    // Path search between ASTRootNode and LoopNode
                                    // Bind loop : LoopNode
                                    fujaba__IterRootToLoop = new ASTPathVisitor (root, LoopNode.class ) ;
                                    while ( fujaba__IterRootToLoop.hasNext () )
                                    {
                                       try
                                       {
                                          loop = (de.upb.javaast.methodast.LoopNode) fujaba__IterRootToLoop.next () ;
                                           
                                          // Path search between LoopNode and MethodCallNode
                                          // Bind methodCallNode8 : MethodCallNode
                                          fujaba__IterLoopToMethodCallNode8 = new ASTPathVisitor (loop, MethodCallNode.class ) ;
                                          while ( fujaba__IterLoopToMethodCallNode8.hasNext () )
                                          {
                                             try
                                             {
                                                methodCallNode8 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterLoopToMethodCallNode8.next () ;
                                                 
                                                // bind id: IdentifierNode
                                                id = methodCallNode8.getIdentifier () ;
                                                JavaSDM.ensure ( id != null ) ;
                                                 
                                                // constraint
                                                JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                                 
                                                // constraint
                                                JavaSDM.ensure ( caller.getName().equals(callee.getName()) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object callerClass is really bound
                                                      JavaSDM.ensure ( callerClass != null ) ;
                                                       
                                                      // check object caller is really bound
                                                      JavaSDM.ensure ( caller != null ) ;
                                                       
                                                      // check object callee is really bound
                                                      JavaSDM.ensure ( callee != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                       
                                                      // check object calleeClass is really bound
                                                      JavaSDM.ensure ( calleeClass != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                       
                                                      // bind multiDelegation: MultiDelegationAnnotation
                                                      fujaba__IterCallerAnnotationsMultiDelegation = caller.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterCallerAnnotationsMultiDelegation.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterCallerAnnotationsMultiDelegation.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof MultiDelegationAnnotation ) ;
                                                            multiDelegation = (MultiDelegationAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between multiDelegation and caller
                                                            JavaSDM.ensure ( multiDelegation.hasInElements ("caller", caller) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiDelegation and callerClass
                                                            JavaSDM.ensure ( multiDelegation.hasInElements ("callerClass", callerClass) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiDelegation and callee
                                                            JavaSDM.ensure ( multiDelegation.hasInElements ("callee", callee) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiDelegation and calleeClass
                                                            JavaSDM.ensure ( multiDelegation.hasInElements ("calleeClass", calleeClass) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object callerClass is really bound
                                                         JavaSDM.ensure ( callerClass != null ) ;
                                                          
                                                         // check object caller is really bound
                                                         JavaSDM.ensure ( caller != null ) ;
                                                          
                                                         // check object callee is really bound
                                                         JavaSDM.ensure ( callee != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                          
                                                         // check object calleeClass is really bound
                                                         JavaSDM.ensure ( calleeClass != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                          
                                                         // check object loop is really bound
                                                         JavaSDM.ensure ( loop != null ) ;
                                                          
                                                         // check object refField is really bound
                                                         JavaSDM.ensure ( refField != null ) ;
                                                          
                                                         // check object root is really bound
                                                         JavaSDM.ensure ( root != null ) ;
                                                          
                                                         // check object id is really bound
                                                         JavaSDM.ensure ( id != null ) ;
                                                          
                                                         // create object
                                                         multiDelegation = new MultiDelegationAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         multiDelegation.setClassification (0);
                                                          
                                                         // create link
                                                         multiDelegation.addToElements ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         multiDelegation.addToElements ("caller", caller);
                                                          
                                                         // create link
                                                         multiDelegation.addToElements ("callee", callee);
                                                          
                                                         // create link
                                                         multiDelegation.addToElements ("calleeClass", calleeClass);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("loop", loop);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("refField", refField);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("caller", caller);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("root", root);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("calleeClass", calleeClass);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("callee", callee);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("id", id);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object multiReference7 is really bound
                                                         JavaSDM.ensure ( multiReference7 != null ) ;
                                                          
                                                         // check object multiDelegation is really bound
                                                         JavaSDM.ensure ( multiDelegation != null ) ;
                                                          
                                                         // create link
                                                         multiDelegation.addToAntecedentAnnos (multiReference7);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (multiDelegation) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiDelegation is really bound
            JavaSDM.ensure ( multiDelegation != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("calleeClass", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiDelegation) ;
   }


   private GFRNAnnotation annotateUsingCalleeRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterLoopToMethodCallNode10 = null ;
      ASTPathVisitor fujaba__IterRootToLoop = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterCalleeClassAnnotationsMultiDelegation = null ;
      Iterator fujaba__IterCalleeClassAnnotationsMultiReference9 = null ;
      Iterator fujaba__IterCallerClassMethodsCaller = null ;
      Iterator fujaba__IterMultiReference9ElementsRefField = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.LoopNode loop = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode10 = null ;
      MultiDelegationAnnotation multiDelegation = null ;
      MultiReferenceAnnotation multiReference9 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr refField = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("callee", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            callee = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // bind calleeClass: UMLClass
            calleeClass = callee.getParent () ;
            JavaSDM.ensure ( calleeClass != null ) ;
             
            // bind multiReference9: MultiReferenceAnnotation
            fujaba__IterCalleeClassAnnotationsMultiReference9 = calleeClass.iteratorOfAnnotations () ;
            while ( fujaba__IterCalleeClassAnnotationsMultiReference9.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterCalleeClassAnnotationsMultiReference9.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof MultiReferenceAnnotation ) ;
                  multiReference9 = (MultiReferenceAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between multiReference9 and calleeClass
                  JavaSDM.ensure ( multiReference9.hasInElements ("references", calleeClass) ) ;
                   
                  // bind refField: UMLAttr
                  fujaba__IterMultiReference9ElementsRefField = multiReference9.iteratorOfElements ("field") ;
                  while ( fujaba__IterMultiReference9ElementsRefField.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterMultiReference9ElementsRefField.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                        refField = (UMLAttr) fujaba__TmpObject ;
                         
                        // bind callerClass: UMLClass
                        callerClass = refField.getParent () ;
                        JavaSDM.ensure ( callerClass != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(calleeClass.equals (callerClass)) ) ;
                         
                        // bind caller: UMLMethod
                        fujaba__IterCallerClassMethodsCaller = callerClass.iteratorOfMethods () ;
                        while ( fujaba__IterCallerClassMethodsCaller.hasNext () )
                        {
                           try
                           {
                              caller = (UMLMethod) fujaba__IterCallerClassMethodsCaller.next () ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(callee.equals (caller)) ) ;
                               
                              // bind root: ASTRootNode
                              root = caller.getASTRootNode () ;
                              JavaSDM.ensure ( root != null ) ;
                               
                              // Path search between ASTRootNode and LoopNode
                              // Bind loop : LoopNode
                              fujaba__IterRootToLoop = new ASTPathVisitor (root, LoopNode.class ) ;
                              while ( fujaba__IterRootToLoop.hasNext () )
                              {
                                 try
                                 {
                                    loop = (de.upb.javaast.methodast.LoopNode) fujaba__IterRootToLoop.next () ;
                                     
                                    // Path search between LoopNode and MethodCallNode
                                    // Bind methodCallNode10 : MethodCallNode
                                    fujaba__IterLoopToMethodCallNode10 = new ASTPathVisitor (loop, MethodCallNode.class ) ;
                                    while ( fujaba__IterLoopToMethodCallNode10.hasNext () )
                                    {
                                       try
                                       {
                                          methodCallNode10 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterLoopToMethodCallNode10.next () ;
                                           
                                          // bind id: IdentifierNode
                                          id = methodCallNode10.getIdentifier () ;
                                          JavaSDM.ensure ( id != null ) ;
                                           
                                          // constraint
                                          JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                           
                                          // constraint
                                          JavaSDM.ensure ( caller.getName().equals(callee.getName()) ) ;
                                           
                                          {
                                             //  for each flow
                                             try
                                             {
                                                fujaba__Success = false ;
                                                 
                                                // check object callerClass is really bound
                                                JavaSDM.ensure ( callerClass != null ) ;
                                                 
                                                // check object caller is really bound
                                                JavaSDM.ensure ( caller != null ) ;
                                                 
                                                // check object callee is really bound
                                                JavaSDM.ensure ( callee != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                 
                                                // check object calleeClass is really bound
                                                JavaSDM.ensure ( calleeClass != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                 
                                                // bind multiDelegation: MultiDelegationAnnotation
                                                fujaba__IterCalleeClassAnnotationsMultiDelegation = calleeClass.iteratorOfAnnotations () ;
                                                while ( !(fujaba__Success) && fujaba__IterCalleeClassAnnotationsMultiDelegation.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterCalleeClassAnnotationsMultiDelegation.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof MultiDelegationAnnotation ) ;
                                                      multiDelegation = (MultiDelegationAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between multiDelegation and calleeClass
                                                      JavaSDM.ensure ( multiDelegation.hasInElements ("calleeClass", calleeClass) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between multiDelegation and callerClass
                                                      JavaSDM.ensure ( multiDelegation.hasInElements ("callerClass", callerClass) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between multiDelegation and caller
                                                      JavaSDM.ensure ( multiDelegation.hasInElements ("caller", caller) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between multiDelegation and callee
                                                      JavaSDM.ensure ( multiDelegation.hasInElements ("callee", callee) ) ;
                                                       
                                                      fujaba__Success = true ;
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                                fujaba__Success = false ;
                                             }
                                              
                                             if ( !(fujaba__Success) )
                                             {
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object callerClass is really bound
                                                   JavaSDM.ensure ( callerClass != null ) ;
                                                    
                                                   // check object caller is really bound
                                                   JavaSDM.ensure ( caller != null ) ;
                                                    
                                                   // check object callee is really bound
                                                   JavaSDM.ensure ( callee != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                    
                                                   // check object calleeClass is really bound
                                                   JavaSDM.ensure ( calleeClass != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                    
                                                   // check object loop is really bound
                                                   JavaSDM.ensure ( loop != null ) ;
                                                    
                                                   // check object refField is really bound
                                                   JavaSDM.ensure ( refField != null ) ;
                                                    
                                                   // check object root is really bound
                                                   JavaSDM.ensure ( root != null ) ;
                                                    
                                                   // check object id is really bound
                                                   JavaSDM.ensure ( id != null ) ;
                                                    
                                                   // create object
                                                   multiDelegation = new MultiDelegationAnnotation ( ) ;
                                                    
                                                   // assign statement
                                                   multiDelegation.setClassification (0);
                                                    
                                                   // create link
                                                   multiDelegation.addToElements ("callerClass", callerClass);
                                                    
                                                   // create link
                                                   multiDelegation.addToElements ("caller", caller);
                                                    
                                                   // create link
                                                   multiDelegation.addToElements ("callee", callee);
                                                    
                                                   // create link
                                                   multiDelegation.addToElements ("calleeClass", calleeClass);
                                                    
                                                   // create link
                                                   multiDelegation.addToBoundObjects ("loop", loop);
                                                    
                                                   // create link
                                                   multiDelegation.addToBoundObjects ("callerClass", callerClass);
                                                    
                                                   // create link
                                                   multiDelegation.addToBoundObjects ("refField", refField);
                                                    
                                                   // create link
                                                   multiDelegation.addToBoundObjects ("caller", caller);
                                                    
                                                   // create link
                                                   multiDelegation.addToBoundObjects ("root", root);
                                                    
                                                   // create link
                                                   multiDelegation.addToBoundObjects ("calleeClass", calleeClass);
                                                    
                                                   // create link
                                                   multiDelegation.addToBoundObjects ("callee", callee);
                                                    
                                                   // create link
                                                   multiDelegation.addToBoundObjects ("id", id);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object multiReference9 is really bound
                                                   JavaSDM.ensure ( multiReference9 != null ) ;
                                                    
                                                   // check object multiDelegation is really bound
                                                   JavaSDM.ensure ( multiDelegation != null ) ;
                                                    
                                                   // create link
                                                   multiDelegation.addToAntecedentAnnos (multiReference9);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                return (multiDelegation) ;
                                             }
                                          } //  end for each flow
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiDelegation is really bound
            JavaSDM.ensure ( multiDelegation != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("callee", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiDelegation) ;
   }


   private GFRNAnnotation annotateUsingCallerClassRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterLoopToMethodCallNode4 = null ;
      ASTPathVisitor fujaba__IterRootToLoop = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterCalleeClassAnnotationsMultiDelegation = null ;
      Iterator fujaba__IterCalleeClassMethodsCallee = null ;
      Iterator fujaba__IterCallerClassAttrsRefField = null ;
      Iterator fujaba__IterCallerClassMethodsCaller = null ;
      Iterator fujaba__IterMultiReference3ElementsCalleeClass = null ;
      Iterator fujaba__IterRefFieldAnnotationsMultiReference3 = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.LoopNode loop = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode4 = null ;
      MultiDelegationAnnotation multiDelegation = null ;
      MultiReferenceAnnotation multiReference3 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr refField = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("callerClass", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            callerClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind refField: UMLAttr
            fujaba__IterCallerClassAttrsRefField = callerClass.iteratorOfAttrs () ;
            while ( fujaba__IterCallerClassAttrsRefField.hasNext () )
            {
               try
               {
                  refField = (UMLAttr) fujaba__IterCallerClassAttrsRefField.next () ;
                   
                  // bind caller: UMLMethod
                  fujaba__IterCallerClassMethodsCaller = callerClass.iteratorOfMethods () ;
                  while ( fujaba__IterCallerClassMethodsCaller.hasNext () )
                  {
                     try
                     {
                        caller = (UMLMethod) fujaba__IterCallerClassMethodsCaller.next () ;
                         
                        // bind root: ASTRootNode
                        root = caller.getASTRootNode () ;
                        JavaSDM.ensure ( root != null ) ;
                         
                        // bind multiReference3: MultiReferenceAnnotation
                        fujaba__IterRefFieldAnnotationsMultiReference3 = refField.iteratorOfAnnotations () ;
                        while ( fujaba__IterRefFieldAnnotationsMultiReference3.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterRefFieldAnnotationsMultiReference3.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof MultiReferenceAnnotation ) ;
                              multiReference3 = (MultiReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between multiReference3 and refField
                              JavaSDM.ensure ( multiReference3.hasInElements ("field", refField) ) ;
                               
                              // bind calleeClass: UMLClass
                              fujaba__IterMultiReference3ElementsCalleeClass = multiReference3.iteratorOfElements ("references") ;
                              while ( fujaba__IterMultiReference3ElementsCalleeClass.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterMultiReference3ElementsCalleeClass.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                    calleeClass = (UMLClass) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                     
                                    // bind callee: UMLMethod
                                    fujaba__IterCalleeClassMethodsCallee = calleeClass.iteratorOfMethods () ;
                                    while ( fujaba__IterCalleeClassMethodsCallee.hasNext () )
                                    {
                                       try
                                       {
                                          callee = (UMLMethod) fujaba__IterCalleeClassMethodsCallee.next () ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                           
                                          // Path search between ASTRootNode and LoopNode
                                          // Bind loop : LoopNode
                                          fujaba__IterRootToLoop = new ASTPathVisitor (root, LoopNode.class ) ;
                                          while ( fujaba__IterRootToLoop.hasNext () )
                                          {
                                             try
                                             {
                                                loop = (de.upb.javaast.methodast.LoopNode) fujaba__IterRootToLoop.next () ;
                                                 
                                                // Path search between LoopNode and MethodCallNode
                                                // Bind methodCallNode4 : MethodCallNode
                                                fujaba__IterLoopToMethodCallNode4 = new ASTPathVisitor (loop, MethodCallNode.class ) ;
                                                while ( fujaba__IterLoopToMethodCallNode4.hasNext () )
                                                {
                                                   try
                                                   {
                                                      methodCallNode4 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterLoopToMethodCallNode4.next () ;
                                                       
                                                      // bind id: IdentifierNode
                                                      id = methodCallNode4.getIdentifier () ;
                                                      JavaSDM.ensure ( id != null ) ;
                                                       
                                                      // constraint
                                                      JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                                       
                                                      // constraint
                                                      JavaSDM.ensure ( caller.getName().equals(callee.getName()) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object callerClass is really bound
                                                            JavaSDM.ensure ( callerClass != null ) ;
                                                             
                                                            // check object caller is really bound
                                                            JavaSDM.ensure ( caller != null ) ;
                                                             
                                                            // check object callee is really bound
                                                            JavaSDM.ensure ( callee != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                             
                                                            // check object calleeClass is really bound
                                                            JavaSDM.ensure ( calleeClass != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                             
                                                            // bind multiDelegation: MultiDelegationAnnotation
                                                            fujaba__IterCalleeClassAnnotationsMultiDelegation = calleeClass.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterCalleeClassAnnotationsMultiDelegation.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterCalleeClassAnnotationsMultiDelegation.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof MultiDelegationAnnotation ) ;
                                                                  multiDelegation = (MultiDelegationAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between multiDelegation and calleeClass
                                                                  JavaSDM.ensure ( multiDelegation.hasInElements ("calleeClass", calleeClass) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between multiDelegation and callerClass
                                                                  JavaSDM.ensure ( multiDelegation.hasInElements ("callerClass", callerClass) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between multiDelegation and caller
                                                                  JavaSDM.ensure ( multiDelegation.hasInElements ("caller", caller) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between multiDelegation and callee
                                                                  JavaSDM.ensure ( multiDelegation.hasInElements ("callee", callee) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object callerClass is really bound
                                                               JavaSDM.ensure ( callerClass != null ) ;
                                                                
                                                               // check object caller is really bound
                                                               JavaSDM.ensure ( caller != null ) ;
                                                                
                                                               // check object callee is really bound
                                                               JavaSDM.ensure ( callee != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                
                                                               // check object calleeClass is really bound
                                                               JavaSDM.ensure ( calleeClass != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                                
                                                               // check object loop is really bound
                                                               JavaSDM.ensure ( loop != null ) ;
                                                                
                                                               // check object refField is really bound
                                                               JavaSDM.ensure ( refField != null ) ;
                                                                
                                                               // check object root is really bound
                                                               JavaSDM.ensure ( root != null ) ;
                                                                
                                                               // check object id is really bound
                                                               JavaSDM.ensure ( id != null ) ;
                                                                
                                                               // create object
                                                               multiDelegation = new MultiDelegationAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               multiDelegation.setClassification (0);
                                                                
                                                               // create link
                                                               multiDelegation.addToElements ("callerClass", callerClass);
                                                                
                                                               // create link
                                                               multiDelegation.addToElements ("caller", caller);
                                                                
                                                               // create link
                                                               multiDelegation.addToElements ("callee", callee);
                                                                
                                                               // create link
                                                               multiDelegation.addToElements ("calleeClass", calleeClass);
                                                                
                                                               // create link
                                                               multiDelegation.addToBoundObjects ("loop", loop);
                                                                
                                                               // create link
                                                               multiDelegation.addToBoundObjects ("callerClass", callerClass);
                                                                
                                                               // create link
                                                               multiDelegation.addToBoundObjects ("refField", refField);
                                                                
                                                               // create link
                                                               multiDelegation.addToBoundObjects ("caller", caller);
                                                                
                                                               // create link
                                                               multiDelegation.addToBoundObjects ("root", root);
                                                                
                                                               // create link
                                                               multiDelegation.addToBoundObjects ("calleeClass", calleeClass);
                                                                
                                                               // create link
                                                               multiDelegation.addToBoundObjects ("callee", callee);
                                                                
                                                               // create link
                                                               multiDelegation.addToBoundObjects ("id", id);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object multiReference3 is really bound
                                                               JavaSDM.ensure ( multiReference3 != null ) ;
                                                                
                                                               // check object multiDelegation is really bound
                                                               JavaSDM.ensure ( multiDelegation != null ) ;
                                                                
                                                               // create link
                                                               multiDelegation.addToAntecedentAnnos (multiReference3);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (multiDelegation) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiDelegation is really bound
            JavaSDM.ensure ( multiDelegation != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("callerClass", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiDelegation) ;
   }


   private GFRNAnnotation annotateUsingCallerRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterLoopToMethodCallNode6 = null ;
      ASTPathVisitor fujaba__IterRootToLoop = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterCalleeClassAnnotationsMultiDelegation = null ;
      Iterator fujaba__IterCalleeClassMethodsCallee = null ;
      Iterator fujaba__IterCallerClassAttrsRefField = null ;
      Iterator fujaba__IterMultiReference5ElementsCalleeClass = null ;
      Iterator fujaba__IterRefFieldAnnotationsMultiReference5 = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.LoopNode loop = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode6 = null ;
      MultiDelegationAnnotation multiDelegation = null ;
      MultiReferenceAnnotation multiReference5 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr refField = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("caller", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            caller = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // bind root: ASTRootNode
            root = caller.getASTRootNode () ;
            JavaSDM.ensure ( root != null ) ;
             
            // bind callerClass: UMLClass
            callerClass = caller.getParent () ;
            JavaSDM.ensure ( callerClass != null ) ;
             
            // bind refField: UMLAttr
            fujaba__IterCallerClassAttrsRefField = callerClass.iteratorOfAttrs () ;
            while ( fujaba__IterCallerClassAttrsRefField.hasNext () )
            {
               try
               {
                  refField = (UMLAttr) fujaba__IterCallerClassAttrsRefField.next () ;
                   
                  // bind multiReference5: MultiReferenceAnnotation
                  fujaba__IterRefFieldAnnotationsMultiReference5 = refField.iteratorOfAnnotations () ;
                  while ( fujaba__IterRefFieldAnnotationsMultiReference5.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterRefFieldAnnotationsMultiReference5.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof MultiReferenceAnnotation ) ;
                        multiReference5 = (MultiReferenceAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between multiReference5 and refField
                        JavaSDM.ensure ( multiReference5.hasInElements ("field", refField) ) ;
                         
                        // bind calleeClass: UMLClass
                        fujaba__IterMultiReference5ElementsCalleeClass = multiReference5.iteratorOfElements ("references") ;
                        while ( fujaba__IterMultiReference5ElementsCalleeClass.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterMultiReference5ElementsCalleeClass.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                              calleeClass = (UMLClass) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                               
                              // bind callee: UMLMethod
                              fujaba__IterCalleeClassMethodsCallee = calleeClass.iteratorOfMethods () ;
                              while ( fujaba__IterCalleeClassMethodsCallee.hasNext () )
                              {
                                 try
                                 {
                                    callee = (UMLMethod) fujaba__IterCalleeClassMethodsCallee.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                     
                                    // Path search between ASTRootNode and LoopNode
                                    // Bind loop : LoopNode
                                    fujaba__IterRootToLoop = new ASTPathVisitor (root, LoopNode.class ) ;
                                    while ( fujaba__IterRootToLoop.hasNext () )
                                    {
                                       try
                                       {
                                          loop = (de.upb.javaast.methodast.LoopNode) fujaba__IterRootToLoop.next () ;
                                           
                                          // Path search between LoopNode and MethodCallNode
                                          // Bind methodCallNode6 : MethodCallNode
                                          fujaba__IterLoopToMethodCallNode6 = new ASTPathVisitor (loop, MethodCallNode.class ) ;
                                          while ( fujaba__IterLoopToMethodCallNode6.hasNext () )
                                          {
                                             try
                                             {
                                                methodCallNode6 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterLoopToMethodCallNode6.next () ;
                                                 
                                                // bind id: IdentifierNode
                                                id = methodCallNode6.getIdentifier () ;
                                                JavaSDM.ensure ( id != null ) ;
                                                 
                                                // constraint
                                                JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                                 
                                                // constraint
                                                JavaSDM.ensure ( caller.getName().equals(callee.getName()) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object callerClass is really bound
                                                      JavaSDM.ensure ( callerClass != null ) ;
                                                       
                                                      // check object caller is really bound
                                                      JavaSDM.ensure ( caller != null ) ;
                                                       
                                                      // check object callee is really bound
                                                      JavaSDM.ensure ( callee != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                       
                                                      // check object calleeClass is really bound
                                                      JavaSDM.ensure ( calleeClass != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                       
                                                      // bind multiDelegation: MultiDelegationAnnotation
                                                      fujaba__IterCalleeClassAnnotationsMultiDelegation = calleeClass.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterCalleeClassAnnotationsMultiDelegation.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterCalleeClassAnnotationsMultiDelegation.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof MultiDelegationAnnotation ) ;
                                                            multiDelegation = (MultiDelegationAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between multiDelegation and calleeClass
                                                            JavaSDM.ensure ( multiDelegation.hasInElements ("calleeClass", calleeClass) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiDelegation and callerClass
                                                            JavaSDM.ensure ( multiDelegation.hasInElements ("callerClass", callerClass) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiDelegation and caller
                                                            JavaSDM.ensure ( multiDelegation.hasInElements ("caller", caller) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiDelegation and callee
                                                            JavaSDM.ensure ( multiDelegation.hasInElements ("callee", callee) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object callerClass is really bound
                                                         JavaSDM.ensure ( callerClass != null ) ;
                                                          
                                                         // check object caller is really bound
                                                         JavaSDM.ensure ( caller != null ) ;
                                                          
                                                         // check object callee is really bound
                                                         JavaSDM.ensure ( callee != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                          
                                                         // check object calleeClass is really bound
                                                         JavaSDM.ensure ( calleeClass != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                          
                                                         // check object loop is really bound
                                                         JavaSDM.ensure ( loop != null ) ;
                                                          
                                                         // check object refField is really bound
                                                         JavaSDM.ensure ( refField != null ) ;
                                                          
                                                         // check object root is really bound
                                                         JavaSDM.ensure ( root != null ) ;
                                                          
                                                         // check object id is really bound
                                                         JavaSDM.ensure ( id != null ) ;
                                                          
                                                         // create object
                                                         multiDelegation = new MultiDelegationAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         multiDelegation.setClassification (0);
                                                          
                                                         // create link
                                                         multiDelegation.addToElements ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         multiDelegation.addToElements ("caller", caller);
                                                          
                                                         // create link
                                                         multiDelegation.addToElements ("callee", callee);
                                                          
                                                         // create link
                                                         multiDelegation.addToElements ("calleeClass", calleeClass);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("loop", loop);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("refField", refField);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("caller", caller);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("root", root);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("calleeClass", calleeClass);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("callee", callee);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("id", id);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object multiReference5 is really bound
                                                         JavaSDM.ensure ( multiReference5 != null ) ;
                                                          
                                                         // check object multiDelegation is really bound
                                                         JavaSDM.ensure ( multiDelegation != null ) ;
                                                          
                                                         // create link
                                                         multiDelegation.addToAntecedentAnnos (multiReference5);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (multiDelegation) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiDelegation is really bound
            JavaSDM.ensure ( multiDelegation != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("caller", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiDelegation) ;
   }


   private GFRNAnnotation annotateUsingTrigger_MultiReferenceRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterLoopToMethodCallNode2 = null ;
      ASTPathVisitor fujaba__IterRootToLoop = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterCalleeAnnotationsMultiDelegation = null ;
      Iterator fujaba__IterCalleeClassMethodsCallee = null ;
      Iterator fujaba__IterCallerClassMethodsCaller = null ;
      Iterator fujaba__IterMultiReference1ElementsCalleeClass = null ;
      Iterator fujaba__IterMultiReference1ElementsRefField = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.LoopNode loop = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode2 = null ;
      MultiDelegationAnnotation multiDelegation = null ;
      MultiReferenceAnnotation multiReference1 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr refField = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_MultiReference", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof MultiReferenceAnnotation ) ;
             
            // explicit type cast
            multiReference1 = (MultiReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind refField: UMLAttr
            fujaba__IterMultiReference1ElementsRefField = multiReference1.iteratorOfElements ("field") ;
            while ( fujaba__IterMultiReference1ElementsRefField.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterMultiReference1ElementsRefField.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                  refField = (UMLAttr) fujaba__TmpObject ;
                   
                  // bind callerClass: UMLClass
                  callerClass = refField.getParent () ;
                  JavaSDM.ensure ( callerClass != null ) ;
                   
                  // bind calleeClass: UMLClass
                  fujaba__IterMultiReference1ElementsCalleeClass = multiReference1.iteratorOfElements ("references") ;
                  while ( fujaba__IterMultiReference1ElementsCalleeClass.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterMultiReference1ElementsCalleeClass.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        calleeClass = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                         
                        // bind caller: UMLMethod
                        fujaba__IterCallerClassMethodsCaller = callerClass.iteratorOfMethods () ;
                        while ( fujaba__IterCallerClassMethodsCaller.hasNext () )
                        {
                           try
                           {
                              caller = (UMLMethod) fujaba__IterCallerClassMethodsCaller.next () ;
                               
                              // bind root: ASTRootNode
                              root = caller.getASTRootNode () ;
                              JavaSDM.ensure ( root != null ) ;
                               
                              // bind callee: UMLMethod
                              fujaba__IterCalleeClassMethodsCallee = calleeClass.iteratorOfMethods () ;
                              while ( fujaba__IterCalleeClassMethodsCallee.hasNext () )
                              {
                                 try
                                 {
                                    callee = (UMLMethod) fujaba__IterCalleeClassMethodsCallee.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                     
                                    // Path search between ASTRootNode and LoopNode
                                    // Bind loop : LoopNode
                                    fujaba__IterRootToLoop = new ASTPathVisitor (root, LoopNode.class ) ;
                                    while ( fujaba__IterRootToLoop.hasNext () )
                                    {
                                       try
                                       {
                                          loop = (de.upb.javaast.methodast.LoopNode) fujaba__IterRootToLoop.next () ;
                                           
                                          // Path search between LoopNode and MethodCallNode
                                          // Bind methodCallNode2 : MethodCallNode
                                          fujaba__IterLoopToMethodCallNode2 = new ASTPathVisitor (loop, MethodCallNode.class ) ;
                                          while ( fujaba__IterLoopToMethodCallNode2.hasNext () )
                                          {
                                             try
                                             {
                                                methodCallNode2 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterLoopToMethodCallNode2.next () ;
                                                 
                                                // bind id: IdentifierNode
                                                id = methodCallNode2.getIdentifier () ;
                                                JavaSDM.ensure ( id != null ) ;
                                                 
                                                // constraint
                                                JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                                 
                                                // constraint
                                                JavaSDM.ensure ( caller.getName().equals(callee.getName()) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object callerClass is really bound
                                                      JavaSDM.ensure ( callerClass != null ) ;
                                                       
                                                      // check object caller is really bound
                                                      JavaSDM.ensure ( caller != null ) ;
                                                       
                                                      // check object callee is really bound
                                                      JavaSDM.ensure ( callee != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                       
                                                      // check object calleeClass is really bound
                                                      JavaSDM.ensure ( calleeClass != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                       
                                                      // bind multiDelegation: MultiDelegationAnnotation
                                                      fujaba__IterCalleeAnnotationsMultiDelegation = callee.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterCalleeAnnotationsMultiDelegation.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterCalleeAnnotationsMultiDelegation.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof MultiDelegationAnnotation ) ;
                                                            multiDelegation = (MultiDelegationAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between multiDelegation and callee
                                                            JavaSDM.ensure ( multiDelegation.hasInElements ("callee", callee) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiDelegation and callerClass
                                                            JavaSDM.ensure ( multiDelegation.hasInElements ("callerClass", callerClass) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiDelegation and caller
                                                            JavaSDM.ensure ( multiDelegation.hasInElements ("caller", caller) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiDelegation and calleeClass
                                                            JavaSDM.ensure ( multiDelegation.hasInElements ("calleeClass", calleeClass) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object callerClass is really bound
                                                         JavaSDM.ensure ( callerClass != null ) ;
                                                          
                                                         // check object caller is really bound
                                                         JavaSDM.ensure ( caller != null ) ;
                                                          
                                                         // check object callee is really bound
                                                         JavaSDM.ensure ( callee != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                          
                                                         // check object calleeClass is really bound
                                                         JavaSDM.ensure ( calleeClass != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                          
                                                         // check object loop is really bound
                                                         JavaSDM.ensure ( loop != null ) ;
                                                          
                                                         // check object refField is really bound
                                                         JavaSDM.ensure ( refField != null ) ;
                                                          
                                                         // check object root is really bound
                                                         JavaSDM.ensure ( root != null ) ;
                                                          
                                                         // check object id is really bound
                                                         JavaSDM.ensure ( id != null ) ;
                                                          
                                                         // create object
                                                         multiDelegation = new MultiDelegationAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         multiDelegation.setClassification (0);
                                                          
                                                         // create link
                                                         multiDelegation.addToElements ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         multiDelegation.addToElements ("caller", caller);
                                                          
                                                         // create link
                                                         multiDelegation.addToElements ("callee", callee);
                                                          
                                                         // create link
                                                         multiDelegation.addToElements ("calleeClass", calleeClass);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("loop", loop);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("refField", refField);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("caller", caller);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("root", root);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("calleeClass", calleeClass);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("callee", callee);
                                                          
                                                         // create link
                                                         multiDelegation.addToBoundObjects ("id", id);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object multiReference1 is really bound
                                                         JavaSDM.ensure ( multiReference1 != null ) ;
                                                          
                                                         // check object multiDelegation is really bound
                                                         JavaSDM.ensure ( multiDelegation != null ) ;
                                                          
                                                         // create link
                                                         multiDelegation.addToAntecedentAnnos (multiReference1);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (multiDelegation) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiDelegation is really bound
            JavaSDM.ensure ( multiDelegation != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_MultiReference", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiDelegation) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("callerClass", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLMethod )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("caller", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLMethod )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("callee", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("calleeClass", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof MultiReferenceAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_MultiReference", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterCallerClassAttrsRefField = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr refField = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("MultiReference") || annotation.equals ("ArrayReference") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            callerClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind refField: UMLAttr
            fujaba__IterCallerClassAttrsRefField = callerClass.iteratorOfAttrs () ;
            while ( fujaba__IterCallerClassAttrsRefField.hasNext () )
            {
               try
               {
                  refField = (UMLAttr) fujaba__IterCallerClassAttrsRefField.next () ;
                   
                  {
                     //  for each flow
                     set.add (refField);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            caller = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // bind callerClass: UMLClass
            callerClass = caller.getParent () ;
            JavaSDM.ensure ( callerClass != null ) ;
             
            // bind refField: UMLAttr
            fujaba__IterCallerClassAttrsRefField = callerClass.iteratorOfAttrs () ;
            while ( fujaba__IterCallerClassAttrsRefField.hasNext () )
            {
               try
               {
                  refField = (UMLAttr) fujaba__IterCallerClassAttrsRefField.next () ;
                   
                  {
                     //  for each flow
                     set.add (refField);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            callee = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // bind calleeClass: UMLClass
            calleeClass = callee.getParent () ;
            JavaSDM.ensure ( calleeClass != null ) ;
             
            {
               //  for each flow
               set.add (calleeClass);
            } //  end for each flow
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            calleeClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (calleeClass);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
