package de.upb.inferenceengine.engines;

import de.upb.tools.fca.FEmptyIterator;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;

public class GeneralizationEngine
extends GFRNEngine
{
   private  GeneralizationEngine()
   {
   }

   private static GeneralizationEngine theGeneralizationEngine;

   public static GeneralizationEngine get()
   {
      if (theGeneralizationEngine == null)
      {
         theGeneralizationEngine = new GeneralizationEngine ();
      }
      return theGeneralizationEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation generalization = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         generalization = this.annotateUsingTrigger_UMLGeneralizationRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( generalization != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (generalization) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            generalization = this.annotateUsingSubClassRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( generalization != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (generalization) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               generalization = this.annotateUsingSuperClassRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            return (generalization) ;
         }
      }
   }


   private GFRNAnnotation annotateUsingSubClassRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterSubClassRevSubclassGen = null ;
      Iterator fujaba__IterSuperClassAnnotationsGeneralization = null ;
      GeneralizationAnnotation generalization = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLClass subClass = null ;
      UMLClass superClass = null ;
      UMLGeneralization gen = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("subClass", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            subClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind gen: UMLGeneralization
            fujaba__IterSubClassRevSubclassGen = subClass.iteratorOfRevSubclass () ;
            while ( fujaba__IterSubClassRevSubclassGen.hasNext () )
            {
               try
               {
                  gen = (UMLGeneralization) fujaba__IterSubClassRevSubclassGen.next () ;
                   
                  // bind superClass: UMLClass
                  superClass = gen.getSuperclass () ;
                  JavaSDM.ensure ( superClass != null ) ;
                   
                  // check isomorphic binding
                  JavaSDM.ensure ( !(subClass.equals (superClass)) ) ;
                   
                  {
                     //  for each flow
                     try
                     {
                        fujaba__Success = false ;
                         
                        // check object subClass is really bound
                        JavaSDM.ensure ( subClass != null ) ;
                         
                        // check object superClass is really bound
                        JavaSDM.ensure ( superClass != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(subClass.equals (superClass)) ) ;
                         
                        // bind generalization: GeneralizationAnnotation
                        fujaba__IterSuperClassAnnotationsGeneralization = superClass.iteratorOfAnnotations () ;
                        while ( !(fujaba__Success) && fujaba__IterSuperClassAnnotationsGeneralization.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterSuperClassAnnotationsGeneralization.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                              generalization = (GeneralizationAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between generalization and superClass
                              JavaSDM.ensure ( generalization.hasInElements ("superClass", superClass) ) ;
                               
                              // check To-Many-Link 'elements' between generalization and subClass
                              JavaSDM.ensure ( generalization.hasInElements ("subClass", subClass) ) ;
                               
                              fujaba__Success = true ;
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                        fujaba__Success = false ;
                     }
                      
                     if ( !(fujaba__Success) )
                     {
                        try
                        {
                           fujaba__Success = false ;
                            
                           // check object subClass is really bound
                           JavaSDM.ensure ( subClass != null ) ;
                            
                           // check object superClass is really bound
                           JavaSDM.ensure ( superClass != null ) ;
                            
                           // check isomorphic binding
                           JavaSDM.ensure ( !(subClass.equals (superClass)) ) ;
                            
                           // check object gen is really bound
                           JavaSDM.ensure ( gen != null ) ;
                            
                           // create object
                           generalization = new GeneralizationAnnotation ( ) ;
                            
                           // assign statement
                           generalization.setClassification (0);
                            
                           // create link
                           generalization.addToElements ("subClass", subClass);
                            
                           // create link
                           generalization.addToElements ("superClass", superClass);
                            
                           // create link
                           generalization.addToBoundObjects ("gen", gen);
                            
                           // create link
                           generalization.addToBoundObjects ("subClass", subClass);
                            
                           // create link
                           generalization.addToBoundObjects ("superClass", superClass);
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        try
                        {
                           fujaba__Success = false ;
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        return (generalization) ;
                     }
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object generalization is really bound
            JavaSDM.ensure ( generalization != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("subClass", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (generalization) ;
   }


   private GFRNAnnotation annotateUsingSuperClassRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterSuperClassAnnotationsGeneralization = null ;
      Iterator fujaba__IterSuperClassRevSuperclassGen = null ;
      GeneralizationAnnotation generalization = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLClass subClass = null ;
      UMLClass superClass = null ;
      UMLGeneralization gen = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("superClass", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            superClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind gen: UMLGeneralization
            fujaba__IterSuperClassRevSuperclassGen = superClass.iteratorOfRevSuperclass () ;
            while ( fujaba__IterSuperClassRevSuperclassGen.hasNext () )
            {
               try
               {
                  gen = (UMLGeneralization) fujaba__IterSuperClassRevSuperclassGen.next () ;
                   
                  // bind subClass: UMLClass
                  subClass = gen.getSubclass () ;
                  JavaSDM.ensure ( subClass != null ) ;
                   
                  // check isomorphic binding
                  JavaSDM.ensure ( !(superClass.equals (subClass)) ) ;
                   
                  {
                     //  for each flow
                     try
                     {
                        fujaba__Success = false ;
                         
                        // check object subClass is really bound
                        JavaSDM.ensure ( subClass != null ) ;
                         
                        // check object superClass is really bound
                        JavaSDM.ensure ( superClass != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(subClass.equals (superClass)) ) ;
                         
                        // bind generalization: GeneralizationAnnotation
                        fujaba__IterSuperClassAnnotationsGeneralization = superClass.iteratorOfAnnotations () ;
                        while ( !(fujaba__Success) && fujaba__IterSuperClassAnnotationsGeneralization.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterSuperClassAnnotationsGeneralization.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                              generalization = (GeneralizationAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between generalization and superClass
                              JavaSDM.ensure ( generalization.hasInElements ("superClass", superClass) ) ;
                               
                              // check To-Many-Link 'elements' between generalization and subClass
                              JavaSDM.ensure ( generalization.hasInElements ("subClass", subClass) ) ;
                               
                              fujaba__Success = true ;
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                        fujaba__Success = false ;
                     }
                      
                     if ( !(fujaba__Success) )
                     {
                        try
                        {
                           fujaba__Success = false ;
                            
                           // check object subClass is really bound
                           JavaSDM.ensure ( subClass != null ) ;
                            
                           // check object superClass is really bound
                           JavaSDM.ensure ( superClass != null ) ;
                            
                           // check isomorphic binding
                           JavaSDM.ensure ( !(subClass.equals (superClass)) ) ;
                            
                           // check object gen is really bound
                           JavaSDM.ensure ( gen != null ) ;
                            
                           // create object
                           generalization = new GeneralizationAnnotation ( ) ;
                            
                           // assign statement
                           generalization.setClassification (0);
                            
                           // create link
                           generalization.addToElements ("subClass", subClass);
                            
                           // create link
                           generalization.addToElements ("superClass", superClass);
                            
                           // create link
                           generalization.addToBoundObjects ("gen", gen);
                            
                           // create link
                           generalization.addToBoundObjects ("subClass", subClass);
                            
                           // create link
                           generalization.addToBoundObjects ("superClass", superClass);
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        try
                        {
                           fujaba__Success = false ;
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        return (generalization) ;
                     }
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object generalization is really bound
            JavaSDM.ensure ( generalization != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("superClass", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (generalization) ;
   }


   private GFRNAnnotation annotateUsingTrigger_UMLGeneralizationRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterSuperClassAnnotationsGeneralization = null ;
      GeneralizationAnnotation generalization = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLClass subClass = null ;
      UMLClass superClass = null ;
      UMLGeneralization gen = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_UMLGeneralization", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLGeneralization ) ;
             
            // explicit type cast
            gen = (UMLGeneralization) fujaba__tmpTypeCastObject ;
             
            // bind superClass: UMLClass
            superClass = gen.getSuperclass () ;
            JavaSDM.ensure ( superClass != null ) ;
             
            // bind subClass: UMLClass
            subClass = gen.getSubclass () ;
            JavaSDM.ensure ( subClass != null ) ;
             
            // check isomorphic binding
            JavaSDM.ensure ( !(superClass.equals (subClass)) ) ;
             
            {
               //  for each flow
               try
               {
                  fujaba__Success = false ;
                   
                  // check object subClass is really bound
                  JavaSDM.ensure ( subClass != null ) ;
                   
                  // check object superClass is really bound
                  JavaSDM.ensure ( superClass != null ) ;
                   
                  // check isomorphic binding
                  JavaSDM.ensure ( !(subClass.equals (superClass)) ) ;
                   
                  // bind generalization: GeneralizationAnnotation
                  fujaba__IterSuperClassAnnotationsGeneralization = superClass.iteratorOfAnnotations () ;
                  while ( !(fujaba__Success) && fujaba__IterSuperClassAnnotationsGeneralization.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterSuperClassAnnotationsGeneralization.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                        generalization = (GeneralizationAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between generalization and superClass
                        JavaSDM.ensure ( generalization.hasInElements ("superClass", superClass) ) ;
                         
                        // check To-Many-Link 'elements' between generalization and subClass
                        JavaSDM.ensure ( generalization.hasInElements ("subClass", subClass) ) ;
                         
                        fujaba__Success = true ;
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( !(fujaba__Success) )
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // check object subClass is really bound
                     JavaSDM.ensure ( subClass != null ) ;
                      
                     // check object superClass is really bound
                     JavaSDM.ensure ( superClass != null ) ;
                      
                     // check isomorphic binding
                     JavaSDM.ensure ( !(subClass.equals (superClass)) ) ;
                      
                     // check object gen is really bound
                     JavaSDM.ensure ( gen != null ) ;
                      
                     // create object
                     generalization = new GeneralizationAnnotation ( ) ;
                      
                     // assign statement
                     generalization.setClassification (0);
                      
                     // create link
                     generalization.addToElements ("subClass", subClass);
                      
                     // create link
                     generalization.addToElements ("superClass", superClass);
                      
                     // create link
                     generalization.addToBoundObjects ("gen", gen);
                      
                     // create link
                     generalization.addToBoundObjects ("subClass", subClass);
                      
                     // create link
                     generalization.addToBoundObjects ("superClass", superClass);
                      
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  try
                  {
                     fujaba__Success = false ;
                      
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  return (generalization) ;
               }
            } //  end for each flow
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object generalization is really bound
            JavaSDM.ensure ( generalization != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_UMLGeneralization", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (generalization) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("subClass", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("superClass", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLGeneralization )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_UMLGeneralization", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      return (FEmptyIterator.get()) ;
   }


}
