package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLClass;

public class FacadeEngine
extends GFRNEngine
{
   private  FacadeEngine()
   {
   }

   private static FacadeEngine theFacadeEngine;

   public static FacadeEngine get()
   {
      if (theFacadeEngine == null)
      {
         theFacadeEngine = new FacadeEngine ();
      }
      return theFacadeEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation facade = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         facade = this.annotateUsingFacadeRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( facade != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (facade) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            facade = this.annotateUsingTrigger_NeighborCallRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         return (facade) ;
      }
   }


   private GFRNAnnotation annotateUsingFacadeRole(ASGElement asgElement)
   {
      de.upb.tools.fca.FHashSet ncs = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterFacadeClassAnnotationsFacade = null ;
      Iterator fujaba__IterNcs = null ;
      FacadeAnnotation facade = null ;
      NeighborCallAnnotation fujaba__TmpObjectNeighborCallAnnotation = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLClass facadeClass = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("facade", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            facadeClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // linkSearchToSetTop
            ncs = new de.upb.tools.fca.FHashSet ( ) ;
            fujaba__IterNcs = facadeClass.iteratorOfAnnotations () ;
            while ( fujaba__IterNcs.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNcs.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                  fujaba__TmpObjectNeighborCallAnnotation = (NeighborCallAnnotation) fujaba__TmpObject ;
                   
                  ncs.add (fujaba__TmpObjectNeighborCallAnnotation);
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            } // while
            // constraint
            JavaSDM.ensure ( ncs.size() >= 6 ) ;
             
            {
               //  for each flow
               try
               {
                  fujaba__Success = false ;
                   
                  // check object facadeClass is really bound
                  JavaSDM.ensure ( facadeClass != null ) ;
                   
                  // bind facade: FacadeAnnotation
                  fujaba__IterFacadeClassAnnotationsFacade = facadeClass.iteratorOfAnnotations () ;
                  while ( !(fujaba__Success) && fujaba__IterFacadeClassAnnotationsFacade.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterFacadeClassAnnotationsFacade.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof FacadeAnnotation ) ;
                        facade = (FacadeAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between facade and facadeClass
                        JavaSDM.ensure ( facade.hasInElements ("facade", facadeClass) ) ;
                         
                        fujaba__Success = true ;
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( !(fujaba__Success) )
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // check object facadeClass is really bound
                     JavaSDM.ensure ( facadeClass != null ) ;
                      
                     // create object
                     facade = new FacadeAnnotation ( ) ;
                      
                     // assign statement
                     facade.setClassification (1);
                      
                     // create link
                     facade.addToElements ("facade", facadeClass);
                      
                     // create link
                     facade.addToBoundObjects ("facadeClass", facadeClass);
                      
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  try
                  {
                     fujaba__Success = false ;
                      
                     // check object facade is really bound
                     JavaSDM.ensure ( facade != null ) ;
                      
                     fujaba__IterNcs = ncs.iterator () ;
                     while ( fujaba__IterNcs.hasNext () )
                     {
                        fujaba__TmpObjectNeighborCallAnnotation = (NeighborCallAnnotation) fujaba__IterNcs.next () ;
                        //  create set link
                        facade.addToAntecedentAnnos (fujaba__TmpObjectNeighborCallAnnotation);
                        fujaba__Success = true ;
                     } // while
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  return (facade) ;
               }
            } //  end for each flow
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object facade is really bound
            JavaSDM.ensure ( facade != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("facade", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (facade) ;
   }


   private GFRNAnnotation annotateUsingTrigger_NeighborCallRole(ASGElement asgElement)
   {
      de.upb.tools.fca.FHashSet ncs = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterFacadeClassAnnotationsFacade = null ;
      Iterator fujaba__IterNcs = null ;
      Iterator fujaba__IterNcsNonSetTriggerElementsFacadeClass = null ;
      FacadeAnnotation facade = null ;
      NeighborCallAnnotation fujaba__TmpObjectNeighborCallAnnotation = null ;
      NeighborCallAnnotation ncsNonSetTrigger = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLClass facadeClass = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            ncsNonSetTrigger = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind facadeClass: UMLClass
            fujaba__IterNcsNonSetTriggerElementsFacadeClass = ncsNonSetTrigger.iteratorOfElements ("callerClass") ;
            while ( fujaba__IterNcsNonSetTriggerElementsFacadeClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNcsNonSetTriggerElementsFacadeClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  facadeClass = (UMLClass) fujaba__TmpObject ;
                   
                  // linkSearchToSetTop
                  ncs = new de.upb.tools.fca.FHashSet ( ) ;
                  fujaba__IterNcs = facadeClass.iteratorOfAnnotations () ;
                  while ( fujaba__IterNcs.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterNcs.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        fujaba__TmpObjectNeighborCallAnnotation = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        ncs.add (fujaba__TmpObjectNeighborCallAnnotation);
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  } // while
                  // constraint
                  JavaSDM.ensure ( ncs.size() >= 6 ) ;
                   
                  {
                     //  for each flow
                     try
                     {
                        fujaba__Success = false ;
                         
                        // check object facadeClass is really bound
                        JavaSDM.ensure ( facadeClass != null ) ;
                         
                        // bind facade: FacadeAnnotation
                        fujaba__IterFacadeClassAnnotationsFacade = facadeClass.iteratorOfAnnotations () ;
                        while ( !(fujaba__Success) && fujaba__IterFacadeClassAnnotationsFacade.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterFacadeClassAnnotationsFacade.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof FacadeAnnotation ) ;
                              facade = (FacadeAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between facade and facadeClass
                              JavaSDM.ensure ( facade.hasInElements ("facade", facadeClass) ) ;
                               
                              fujaba__Success = true ;
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                        fujaba__Success = false ;
                     }
                      
                     if ( !(fujaba__Success) )
                     {
                        try
                        {
                           fujaba__Success = false ;
                            
                           // check object facadeClass is really bound
                           JavaSDM.ensure ( facadeClass != null ) ;
                            
                           // create object
                           facade = new FacadeAnnotation ( ) ;
                            
                           // assign statement
                           facade.setClassification (1);
                            
                           // create link
                           facade.addToElements ("facade", facadeClass);
                            
                           // create link
                           facade.addToBoundObjects ("facadeClass", facadeClass);
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        try
                        {
                           fujaba__Success = false ;
                            
                           // check object facade is really bound
                           JavaSDM.ensure ( facade != null ) ;
                            
                           fujaba__IterNcs = ncs.iterator () ;
                           while ( fujaba__IterNcs.hasNext () )
                           {
                              fujaba__TmpObjectNeighborCallAnnotation = (NeighborCallAnnotation) fujaba__IterNcs.next () ;
                              //  create set link
                              facade.addToAntecedentAnnos (fujaba__TmpObjectNeighborCallAnnotation);
                              fujaba__Success = true ;
                           } // while
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        return (facade) ;
                     }
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object facade is really bound
            JavaSDM.ensure ( facade != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_NeighborCall", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (facade) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("facade", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof NeighborCallAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterNcsElementsFacadeClass = null ;
      NeighborCallAnnotation ncs = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLClass facadeClass = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("NeighborCall") || annotation.equals ("Delegation") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            facadeClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (facadeClass);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            ncs = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind facadeClass: UMLClass
            fujaba__IterNcsElementsFacadeClass = ncs.iteratorOfElements ("callerClass") ;
            while ( fujaba__IterNcsElementsFacadeClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNcsElementsFacadeClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  facadeClass = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (facadeClass);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
