package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLMethod;

public class DecoratorEngine
extends GFRNEngine
{
   private  DecoratorEngine()
   {
   }

   private static DecoratorEngine theDecoratorEngine;

   public static DecoratorEngine get()
   {
      if (theDecoratorEngine == null)
      {
         theDecoratorEngine = new DecoratorEngine ();
      }
      return theDecoratorEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation decorator = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         decorator = this.annotateUsingTrigger_SingleReferenceRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( decorator != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (decorator) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            decorator = this.annotateUsingComponentRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( decorator != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (decorator) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               decorator = this.annotateUsingTrigger_GeneralizationRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( decorator != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (decorator) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  decorator = this.annotateUsingDecoratorRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               try
               {
                  fujaba__Success = false ;
                   
                  // constraint
                  JavaSDM.ensure ( decorator != null ) ;
                   
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( fujaba__Success )
               {
                  return (decorator) ;
               }
               else
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // collabStatBegin 1 is empty !
                     decorator = this.annotateUsingTrigger_SingleReferenceRole(asgElement);
                      
                     // collabStatEnd
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  try
                  {
                     fujaba__Success = false ;
                      
                     // constraint
                     JavaSDM.ensure ( decorator != null ) ;
                      
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  if ( fujaba__Success )
                  {
                     return (decorator) ;
                  }
                  else
                  {
                     try
                     {
                        fujaba__Success = false ;
                         
                        // collabStatBegin 1 is empty !
                        decorator = this.annotateUsingTrigger_NeighborCallRole(asgElement);
                         
                        // collabStatEnd
                        fujaba__Success = true ;
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                        fujaba__Success = false ;
                     }
                      
                     return (decorator) ;
                  }
               }
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingComponentRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      DecoratorAnnotation decorator = null ;
      Iterator fujaba__IterCalleeAnnotationsNeighborCall8 = null ;
      Iterator fujaba__IterComponentClassAnnotationsGeneralization6 = null ;
      Iterator fujaba__IterComponentClassAnnotationsSingleReference5 = null ;
      Iterator fujaba__IterComponentClassAnnotationsSingleReference7 = null ;
      Iterator fujaba__IterComponentClassMethodsCallee = null ;
      Iterator fujaba__IterDecoratorClassAnnotationsDecorator = null ;
      Iterator fujaba__IterGeneralization6ElementsDecoratorClass = null ;
      Iterator fujaba__IterNeighborCall8ElementsCaller = null ;
      GeneralizationAnnotation generalization6 = null ;
      NeighborCallAnnotation neighborCall8 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      SingleReferenceAnnotation singleReference5 = null ;
      SingleReferenceAnnotation singleReference7 = null ;
      UMLClass componentClass = null ;
      UMLClass decoratorClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("component", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            componentClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind callee: UMLMethod
            fujaba__IterComponentClassMethodsCallee = componentClass.iteratorOfMethods () ;
            while ( fujaba__IterComponentClassMethodsCallee.hasNext () )
            {
               try
               {
                  callee = (UMLMethod) fujaba__IterComponentClassMethodsCallee.next () ;
                   
                  // bind generalization6: GeneralizationAnnotation
                  fujaba__IterComponentClassAnnotationsGeneralization6 = componentClass.iteratorOfAnnotations () ;
                  while ( fujaba__IterComponentClassAnnotationsGeneralization6.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterComponentClassAnnotationsGeneralization6.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                        generalization6 = (GeneralizationAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between generalization6 and componentClass
                        JavaSDM.ensure ( generalization6.hasInElements ("superClass", componentClass) ) ;
                         
                        // bind singleReference7: SingleReferenceAnnotation
                        fujaba__IterComponentClassAnnotationsSingleReference7 = componentClass.iteratorOfAnnotations () ;
                        while ( fujaba__IterComponentClassAnnotationsSingleReference7.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterComponentClassAnnotationsSingleReference7.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof SingleReferenceAnnotation ) ;
                              singleReference7 = (SingleReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between singleReference7 and componentClass
                              JavaSDM.ensure ( singleReference7.hasInElements ("referencingClass", componentClass) ) ;
                               
                              // bind singleReference5: SingleReferenceAnnotation
                              fujaba__IterComponentClassAnnotationsSingleReference5 = componentClass.iteratorOfAnnotations () ;
                              while ( fujaba__IterComponentClassAnnotationsSingleReference5.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterComponentClassAnnotationsSingleReference5.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof SingleReferenceAnnotation ) ;
                                    singleReference5 = (SingleReferenceAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between singleReference5 and componentClass
                                    JavaSDM.ensure ( singleReference5.hasInElements ("references", componentClass) ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(singleReference7.equals (singleReference5)) ) ;
                                     
                                    // bind neighborCall8: NeighborCallAnnotation
                                    fujaba__IterCalleeAnnotationsNeighborCall8 = callee.iteratorOfAnnotations () ;
                                    while ( fujaba__IterCalleeAnnotationsNeighborCall8.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterCalleeAnnotationsNeighborCall8.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                          neighborCall8 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between neighborCall8 and callee
                                          JavaSDM.ensure ( neighborCall8.hasInElements ("callee", callee) ) ;
                                           
                                          // bind decoratorClass: UMLClass
                                          fujaba__IterGeneralization6ElementsDecoratorClass = generalization6.iteratorOfElements ("subClass") ;
                                          while ( fujaba__IterGeneralization6ElementsDecoratorClass.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterGeneralization6ElementsDecoratorClass.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                                decoratorClass = (UMLClass) fujaba__TmpObject ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(componentClass.equals (decoratorClass)) ) ;
                                                 
                                                // check To-Many-Link 'elements' between singleReference7 and decoratorClass
                                                JavaSDM.ensure ( singleReference7.hasInElements ("references", decoratorClass) ) ;
                                                 
                                                // check To-Many-Link 'elements' between singleReference5 and decoratorClass
                                                JavaSDM.ensure ( singleReference5.hasInElements ("referencingClass", decoratorClass) ) ;
                                                 
                                                // bind caller: UMLMethod
                                                fujaba__IterNeighborCall8ElementsCaller = neighborCall8.iteratorOfElements ("caller") ;
                                                while ( fujaba__IterNeighborCall8ElementsCaller.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterNeighborCall8ElementsCaller.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                      caller = (UMLMethod) fujaba__TmpObject ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(callee.equals (caller)) ) ;
                                                       
                                                      // check To-One-Link 'parent' between caller and decoratorClass
                                                      JavaSDM.ensure ( (caller.getParent () != null) && caller.getParent ().equals (decoratorClass) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object componentClass is really bound
                                                            JavaSDM.ensure ( componentClass != null ) ;
                                                             
                                                            // check object decoratorClass is really bound
                                                            JavaSDM.ensure ( decoratorClass != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(componentClass.equals (decoratorClass)) ) ;
                                                             
                                                            // bind decorator: DecoratorAnnotation
                                                            fujaba__IterDecoratorClassAnnotationsDecorator = decoratorClass.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterDecoratorClassAnnotationsDecorator.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterDecoratorClassAnnotationsDecorator.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof DecoratorAnnotation ) ;
                                                                  decorator = (DecoratorAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between decorator and decoratorClass
                                                                  JavaSDM.ensure ( decorator.hasInElements ("decorator", decoratorClass) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between decorator and componentClass
                                                                  JavaSDM.ensure ( decorator.hasInElements ("component", componentClass) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object componentClass is really bound
                                                               JavaSDM.ensure ( componentClass != null ) ;
                                                                
                                                               // check object decoratorClass is really bound
                                                               JavaSDM.ensure ( decoratorClass != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(componentClass.equals (decoratorClass)) ) ;
                                                                
                                                               // check object caller is really bound
                                                               JavaSDM.ensure ( caller != null ) ;
                                                                
                                                               // check object callee is really bound
                                                               JavaSDM.ensure ( callee != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                
                                                               // create object
                                                               decorator = new DecoratorAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               decorator.setClassification (1);
                                                                
                                                               // create link
                                                               decorator.addToElements ("component", componentClass);
                                                                
                                                               // create link
                                                               decorator.addToElements ("decorator", decoratorClass);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("componentClass", componentClass);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("decoratorClass", decoratorClass);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("caller", caller);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("callee", callee);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object singleReference5 is really bound
                                                               JavaSDM.ensure ( singleReference5 != null ) ;
                                                                
                                                               // check object generalization6 is really bound
                                                               JavaSDM.ensure ( generalization6 != null ) ;
                                                                
                                                               // check object singleReference7 is really bound
                                                               JavaSDM.ensure ( singleReference7 != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(singleReference5.equals (singleReference7)) ) ;
                                                                
                                                               // check object neighborCall8 is really bound
                                                               JavaSDM.ensure ( neighborCall8 != null ) ;
                                                                
                                                               // check object decorator is really bound
                                                               JavaSDM.ensure ( decorator != null ) ;
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (singleReference5);
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (generalization6);
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (singleReference7);
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (neighborCall8);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (decorator) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object decorator is really bound
            JavaSDM.ensure ( decorator != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("component", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (decorator) ;
   }


   private GFRNAnnotation annotateUsingDecoratorRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      DecoratorAnnotation decorator = null ;
      Iterator fujaba__IterCallerAnnotationsNeighborCall16 = null ;
      Iterator fujaba__IterDecoratorClassAnnotationsDecorator = null ;
      Iterator fujaba__IterDecoratorClassAnnotationsGeneralization14 = null ;
      Iterator fujaba__IterDecoratorClassAnnotationsSingleReference13 = null ;
      Iterator fujaba__IterDecoratorClassAnnotationsSingleReference15 = null ;
      Iterator fujaba__IterDecoratorClassMethodsCaller = null ;
      Iterator fujaba__IterGeneralization14ElementsComponentClass = null ;
      Iterator fujaba__IterNeighborCall16ElementsCallee = null ;
      GeneralizationAnnotation generalization14 = null ;
      NeighborCallAnnotation neighborCall16 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      SingleReferenceAnnotation singleReference13 = null ;
      SingleReferenceAnnotation singleReference15 = null ;
      UMLClass componentClass = null ;
      UMLClass decoratorClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("decorator", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            decoratorClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterDecoratorClassMethodsCaller = decoratorClass.iteratorOfMethods () ;
            while ( fujaba__IterDecoratorClassMethodsCaller.hasNext () )
            {
               try
               {
                  caller = (UMLMethod) fujaba__IterDecoratorClassMethodsCaller.next () ;
                   
                  // bind generalization14: GeneralizationAnnotation
                  fujaba__IterDecoratorClassAnnotationsGeneralization14 = decoratorClass.iteratorOfAnnotations () ;
                  while ( fujaba__IterDecoratorClassAnnotationsGeneralization14.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterDecoratorClassAnnotationsGeneralization14.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                        generalization14 = (GeneralizationAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between generalization14 and decoratorClass
                        JavaSDM.ensure ( generalization14.hasInElements ("subClass", decoratorClass) ) ;
                         
                        // bind singleReference15: SingleReferenceAnnotation
                        fujaba__IterDecoratorClassAnnotationsSingleReference15 = decoratorClass.iteratorOfAnnotations () ;
                        while ( fujaba__IterDecoratorClassAnnotationsSingleReference15.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterDecoratorClassAnnotationsSingleReference15.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof SingleReferenceAnnotation ) ;
                              singleReference15 = (SingleReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between singleReference15 and decoratorClass
                              JavaSDM.ensure ( singleReference15.hasInElements ("references", decoratorClass) ) ;
                               
                              // bind singleReference13: SingleReferenceAnnotation
                              fujaba__IterDecoratorClassAnnotationsSingleReference13 = decoratorClass.iteratorOfAnnotations () ;
                              while ( fujaba__IterDecoratorClassAnnotationsSingleReference13.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterDecoratorClassAnnotationsSingleReference13.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof SingleReferenceAnnotation ) ;
                                    singleReference13 = (SingleReferenceAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between singleReference13 and decoratorClass
                                    JavaSDM.ensure ( singleReference13.hasInElements ("referencingClass", decoratorClass) ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(singleReference15.equals (singleReference13)) ) ;
                                     
                                    // bind neighborCall16: NeighborCallAnnotation
                                    fujaba__IterCallerAnnotationsNeighborCall16 = caller.iteratorOfAnnotations () ;
                                    while ( fujaba__IterCallerAnnotationsNeighborCall16.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterCallerAnnotationsNeighborCall16.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                          neighborCall16 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between neighborCall16 and caller
                                          JavaSDM.ensure ( neighborCall16.hasInElements ("caller", caller) ) ;
                                           
                                          // bind componentClass: UMLClass
                                          fujaba__IterGeneralization14ElementsComponentClass = generalization14.iteratorOfElements ("superClass") ;
                                          while ( fujaba__IterGeneralization14ElementsComponentClass.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterGeneralization14ElementsComponentClass.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                                componentClass = (UMLClass) fujaba__TmpObject ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(decoratorClass.equals (componentClass)) ) ;
                                                 
                                                // check To-Many-Link 'elements' between singleReference15 and componentClass
                                                JavaSDM.ensure ( singleReference15.hasInElements ("referencingClass", componentClass) ) ;
                                                 
                                                // check To-Many-Link 'elements' between singleReference13 and componentClass
                                                JavaSDM.ensure ( singleReference13.hasInElements ("references", componentClass) ) ;
                                                 
                                                // bind callee: UMLMethod
                                                fujaba__IterNeighborCall16ElementsCallee = neighborCall16.iteratorOfElements ("callee") ;
                                                while ( fujaba__IterNeighborCall16ElementsCallee.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterNeighborCall16ElementsCallee.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                      callee = (UMLMethod) fujaba__TmpObject ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                       
                                                      // check To-One-Link 'parent' between callee and componentClass
                                                      JavaSDM.ensure ( (callee.getParent () != null) && callee.getParent ().equals (componentClass) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object componentClass is really bound
                                                            JavaSDM.ensure ( componentClass != null ) ;
                                                             
                                                            // check object decoratorClass is really bound
                                                            JavaSDM.ensure ( decoratorClass != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(componentClass.equals (decoratorClass)) ) ;
                                                             
                                                            // bind decorator: DecoratorAnnotation
                                                            fujaba__IterDecoratorClassAnnotationsDecorator = decoratorClass.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterDecoratorClassAnnotationsDecorator.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterDecoratorClassAnnotationsDecorator.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof DecoratorAnnotation ) ;
                                                                  decorator = (DecoratorAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between decorator and decoratorClass
                                                                  JavaSDM.ensure ( decorator.hasInElements ("decorator", decoratorClass) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between decorator and componentClass
                                                                  JavaSDM.ensure ( decorator.hasInElements ("component", componentClass) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object componentClass is really bound
                                                               JavaSDM.ensure ( componentClass != null ) ;
                                                                
                                                               // check object decoratorClass is really bound
                                                               JavaSDM.ensure ( decoratorClass != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(componentClass.equals (decoratorClass)) ) ;
                                                                
                                                               // check object caller is really bound
                                                               JavaSDM.ensure ( caller != null ) ;
                                                                
                                                               // check object callee is really bound
                                                               JavaSDM.ensure ( callee != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                
                                                               // create object
                                                               decorator = new DecoratorAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               decorator.setClassification (1);
                                                                
                                                               // create link
                                                               decorator.addToElements ("component", componentClass);
                                                                
                                                               // create link
                                                               decorator.addToElements ("decorator", decoratorClass);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("componentClass", componentClass);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("decoratorClass", decoratorClass);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("caller", caller);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("callee", callee);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object singleReference13 is really bound
                                                               JavaSDM.ensure ( singleReference13 != null ) ;
                                                                
                                                               // check object generalization14 is really bound
                                                               JavaSDM.ensure ( generalization14 != null ) ;
                                                                
                                                               // check object singleReference15 is really bound
                                                               JavaSDM.ensure ( singleReference15 != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(singleReference13.equals (singleReference15)) ) ;
                                                                
                                                               // check object neighborCall16 is really bound
                                                               JavaSDM.ensure ( neighborCall16 != null ) ;
                                                                
                                                               // check object decorator is really bound
                                                               JavaSDM.ensure ( decorator != null ) ;
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (singleReference13);
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (generalization14);
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (singleReference15);
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (neighborCall16);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (decorator) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object decorator is really bound
            JavaSDM.ensure ( decorator != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("decorator", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (decorator) ;
   }


   private GFRNAnnotation annotateUsingTrigger_GeneralizationRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      DecoratorAnnotation decorator = null ;
      Iterator fujaba__IterCalleeAnnotationsNeighborCall12 = null ;
      Iterator fujaba__IterComponentClassAnnotationsSingleReference11 = null ;
      Iterator fujaba__IterComponentClassAnnotationsSingleReference9 = null ;
      Iterator fujaba__IterComponentClassMethodsCallee = null ;
      Iterator fujaba__IterDecoratorClassAnnotationsDecorator = null ;
      Iterator fujaba__IterDecoratorClassMethodsCaller = null ;
      Iterator fujaba__IterGeneralization10ElementsComponentClass = null ;
      Iterator fujaba__IterGeneralization10ElementsDecoratorClass = null ;
      GeneralizationAnnotation generalization10 = null ;
      NeighborCallAnnotation neighborCall12 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      SingleReferenceAnnotation singleReference11 = null ;
      SingleReferenceAnnotation singleReference9 = null ;
      UMLClass componentClass = null ;
      UMLClass decoratorClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization10 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind componentClass: UMLClass
            fujaba__IterGeneralization10ElementsComponentClass = generalization10.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization10ElementsComponentClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization10ElementsComponentClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  componentClass = (UMLClass) fujaba__TmpObject ;
                   
                  // bind decoratorClass: UMLClass
                  fujaba__IterGeneralization10ElementsDecoratorClass = generalization10.iteratorOfElements ("subClass") ;
                  while ( fujaba__IterGeneralization10ElementsDecoratorClass.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterGeneralization10ElementsDecoratorClass.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        decoratorClass = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(componentClass.equals (decoratorClass)) ) ;
                         
                        // bind callee: UMLMethod
                        fujaba__IterComponentClassMethodsCallee = componentClass.iteratorOfMethods () ;
                        while ( fujaba__IterComponentClassMethodsCallee.hasNext () )
                        {
                           try
                           {
                              callee = (UMLMethod) fujaba__IterComponentClassMethodsCallee.next () ;
                               
                              // bind singleReference11: SingleReferenceAnnotation
                              fujaba__IterComponentClassAnnotationsSingleReference11 = componentClass.iteratorOfAnnotations () ;
                              while ( fujaba__IterComponentClassAnnotationsSingleReference11.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterComponentClassAnnotationsSingleReference11.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof SingleReferenceAnnotation ) ;
                                    singleReference11 = (SingleReferenceAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between singleReference11 and componentClass
                                    JavaSDM.ensure ( singleReference11.hasInElements ("referencingClass", componentClass) ) ;
                                     
                                    // check To-Many-Link 'elements' between singleReference11 and decoratorClass
                                    JavaSDM.ensure ( singleReference11.hasInElements ("references", decoratorClass) ) ;
                                     
                                    // bind singleReference9: SingleReferenceAnnotation
                                    fujaba__IterComponentClassAnnotationsSingleReference9 = componentClass.iteratorOfAnnotations () ;
                                    while ( fujaba__IterComponentClassAnnotationsSingleReference9.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterComponentClassAnnotationsSingleReference9.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof SingleReferenceAnnotation ) ;
                                          singleReference9 = (SingleReferenceAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between singleReference9 and componentClass
                                          JavaSDM.ensure ( singleReference9.hasInElements ("references", componentClass) ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(singleReference11.equals (singleReference9)) ) ;
                                           
                                          // check To-Many-Link 'elements' between singleReference9 and decoratorClass
                                          JavaSDM.ensure ( singleReference9.hasInElements ("referencingClass", decoratorClass) ) ;
                                           
                                          // bind caller: UMLMethod
                                          fujaba__IterDecoratorClassMethodsCaller = decoratorClass.iteratorOfMethods () ;
                                          while ( fujaba__IterDecoratorClassMethodsCaller.hasNext () )
                                          {
                                             try
                                             {
                                                caller = (UMLMethod) fujaba__IterDecoratorClassMethodsCaller.next () ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(callee.equals (caller)) ) ;
                                                 
                                                // bind neighborCall12: NeighborCallAnnotation
                                                fujaba__IterCalleeAnnotationsNeighborCall12 = callee.iteratorOfAnnotations () ;
                                                while ( fujaba__IterCalleeAnnotationsNeighborCall12.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterCalleeAnnotationsNeighborCall12.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                                      neighborCall12 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between neighborCall12 and callee
                                                      JavaSDM.ensure ( neighborCall12.hasInElements ("callee", callee) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between neighborCall12 and caller
                                                      JavaSDM.ensure ( neighborCall12.hasInElements ("caller", caller) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object componentClass is really bound
                                                            JavaSDM.ensure ( componentClass != null ) ;
                                                             
                                                            // check object decoratorClass is really bound
                                                            JavaSDM.ensure ( decoratorClass != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(componentClass.equals (decoratorClass)) ) ;
                                                             
                                                            // bind decorator: DecoratorAnnotation
                                                            fujaba__IterDecoratorClassAnnotationsDecorator = decoratorClass.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterDecoratorClassAnnotationsDecorator.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterDecoratorClassAnnotationsDecorator.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof DecoratorAnnotation ) ;
                                                                  decorator = (DecoratorAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between decorator and decoratorClass
                                                                  JavaSDM.ensure ( decorator.hasInElements ("decorator", decoratorClass) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between decorator and componentClass
                                                                  JavaSDM.ensure ( decorator.hasInElements ("component", componentClass) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object componentClass is really bound
                                                               JavaSDM.ensure ( componentClass != null ) ;
                                                                
                                                               // check object decoratorClass is really bound
                                                               JavaSDM.ensure ( decoratorClass != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(componentClass.equals (decoratorClass)) ) ;
                                                                
                                                               // check object caller is really bound
                                                               JavaSDM.ensure ( caller != null ) ;
                                                                
                                                               // check object callee is really bound
                                                               JavaSDM.ensure ( callee != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                
                                                               // create object
                                                               decorator = new DecoratorAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               decorator.setClassification (1);
                                                                
                                                               // create link
                                                               decorator.addToElements ("component", componentClass);
                                                                
                                                               // create link
                                                               decorator.addToElements ("decorator", decoratorClass);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("componentClass", componentClass);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("decoratorClass", decoratorClass);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("caller", caller);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("callee", callee);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object singleReference9 is really bound
                                                               JavaSDM.ensure ( singleReference9 != null ) ;
                                                                
                                                               // check object generalization10 is really bound
                                                               JavaSDM.ensure ( generalization10 != null ) ;
                                                                
                                                               // check object singleReference11 is really bound
                                                               JavaSDM.ensure ( singleReference11 != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(singleReference9.equals (singleReference11)) ) ;
                                                                
                                                               // check object neighborCall12 is really bound
                                                               JavaSDM.ensure ( neighborCall12 != null ) ;
                                                                
                                                               // check object decorator is really bound
                                                               JavaSDM.ensure ( decorator != null ) ;
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (singleReference9);
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (generalization10);
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (singleReference11);
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (neighborCall12);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (decorator) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object decorator is really bound
            JavaSDM.ensure ( decorator != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_Generalization", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (decorator) ;
   }


   private GFRNAnnotation annotateUsingTrigger_NeighborCallRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      DecoratorAnnotation decorator = null ;
      Iterator fujaba__IterDecoratorClassAnnotationsDecorator = null ;
      Iterator fujaba__IterDecoratorClassAnnotationsGeneralization22 = null ;
      Iterator fujaba__IterDecoratorClassAnnotationsSingleReference21 = null ;
      Iterator fujaba__IterDecoratorClassAnnotationsSingleReference23 = null ;
      Iterator fujaba__IterNeighborCall24ElementsCallee = null ;
      Iterator fujaba__IterNeighborCall24ElementsCaller = null ;
      GeneralizationAnnotation generalization22 = null ;
      NeighborCallAnnotation neighborCall24 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      SingleReferenceAnnotation singleReference21 = null ;
      SingleReferenceAnnotation singleReference23 = null ;
      UMLClass componentClass = null ;
      UMLClass decoratorClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall24 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterNeighborCall24ElementsCaller = neighborCall24.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall24ElementsCaller.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall24ElementsCaller.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  caller = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind decoratorClass: UMLClass
                  decoratorClass = caller.getParent () ;
                  JavaSDM.ensure ( decoratorClass != null ) ;
                   
                  // bind callee: UMLMethod
                  fujaba__IterNeighborCall24ElementsCallee = neighborCall24.iteratorOfElements ("callee") ;
                  while ( fujaba__IterNeighborCall24ElementsCallee.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterNeighborCall24ElementsCallee.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        callee = (UMLMethod) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                         
                        // bind componentClass: UMLClass
                        componentClass = callee.getParent () ;
                        JavaSDM.ensure ( componentClass != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(decoratorClass.equals (componentClass)) ) ;
                         
                        // bind generalization22: GeneralizationAnnotation
                        fujaba__IterDecoratorClassAnnotationsGeneralization22 = decoratorClass.iteratorOfAnnotations () ;
                        while ( fujaba__IterDecoratorClassAnnotationsGeneralization22.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterDecoratorClassAnnotationsGeneralization22.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                              generalization22 = (GeneralizationAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between generalization22 and decoratorClass
                              JavaSDM.ensure ( generalization22.hasInElements ("subClass", decoratorClass) ) ;
                               
                              // check To-Many-Link 'elements' between generalization22 and componentClass
                              JavaSDM.ensure ( generalization22.hasInElements ("superClass", componentClass) ) ;
                               
                              // bind singleReference23: SingleReferenceAnnotation
                              fujaba__IterDecoratorClassAnnotationsSingleReference23 = decoratorClass.iteratorOfAnnotations () ;
                              while ( fujaba__IterDecoratorClassAnnotationsSingleReference23.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterDecoratorClassAnnotationsSingleReference23.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof SingleReferenceAnnotation ) ;
                                    singleReference23 = (SingleReferenceAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between singleReference23 and decoratorClass
                                    JavaSDM.ensure ( singleReference23.hasInElements ("references", decoratorClass) ) ;
                                     
                                    // check To-Many-Link 'elements' between singleReference23 and componentClass
                                    JavaSDM.ensure ( singleReference23.hasInElements ("referencingClass", componentClass) ) ;
                                     
                                    // bind singleReference21: SingleReferenceAnnotation
                                    fujaba__IterDecoratorClassAnnotationsSingleReference21 = decoratorClass.iteratorOfAnnotations () ;
                                    while ( fujaba__IterDecoratorClassAnnotationsSingleReference21.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterDecoratorClassAnnotationsSingleReference21.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof SingleReferenceAnnotation ) ;
                                          singleReference21 = (SingleReferenceAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between singleReference21 and decoratorClass
                                          JavaSDM.ensure ( singleReference21.hasInElements ("referencingClass", decoratorClass) ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(singleReference23.equals (singleReference21)) ) ;
                                           
                                          // check To-Many-Link 'elements' between singleReference21 and componentClass
                                          JavaSDM.ensure ( singleReference21.hasInElements ("references", componentClass) ) ;
                                           
                                          {
                                             //  for each flow
                                             try
                                             {
                                                fujaba__Success = false ;
                                                 
                                                // check object componentClass is really bound
                                                JavaSDM.ensure ( componentClass != null ) ;
                                                 
                                                // check object decoratorClass is really bound
                                                JavaSDM.ensure ( decoratorClass != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(componentClass.equals (decoratorClass)) ) ;
                                                 
                                                // bind decorator: DecoratorAnnotation
                                                fujaba__IterDecoratorClassAnnotationsDecorator = decoratorClass.iteratorOfAnnotations () ;
                                                while ( !(fujaba__Success) && fujaba__IterDecoratorClassAnnotationsDecorator.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterDecoratorClassAnnotationsDecorator.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof DecoratorAnnotation ) ;
                                                      decorator = (DecoratorAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between decorator and decoratorClass
                                                      JavaSDM.ensure ( decorator.hasInElements ("decorator", decoratorClass) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between decorator and componentClass
                                                      JavaSDM.ensure ( decorator.hasInElements ("component", componentClass) ) ;
                                                       
                                                      fujaba__Success = true ;
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                                fujaba__Success = false ;
                                             }
                                              
                                             if ( !(fujaba__Success) )
                                             {
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object componentClass is really bound
                                                   JavaSDM.ensure ( componentClass != null ) ;
                                                    
                                                   // check object decoratorClass is really bound
                                                   JavaSDM.ensure ( decoratorClass != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(componentClass.equals (decoratorClass)) ) ;
                                                    
                                                   // check object caller is really bound
                                                   JavaSDM.ensure ( caller != null ) ;
                                                    
                                                   // check object callee is really bound
                                                   JavaSDM.ensure ( callee != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                    
                                                   // create object
                                                   decorator = new DecoratorAnnotation ( ) ;
                                                    
                                                   // assign statement
                                                   decorator.setClassification (1);
                                                    
                                                   // create link
                                                   decorator.addToElements ("component", componentClass);
                                                    
                                                   // create link
                                                   decorator.addToElements ("decorator", decoratorClass);
                                                    
                                                   // create link
                                                   decorator.addToBoundObjects ("componentClass", componentClass);
                                                    
                                                   // create link
                                                   decorator.addToBoundObjects ("decoratorClass", decoratorClass);
                                                    
                                                   // create link
                                                   decorator.addToBoundObjects ("caller", caller);
                                                    
                                                   // create link
                                                   decorator.addToBoundObjects ("callee", callee);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object singleReference21 is really bound
                                                   JavaSDM.ensure ( singleReference21 != null ) ;
                                                    
                                                   // check object generalization22 is really bound
                                                   JavaSDM.ensure ( generalization22 != null ) ;
                                                    
                                                   // check object singleReference23 is really bound
                                                   JavaSDM.ensure ( singleReference23 != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(singleReference21.equals (singleReference23)) ) ;
                                                    
                                                   // check object neighborCall24 is really bound
                                                   JavaSDM.ensure ( neighborCall24 != null ) ;
                                                    
                                                   // check object decorator is really bound
                                                   JavaSDM.ensure ( decorator != null ) ;
                                                    
                                                   // create link
                                                   decorator.addToAntecedentAnnos (singleReference21);
                                                    
                                                   // create link
                                                   decorator.addToAntecedentAnnos (generalization22);
                                                    
                                                   // create link
                                                   decorator.addToAntecedentAnnos (singleReference23);
                                                    
                                                   // create link
                                                   decorator.addToAntecedentAnnos (neighborCall24);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                return (decorator) ;
                                             }
                                          } //  end for each flow
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object decorator is really bound
            JavaSDM.ensure ( decorator != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_NeighborCall", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (decorator) ;
   }


   private GFRNAnnotation annotateUsingTrigger_SingleReferenceRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      DecoratorAnnotation decorator = null ;
      Iterator fujaba__IterCallerAnnotationsNeighborCall4 = null ;
      Iterator fujaba__IterComponentClassAnnotationsDecorator = null ;
      Iterator fujaba__IterComponentClassMethodsCallee = null ;
      Iterator fujaba__IterDecoratorClassAnnotationsGeneralization2 = null ;
      Iterator fujaba__IterDecoratorClassAnnotationsSingleReference3 = null ;
      Iterator fujaba__IterDecoratorClassMethodsCaller = null ;
      Iterator fujaba__IterSingleReference1ElementsComponentClass = null ;
      Iterator fujaba__IterSingleReference1ElementsDecoratorClass = null ;
      GeneralizationAnnotation generalization2 = null ;
      NeighborCallAnnotation neighborCall4 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      SingleReferenceAnnotation singleReference1 = null ;
      SingleReferenceAnnotation singleReference3 = null ;
      UMLClass componentClass = null ;
      UMLClass decoratorClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_SingleReference", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof SingleReferenceAnnotation ) ;
             
            // explicit type cast
            singleReference1 = (SingleReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind decoratorClass: UMLClass
            fujaba__IterSingleReference1ElementsDecoratorClass = singleReference1.iteratorOfElements ("referencingClass") ;
            while ( fujaba__IterSingleReference1ElementsDecoratorClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterSingleReference1ElementsDecoratorClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  decoratorClass = (UMLClass) fujaba__TmpObject ;
                   
                  // bind componentClass: UMLClass
                  fujaba__IterSingleReference1ElementsComponentClass = singleReference1.iteratorOfElements ("references") ;
                  while ( fujaba__IterSingleReference1ElementsComponentClass.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterSingleReference1ElementsComponentClass.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        componentClass = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(decoratorClass.equals (componentClass)) ) ;
                         
                        // bind caller: UMLMethod
                        fujaba__IterDecoratorClassMethodsCaller = decoratorClass.iteratorOfMethods () ;
                        while ( fujaba__IterDecoratorClassMethodsCaller.hasNext () )
                        {
                           try
                           {
                              caller = (UMLMethod) fujaba__IterDecoratorClassMethodsCaller.next () ;
                               
                              // bind generalization2: GeneralizationAnnotation
                              fujaba__IterDecoratorClassAnnotationsGeneralization2 = decoratorClass.iteratorOfAnnotations () ;
                              while ( fujaba__IterDecoratorClassAnnotationsGeneralization2.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterDecoratorClassAnnotationsGeneralization2.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                    generalization2 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between generalization2 and decoratorClass
                                    JavaSDM.ensure ( generalization2.hasInElements ("subClass", decoratorClass) ) ;
                                     
                                    // check To-Many-Link 'elements' between generalization2 and componentClass
                                    JavaSDM.ensure ( generalization2.hasInElements ("superClass", componentClass) ) ;
                                     
                                    // bind singleReference3: SingleReferenceAnnotation
                                    fujaba__IterDecoratorClassAnnotationsSingleReference3 = decoratorClass.iteratorOfAnnotations () ;
                                    while ( fujaba__IterDecoratorClassAnnotationsSingleReference3.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterDecoratorClassAnnotationsSingleReference3.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof SingleReferenceAnnotation ) ;
                                          singleReference3 = (SingleReferenceAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between singleReference3 and decoratorClass
                                          JavaSDM.ensure ( singleReference3.hasInElements ("references", decoratorClass) ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(singleReference1.equals (singleReference3)) ) ;
                                           
                                          // check To-Many-Link 'elements' between singleReference3 and componentClass
                                          JavaSDM.ensure ( singleReference3.hasInElements ("referencingClass", componentClass) ) ;
                                           
                                          // bind callee: UMLMethod
                                          fujaba__IterComponentClassMethodsCallee = componentClass.iteratorOfMethods () ;
                                          while ( fujaba__IterComponentClassMethodsCallee.hasNext () )
                                          {
                                             try
                                             {
                                                callee = (UMLMethod) fujaba__IterComponentClassMethodsCallee.next () ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                 
                                                // bind neighborCall4: NeighborCallAnnotation
                                                fujaba__IterCallerAnnotationsNeighborCall4 = caller.iteratorOfAnnotations () ;
                                                while ( fujaba__IterCallerAnnotationsNeighborCall4.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterCallerAnnotationsNeighborCall4.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                                      neighborCall4 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between neighborCall4 and caller
                                                      JavaSDM.ensure ( neighborCall4.hasInElements ("caller", caller) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between neighborCall4 and callee
                                                      JavaSDM.ensure ( neighborCall4.hasInElements ("callee", callee) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object componentClass is really bound
                                                            JavaSDM.ensure ( componentClass != null ) ;
                                                             
                                                            // check object decoratorClass is really bound
                                                            JavaSDM.ensure ( decoratorClass != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(componentClass.equals (decoratorClass)) ) ;
                                                             
                                                            // bind decorator: DecoratorAnnotation
                                                            fujaba__IterComponentClassAnnotationsDecorator = componentClass.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterComponentClassAnnotationsDecorator.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterComponentClassAnnotationsDecorator.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof DecoratorAnnotation ) ;
                                                                  decorator = (DecoratorAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between decorator and componentClass
                                                                  JavaSDM.ensure ( decorator.hasInElements ("component", componentClass) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between decorator and decoratorClass
                                                                  JavaSDM.ensure ( decorator.hasInElements ("decorator", decoratorClass) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object componentClass is really bound
                                                               JavaSDM.ensure ( componentClass != null ) ;
                                                                
                                                               // check object decoratorClass is really bound
                                                               JavaSDM.ensure ( decoratorClass != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(componentClass.equals (decoratorClass)) ) ;
                                                                
                                                               // check object caller is really bound
                                                               JavaSDM.ensure ( caller != null ) ;
                                                                
                                                               // check object callee is really bound
                                                               JavaSDM.ensure ( callee != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                
                                                               // create object
                                                               decorator = new DecoratorAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               decorator.setClassification (1);
                                                                
                                                               // create link
                                                               decorator.addToElements ("component", componentClass);
                                                                
                                                               // create link
                                                               decorator.addToElements ("decorator", decoratorClass);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("componentClass", componentClass);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("decoratorClass", decoratorClass);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("caller", caller);
                                                                
                                                               // create link
                                                               decorator.addToBoundObjects ("callee", callee);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object singleReference1 is really bound
                                                               JavaSDM.ensure ( singleReference1 != null ) ;
                                                                
                                                               // check object generalization2 is really bound
                                                               JavaSDM.ensure ( generalization2 != null ) ;
                                                                
                                                               // check object singleReference3 is really bound
                                                               JavaSDM.ensure ( singleReference3 != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(singleReference1.equals (singleReference3)) ) ;
                                                                
                                                               // check object neighborCall4 is really bound
                                                               JavaSDM.ensure ( neighborCall4 != null ) ;
                                                                
                                                               // check object decorator is really bound
                                                               JavaSDM.ensure ( decorator != null ) ;
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (singleReference1);
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (generalization2);
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (singleReference3);
                                                                
                                                               // create link
                                                               decorator.addToAntecedentAnnos (neighborCall4);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (decorator) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object decorator is really bound
            JavaSDM.ensure ( decorator != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_SingleReference", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (decorator) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("component", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("decorator", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof SingleReferenceAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_SingleReference", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof GeneralizationAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof SingleReferenceAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_SingleReference", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof NeighborCallAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterComponentClassMethodsCallee = null ;
      Iterator fujaba__IterDecoratorClassMethodsCaller = null ;
      Iterator fujaba__IterGeneralization22ElementsComponentClass = null ;
      Iterator fujaba__IterNeighborCall24ElementsCaller = null ;
      Iterator fujaba__IterSingleReference21ElementsComponentClass = null ;
      Iterator fujaba__IterSingleReference23ElementsDecoratorClass = null ;
      GeneralizationAnnotation generalization22 = null ;
      NeighborCallAnnotation neighborCall24 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      SingleReferenceAnnotation singleReference21 = null ;
      SingleReferenceAnnotation singleReference23 = null ;
      UMLClass componentClass = null ;
      UMLClass decoratorClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("SingleReference") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            componentClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (componentClass);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            decoratorClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (decoratorClass);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization22 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind componentClass: UMLClass
            fujaba__IterGeneralization22ElementsComponentClass = generalization22.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization22ElementsComponentClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization22ElementsComponentClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  componentClass = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (componentClass);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof SingleReferenceAnnotation ) ;
             
            // explicit type cast
            singleReference23 = (SingleReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind decoratorClass: UMLClass
            fujaba__IterSingleReference23ElementsDecoratorClass = singleReference23.iteratorOfElements ("references") ;
            while ( fujaba__IterSingleReference23ElementsDecoratorClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterSingleReference23ElementsDecoratorClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  decoratorClass = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (decoratorClass);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall24 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterNeighborCall24ElementsCaller = neighborCall24.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall24ElementsCaller.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall24ElementsCaller.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  caller = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind decoratorClass: UMLClass
                  decoratorClass = caller.getParent () ;
                  JavaSDM.ensure ( decoratorClass != null ) ;
                   
                  {
                     //  for each flow
                     set.add (decoratorClass);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("Generalization") || annotation.equals ("MultiLevelGeneralization") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            componentClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (componentClass);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            decoratorClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (decoratorClass);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof SingleReferenceAnnotation ) ;
             
            // explicit type cast
            singleReference21 = (SingleReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind componentClass: UMLClass
            fujaba__IterSingleReference21ElementsComponentClass = singleReference21.iteratorOfElements ("references") ;
            while ( fujaba__IterSingleReference21ElementsComponentClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterSingleReference21ElementsComponentClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  componentClass = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (componentClass);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof SingleReferenceAnnotation ) ;
             
            // explicit type cast
            singleReference23 = (SingleReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind decoratorClass: UMLClass
            fujaba__IterSingleReference23ElementsDecoratorClass = singleReference23.iteratorOfElements ("references") ;
            while ( fujaba__IterSingleReference23ElementsDecoratorClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterSingleReference23ElementsDecoratorClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  decoratorClass = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (decoratorClass);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall24 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterNeighborCall24ElementsCaller = neighborCall24.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall24ElementsCaller.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall24ElementsCaller.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  caller = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind decoratorClass: UMLClass
                  decoratorClass = caller.getParent () ;
                  JavaSDM.ensure ( decoratorClass != null ) ;
                   
                  {
                     //  for each flow
                     set.add (decoratorClass);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("SingleReference") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            componentClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (componentClass);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            decoratorClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (decoratorClass);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof SingleReferenceAnnotation ) ;
             
            // explicit type cast
            singleReference21 = (SingleReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind componentClass: UMLClass
            fujaba__IterSingleReference21ElementsComponentClass = singleReference21.iteratorOfElements ("references") ;
            while ( fujaba__IterSingleReference21ElementsComponentClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterSingleReference21ElementsComponentClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  componentClass = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (componentClass);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization22 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind componentClass: UMLClass
            fujaba__IterGeneralization22ElementsComponentClass = generalization22.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization22ElementsComponentClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization22ElementsComponentClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  componentClass = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (componentClass);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall24 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterNeighborCall24ElementsCaller = neighborCall24.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall24ElementsCaller.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall24ElementsCaller.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  caller = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind decoratorClass: UMLClass
                  decoratorClass = caller.getParent () ;
                  JavaSDM.ensure ( decoratorClass != null ) ;
                   
                  {
                     //  for each flow
                     set.add (decoratorClass);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("NeighborCall") || annotation.equals ("Delegation") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            componentClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind callee: UMLMethod
            fujaba__IterComponentClassMethodsCallee = componentClass.iteratorOfMethods () ;
            while ( fujaba__IterComponentClassMethodsCallee.hasNext () )
            {
               try
               {
                  callee = (UMLMethod) fujaba__IterComponentClassMethodsCallee.next () ;
                   
                  {
                     //  for each flow
                     set.add (callee);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            decoratorClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterDecoratorClassMethodsCaller = decoratorClass.iteratorOfMethods () ;
            while ( fujaba__IterDecoratorClassMethodsCaller.hasNext () )
            {
               try
               {
                  caller = (UMLMethod) fujaba__IterDecoratorClassMethodsCaller.next () ;
                   
                  {
                     //  for each flow
                     set.add (caller);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof SingleReferenceAnnotation ) ;
             
            // explicit type cast
            singleReference21 = (SingleReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind componentClass: UMLClass
            fujaba__IterSingleReference21ElementsComponentClass = singleReference21.iteratorOfElements ("references") ;
            while ( fujaba__IterSingleReference21ElementsComponentClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterSingleReference21ElementsComponentClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  componentClass = (UMLClass) fujaba__TmpObject ;
                   
                  // bind callee: UMLMethod
                  fujaba__IterComponentClassMethodsCallee = componentClass.iteratorOfMethods () ;
                  while ( fujaba__IterComponentClassMethodsCallee.hasNext () )
                  {
                     try
                     {
                        callee = (UMLMethod) fujaba__IterComponentClassMethodsCallee.next () ;
                         
                        {
                           //  for each flow
                           set.add (callee);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization22 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind componentClass: UMLClass
            fujaba__IterGeneralization22ElementsComponentClass = generalization22.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization22ElementsComponentClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization22ElementsComponentClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  componentClass = (UMLClass) fujaba__TmpObject ;
                   
                  // bind callee: UMLMethod
                  fujaba__IterComponentClassMethodsCallee = componentClass.iteratorOfMethods () ;
                  while ( fujaba__IterComponentClassMethodsCallee.hasNext () )
                  {
                     try
                     {
                        callee = (UMLMethod) fujaba__IterComponentClassMethodsCallee.next () ;
                         
                        {
                           //  for each flow
                           set.add (callee);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof SingleReferenceAnnotation ) ;
             
            // explicit type cast
            singleReference23 = (SingleReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind decoratorClass: UMLClass
            fujaba__IterSingleReference23ElementsDecoratorClass = singleReference23.iteratorOfElements ("references") ;
            while ( fujaba__IterSingleReference23ElementsDecoratorClass.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterSingleReference23ElementsDecoratorClass.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  decoratorClass = (UMLClass) fujaba__TmpObject ;
                   
                  // bind caller: UMLMethod
                  fujaba__IterDecoratorClassMethodsCaller = decoratorClass.iteratorOfMethods () ;
                  while ( fujaba__IterDecoratorClassMethodsCaller.hasNext () )
                  {
                     try
                     {
                        caller = (UMLMethod) fujaba__IterDecoratorClassMethodsCaller.next () ;
                         
                        {
                           //  for each flow
                           set.add (caller);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
