package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLMethod;

public class BridgeEngine
extends GFRNEngine
{
   private  BridgeEngine()
   {
   }

   private static BridgeEngine theBridgeEngine;

   public static BridgeEngine get()
   {
      if (theBridgeEngine == null)
      {
         theBridgeEngine = new BridgeEngine ();
      }
      return theBridgeEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation bridge = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         bridge = this.annotateUsingAbstractionRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( bridge != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (bridge) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            bridge = this.annotateUsingTrigger_ReferenceRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( bridge != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (bridge) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               bridge = this.annotateUsingImplementorRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( bridge != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (bridge) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  bridge = this.annotateUsingTrigger_NeighborCallRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               try
               {
                  fujaba__Success = false ;
                   
                  // constraint
                  JavaSDM.ensure ( bridge != null ) ;
                   
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( fujaba__Success )
               {
                  return (bridge) ;
               }
               else
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // collabStatBegin 1 is empty !
                     bridge = this.annotateUsingTrigger_GeneralizationRole(asgElement);
                      
                     // collabStatEnd
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  return (bridge) ;
               }
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingAbstractionRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BridgeAnnotation bridge = null ;
      Iterator fujaba__IterAbstractionAnnotationsBridge = null ;
      Iterator fujaba__IterAbstractionAnnotationsGeneralization1 = null ;
      Iterator fujaba__IterAbstractionAnnotationsGeneralization4 = null ;
      Iterator fujaba__IterAbstractionAnnotationsReference2 = null ;
      Iterator fujaba__IterAbstractionMethodsOperation = null ;
      Iterator fujaba__IterNeighborCall3ElementsOperationImpl = null ;
      Iterator fujaba__IterOperationAnnotationsNeighborCall3 = null ;
      Iterator fujaba__IterReference2ElementsImplementor = null ;
      GeneralizationAnnotation generalization1 = null ;
      GeneralizationAnnotation generalization4 = null ;
      NeighborCallAnnotation neighborCall3 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ReferenceAnnotation reference2 = null ;
      UMLClass abstraction = null ;
      UMLClass implementor = null ;
      UMLMethod operation = null ;
      UMLMethod operationImpl = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("abstraction", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstraction = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind operation: UMLMethod
            fujaba__IterAbstractionMethodsOperation = abstraction.iteratorOfMethods () ;
            while ( fujaba__IterAbstractionMethodsOperation.hasNext () )
            {
               try
               {
                  operation = (UMLMethod) fujaba__IterAbstractionMethodsOperation.next () ;
                   
                  // bind generalization4: GeneralizationAnnotation
                  fujaba__IterAbstractionAnnotationsGeneralization4 = abstraction.iteratorOfAnnotations () ;
                  while ( fujaba__IterAbstractionAnnotationsGeneralization4.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterAbstractionAnnotationsGeneralization4.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                        generalization4 = (GeneralizationAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between generalization4 and abstraction
                        JavaSDM.ensure ( generalization4.hasInElements ("superClass", abstraction) ) ;
                         
                        // bind reference2: ReferenceAnnotation
                        fujaba__IterAbstractionAnnotationsReference2 = abstraction.iteratorOfAnnotations () ;
                        while ( fujaba__IterAbstractionAnnotationsReference2.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterAbstractionAnnotationsReference2.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                              reference2 = (ReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between reference2 and abstraction
                              JavaSDM.ensure ( reference2.hasInElements ("referencingClass", abstraction) ) ;
                               
                              // bind neighborCall3: NeighborCallAnnotation
                              fujaba__IterOperationAnnotationsNeighborCall3 = operation.iteratorOfAnnotations () ;
                              while ( fujaba__IterOperationAnnotationsNeighborCall3.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterOperationAnnotationsNeighborCall3.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                    neighborCall3 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between neighborCall3 and operation
                                    JavaSDM.ensure ( neighborCall3.hasInElements ("caller", operation) ) ;
                                     
                                    // bind implementor: UMLClass
                                    fujaba__IterReference2ElementsImplementor = reference2.iteratorOfElements ("references") ;
                                    while ( fujaba__IterReference2ElementsImplementor.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterReference2ElementsImplementor.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                          implementor = (UMLClass) fujaba__TmpObject ;
                                           
                                          // attribute condition
                                          JavaSDM.ensure ( (implementor.isAbstract () == true) ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                           
                                          // check negative application condition
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // bind generalization1: GeneralizationAnnotation
                                             fujaba__IterAbstractionAnnotationsGeneralization1 = abstraction.iteratorOfAnnotations () ;
                                             while ( fujaba__IterAbstractionAnnotationsGeneralization1.hasNext () )
                                             {
                                                try
                                                {
                                                   fujaba__TmpObject = fujaba__IterAbstractionAnnotationsGeneralization1.next () ;
                                                   JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                                   generalization1 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                                    
                                                   // check Reverse-Qualified-Link 'elements' between generalization1 and abstraction
                                                   JavaSDM.ensure ( generalization1.hasInElements ("subClass", abstraction) ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(generalization4.equals (generalization1)) ) ;
                                                    
                                                   // check To-Many-Link 'elements' between generalization1 and implementor
                                                   JavaSDM.ensure ( generalization1.hasInElements ("superClass", implementor) ) ;
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                }
                                             }
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          fujaba__Success = !(fujaba__Success);
                                          JavaSDM.ensure ( fujaba__Success ) ;
                                          fujaba__Success = false;
                                          // end of negative application condition
                                           
                                          // bind operationImpl: UMLMethod
                                          fujaba__IterNeighborCall3ElementsOperationImpl = neighborCall3.iteratorOfElements ("callee") ;
                                          while ( fujaba__IterNeighborCall3ElementsOperationImpl.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterNeighborCall3ElementsOperationImpl.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                operationImpl = (UMLMethod) fujaba__TmpObject ;
                                                 
                                                // attribute condition
                                                JavaSDM.ensure ( (operationImpl.isAbstract () == true) ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(operation.equals (operationImpl)) ) ;
                                                 
                                                // check To-One-Link 'parent' between operationImpl and implementor
                                                JavaSDM.ensure ( (operationImpl.getParent () != null) && operationImpl.getParent ().equals (implementor) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object abstraction is really bound
                                                      JavaSDM.ensure ( abstraction != null ) ;
                                                       
                                                      // check object implementor is really bound
                                                      JavaSDM.ensure ( implementor != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                                       
                                                      // bind bridge: BridgeAnnotation
                                                      fujaba__IterAbstractionAnnotationsBridge = abstraction.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterAbstractionAnnotationsBridge.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterAbstractionAnnotationsBridge.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof BridgeAnnotation ) ;
                                                            bridge = (BridgeAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between bridge and abstraction
                                                            JavaSDM.ensure ( bridge.hasInElements ("abstraction", abstraction) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between bridge and implementor
                                                            JavaSDM.ensure ( bridge.hasInElements ("implementor", implementor) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object abstraction is really bound
                                                         JavaSDM.ensure ( abstraction != null ) ;
                                                          
                                                         // check object implementor is really bound
                                                         JavaSDM.ensure ( implementor != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                                          
                                                         // check object operationImpl is really bound
                                                         JavaSDM.ensure ( operationImpl != null ) ;
                                                          
                                                         // check object operation is really bound
                                                         JavaSDM.ensure ( operation != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                                                          
                                                         // create object
                                                         bridge = new BridgeAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         bridge.setClassification (1);
                                                          
                                                         // create link
                                                         bridge.addToElements ("abstraction", abstraction);
                                                          
                                                         // create link
                                                         bridge.addToElements ("implementor", implementor);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("abstraction", abstraction);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("implementor", implementor);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("operationImpl", operationImpl);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("operation", operation);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object reference2 is really bound
                                                         JavaSDM.ensure ( reference2 != null ) ;
                                                          
                                                         // check object neighborCall3 is really bound
                                                         JavaSDM.ensure ( neighborCall3 != null ) ;
                                                          
                                                         // check object generalization4 is really bound
                                                         JavaSDM.ensure ( generalization4 != null ) ;
                                                          
                                                         // check object bridge is really bound
                                                         JavaSDM.ensure ( bridge != null ) ;
                                                          
                                                         // create link
                                                         bridge.addToAntecedentAnnos (reference2);
                                                          
                                                         // create link
                                                         bridge.addToAntecedentAnnos (neighborCall3);
                                                          
                                                         // create link
                                                         bridge.addToAntecedentAnnos (generalization4);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (bridge) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object bridge is really bound
            JavaSDM.ensure ( bridge != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("abstraction", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (bridge) ;
   }


   private GFRNAnnotation annotateUsingImplementorRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BridgeAnnotation bridge = null ;
      Iterator fujaba__IterAbstractionAnnotationsGeneralization12 = null ;
      Iterator fujaba__IterImplementorAnnotationsBridge = null ;
      Iterator fujaba__IterImplementorAnnotationsGeneralization9 = null ;
      Iterator fujaba__IterImplementorAnnotationsReference10 = null ;
      Iterator fujaba__IterImplementorMethodsOperationImpl = null ;
      Iterator fujaba__IterNeighborCall11ElementsOperation = null ;
      Iterator fujaba__IterOperationImplAnnotationsNeighborCall11 = null ;
      Iterator fujaba__IterReference10ElementsAbstraction = null ;
      GeneralizationAnnotation generalization12 = null ;
      GeneralizationAnnotation generalization9 = null ;
      NeighborCallAnnotation neighborCall11 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ReferenceAnnotation reference10 = null ;
      UMLClass abstraction = null ;
      UMLClass implementor = null ;
      UMLMethod operation = null ;
      UMLMethod operationImpl = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("implementor", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            implementor = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // attribute condition
            JavaSDM.ensure ( (implementor.isAbstract () == true) ) ;
             
            // bind operationImpl: UMLMethod
            fujaba__IterImplementorMethodsOperationImpl = implementor.iteratorOfMethods () ;
            while ( fujaba__IterImplementorMethodsOperationImpl.hasNext () )
            {
               try
               {
                  operationImpl = (UMLMethod) fujaba__IterImplementorMethodsOperationImpl.next () ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (operationImpl.isAbstract () == true) ) ;
                   
                  // bind reference10: ReferenceAnnotation
                  fujaba__IterImplementorAnnotationsReference10 = implementor.iteratorOfAnnotations () ;
                  while ( fujaba__IterImplementorAnnotationsReference10.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterImplementorAnnotationsReference10.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                        reference10 = (ReferenceAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between reference10 and implementor
                        JavaSDM.ensure ( reference10.hasInElements ("references", implementor) ) ;
                         
                        // bind neighborCall11: NeighborCallAnnotation
                        fujaba__IterOperationImplAnnotationsNeighborCall11 = operationImpl.iteratorOfAnnotations () ;
                        while ( fujaba__IterOperationImplAnnotationsNeighborCall11.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterOperationImplAnnotationsNeighborCall11.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                              neighborCall11 = (NeighborCallAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between neighborCall11 and operationImpl
                              JavaSDM.ensure ( neighborCall11.hasInElements ("callee", operationImpl) ) ;
                               
                              // bind abstraction: UMLClass
                              fujaba__IterReference10ElementsAbstraction = reference10.iteratorOfElements ("referencingClass") ;
                              while ( fujaba__IterReference10ElementsAbstraction.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterReference10ElementsAbstraction.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                    abstraction = (UMLClass) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                     
                                    // check negative application condition
                                    try
                                    {
                                       fujaba__Success = false ;
                                        
                                       // bind generalization9: GeneralizationAnnotation
                                       fujaba__IterImplementorAnnotationsGeneralization9 = implementor.iteratorOfAnnotations () ;
                                       while ( fujaba__IterImplementorAnnotationsGeneralization9.hasNext () )
                                       {
                                          try
                                          {
                                             fujaba__TmpObject = fujaba__IterImplementorAnnotationsGeneralization9.next () ;
                                             JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                             generalization9 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                              
                                             // check Reverse-Qualified-Link 'elements' between generalization9 and implementor
                                             JavaSDM.ensure ( generalization9.hasInElements ("superClass", implementor) ) ;
                                              
                                             // check To-Many-Link 'elements' between generalization9 and abstraction
                                             JavaSDM.ensure ( generalization9.hasInElements ("subClass", abstraction) ) ;
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                          }
                                       }
                                    }
                                    catch ( JavaSDMException fujaba__InternalException )
                                    {
                                       fujaba__Success = false ;
                                    }
                                     
                                    fujaba__Success = !(fujaba__Success);
                                    JavaSDM.ensure ( fujaba__Success ) ;
                                    fujaba__Success = false;
                                    // end of negative application condition
                                     
                                    // bind operation: UMLMethod
                                    fujaba__IterNeighborCall11ElementsOperation = neighborCall11.iteratorOfElements ("caller") ;
                                    while ( fujaba__IterNeighborCall11ElementsOperation.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterNeighborCall11ElementsOperation.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                          operation = (UMLMethod) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                                           
                                          // check To-One-Link 'parent' between operation and abstraction
                                          JavaSDM.ensure ( (operation.getParent () != null) && operation.getParent ().equals (abstraction) ) ;
                                           
                                          // bind generalization12: GeneralizationAnnotation
                                          fujaba__IterAbstractionAnnotationsGeneralization12 = abstraction.iteratorOfAnnotations () ;
                                          while ( fujaba__IterAbstractionAnnotationsGeneralization12.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterAbstractionAnnotationsGeneralization12.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                                generalization12 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between generalization12 and abstraction
                                                JavaSDM.ensure ( generalization12.hasInElements ("superClass", abstraction) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object abstraction is really bound
                                                      JavaSDM.ensure ( abstraction != null ) ;
                                                       
                                                      // check object implementor is really bound
                                                      JavaSDM.ensure ( implementor != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                                       
                                                      // bind bridge: BridgeAnnotation
                                                      fujaba__IterImplementorAnnotationsBridge = implementor.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterImplementorAnnotationsBridge.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterImplementorAnnotationsBridge.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof BridgeAnnotation ) ;
                                                            bridge = (BridgeAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between bridge and implementor
                                                            JavaSDM.ensure ( bridge.hasInElements ("implementor", implementor) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between bridge and abstraction
                                                            JavaSDM.ensure ( bridge.hasInElements ("abstraction", abstraction) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object abstraction is really bound
                                                         JavaSDM.ensure ( abstraction != null ) ;
                                                          
                                                         // check object implementor is really bound
                                                         JavaSDM.ensure ( implementor != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                                          
                                                         // check object operationImpl is really bound
                                                         JavaSDM.ensure ( operationImpl != null ) ;
                                                          
                                                         // check object operation is really bound
                                                         JavaSDM.ensure ( operation != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                                                          
                                                         // create object
                                                         bridge = new BridgeAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         bridge.setClassification (1);
                                                          
                                                         // create link
                                                         bridge.addToElements ("abstraction", abstraction);
                                                          
                                                         // create link
                                                         bridge.addToElements ("implementor", implementor);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("abstraction", abstraction);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("implementor", implementor);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("operationImpl", operationImpl);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("operation", operation);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object reference10 is really bound
                                                         JavaSDM.ensure ( reference10 != null ) ;
                                                          
                                                         // check object neighborCall11 is really bound
                                                         JavaSDM.ensure ( neighborCall11 != null ) ;
                                                          
                                                         // check object generalization12 is really bound
                                                         JavaSDM.ensure ( generalization12 != null ) ;
                                                          
                                                         // check object bridge is really bound
                                                         JavaSDM.ensure ( bridge != null ) ;
                                                          
                                                         // create link
                                                         bridge.addToAntecedentAnnos (reference10);
                                                          
                                                         // create link
                                                         bridge.addToAntecedentAnnos (neighborCall11);
                                                          
                                                         // create link
                                                         bridge.addToAntecedentAnnos (generalization12);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (bridge) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object bridge is really bound
            JavaSDM.ensure ( bridge != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("implementor", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (bridge) ;
   }


   private GFRNAnnotation annotateUsingTrigger_GeneralizationRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BridgeAnnotation bridge = null ;
      Iterator fujaba__IterAbstractionAnnotationsBridge = null ;
      Iterator fujaba__IterAbstractionAnnotationsGeneralization17 = null ;
      Iterator fujaba__IterAbstractionAnnotationsReference18 = null ;
      Iterator fujaba__IterAbstractionMethodsOperation = null ;
      Iterator fujaba__IterGeneralization20ElementsAbstraction = null ;
      Iterator fujaba__IterNeighborCall19ElementsOperationImpl = null ;
      Iterator fujaba__IterOperationAnnotationsNeighborCall19 = null ;
      Iterator fujaba__IterReference18ElementsImplementor = null ;
      GeneralizationAnnotation generalization17 = null ;
      GeneralizationAnnotation generalization20 = null ;
      NeighborCallAnnotation neighborCall19 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ReferenceAnnotation reference18 = null ;
      UMLClass abstraction = null ;
      UMLClass implementor = null ;
      UMLMethod operation = null ;
      UMLMethod operationImpl = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization20 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind abstraction: UMLClass
            fujaba__IterGeneralization20ElementsAbstraction = generalization20.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization20ElementsAbstraction.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization20ElementsAbstraction.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  abstraction = (UMLClass) fujaba__TmpObject ;
                   
                  // bind operation: UMLMethod
                  fujaba__IterAbstractionMethodsOperation = abstraction.iteratorOfMethods () ;
                  while ( fujaba__IterAbstractionMethodsOperation.hasNext () )
                  {
                     try
                     {
                        operation = (UMLMethod) fujaba__IterAbstractionMethodsOperation.next () ;
                         
                        // bind reference18: ReferenceAnnotation
                        fujaba__IterAbstractionAnnotationsReference18 = abstraction.iteratorOfAnnotations () ;
                        while ( fujaba__IterAbstractionAnnotationsReference18.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterAbstractionAnnotationsReference18.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                              reference18 = (ReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between reference18 and abstraction
                              JavaSDM.ensure ( reference18.hasInElements ("referencingClass", abstraction) ) ;
                               
                              // bind neighborCall19: NeighborCallAnnotation
                              fujaba__IterOperationAnnotationsNeighborCall19 = operation.iteratorOfAnnotations () ;
                              while ( fujaba__IterOperationAnnotationsNeighborCall19.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterOperationAnnotationsNeighborCall19.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                    neighborCall19 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between neighborCall19 and operation
                                    JavaSDM.ensure ( neighborCall19.hasInElements ("caller", operation) ) ;
                                     
                                    // bind implementor: UMLClass
                                    fujaba__IterReference18ElementsImplementor = reference18.iteratorOfElements ("references") ;
                                    while ( fujaba__IterReference18ElementsImplementor.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterReference18ElementsImplementor.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                          implementor = (UMLClass) fujaba__TmpObject ;
                                           
                                          // attribute condition
                                          JavaSDM.ensure ( (implementor.isAbstract () == true) ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                           
                                          // check negative application condition
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // bind generalization17: GeneralizationAnnotation
                                             fujaba__IterAbstractionAnnotationsGeneralization17 = abstraction.iteratorOfAnnotations () ;
                                             while ( fujaba__IterAbstractionAnnotationsGeneralization17.hasNext () )
                                             {
                                                try
                                                {
                                                   fujaba__TmpObject = fujaba__IterAbstractionAnnotationsGeneralization17.next () ;
                                                   JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                                   generalization17 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                                    
                                                   // check Reverse-Qualified-Link 'elements' between generalization17 and abstraction
                                                   JavaSDM.ensure ( generalization17.hasInElements ("subClass", abstraction) ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(generalization20.equals (generalization17)) ) ;
                                                    
                                                   // check To-Many-Link 'elements' between generalization17 and implementor
                                                   JavaSDM.ensure ( generalization17.hasInElements ("superClass", implementor) ) ;
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                }
                                             }
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          fujaba__Success = !(fujaba__Success);
                                          JavaSDM.ensure ( fujaba__Success ) ;
                                          fujaba__Success = false;
                                          // end of negative application condition
                                           
                                          // bind operationImpl: UMLMethod
                                          fujaba__IterNeighborCall19ElementsOperationImpl = neighborCall19.iteratorOfElements ("callee") ;
                                          while ( fujaba__IterNeighborCall19ElementsOperationImpl.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterNeighborCall19ElementsOperationImpl.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                operationImpl = (UMLMethod) fujaba__TmpObject ;
                                                 
                                                // attribute condition
                                                JavaSDM.ensure ( (operationImpl.isAbstract () == true) ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(operation.equals (operationImpl)) ) ;
                                                 
                                                // check To-One-Link 'parent' between operationImpl and implementor
                                                JavaSDM.ensure ( (operationImpl.getParent () != null) && operationImpl.getParent ().equals (implementor) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object abstraction is really bound
                                                      JavaSDM.ensure ( abstraction != null ) ;
                                                       
                                                      // check object implementor is really bound
                                                      JavaSDM.ensure ( implementor != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                                       
                                                      // bind bridge: BridgeAnnotation
                                                      fujaba__IterAbstractionAnnotationsBridge = abstraction.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterAbstractionAnnotationsBridge.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterAbstractionAnnotationsBridge.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof BridgeAnnotation ) ;
                                                            bridge = (BridgeAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between bridge and abstraction
                                                            JavaSDM.ensure ( bridge.hasInElements ("abstraction", abstraction) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between bridge and implementor
                                                            JavaSDM.ensure ( bridge.hasInElements ("implementor", implementor) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object abstraction is really bound
                                                         JavaSDM.ensure ( abstraction != null ) ;
                                                          
                                                         // check object implementor is really bound
                                                         JavaSDM.ensure ( implementor != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                                          
                                                         // check object operationImpl is really bound
                                                         JavaSDM.ensure ( operationImpl != null ) ;
                                                          
                                                         // check object operation is really bound
                                                         JavaSDM.ensure ( operation != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                                                          
                                                         // create object
                                                         bridge = new BridgeAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         bridge.setClassification (1);
                                                          
                                                         // create link
                                                         bridge.addToElements ("abstraction", abstraction);
                                                          
                                                         // create link
                                                         bridge.addToElements ("implementor", implementor);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("abstraction", abstraction);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("implementor", implementor);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("operationImpl", operationImpl);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("operation", operation);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object reference18 is really bound
                                                         JavaSDM.ensure ( reference18 != null ) ;
                                                          
                                                         // check object neighborCall19 is really bound
                                                         JavaSDM.ensure ( neighborCall19 != null ) ;
                                                          
                                                         // check object generalization20 is really bound
                                                         JavaSDM.ensure ( generalization20 != null ) ;
                                                          
                                                         // check object bridge is really bound
                                                         JavaSDM.ensure ( bridge != null ) ;
                                                          
                                                         // create link
                                                         bridge.addToAntecedentAnnos (reference18);
                                                          
                                                         // create link
                                                         bridge.addToAntecedentAnnos (neighborCall19);
                                                          
                                                         // create link
                                                         bridge.addToAntecedentAnnos (generalization20);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (bridge) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object bridge is really bound
            JavaSDM.ensure ( bridge != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_Generalization", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (bridge) ;
   }


   private GFRNAnnotation annotateUsingTrigger_NeighborCallRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BridgeAnnotation bridge = null ;
      Iterator fujaba__IterAbstractionAnnotationsBridge = null ;
      Iterator fujaba__IterAbstractionAnnotationsGeneralization16 = null ;
      Iterator fujaba__IterImplementorAnnotationsGeneralization13 = null ;
      Iterator fujaba__IterImplementorAnnotationsReference14 = null ;
      Iterator fujaba__IterNeighborCall15ElementsOperation = null ;
      Iterator fujaba__IterNeighborCall15ElementsOperationImpl = null ;
      GeneralizationAnnotation generalization13 = null ;
      GeneralizationAnnotation generalization16 = null ;
      NeighborCallAnnotation neighborCall15 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ReferenceAnnotation reference14 = null ;
      UMLClass abstraction = null ;
      UMLClass implementor = null ;
      UMLMethod operation = null ;
      UMLMethod operationImpl = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall15 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind operationImpl: UMLMethod
            fujaba__IterNeighborCall15ElementsOperationImpl = neighborCall15.iteratorOfElements ("callee") ;
            while ( fujaba__IterNeighborCall15ElementsOperationImpl.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall15ElementsOperationImpl.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  operationImpl = (UMLMethod) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (operationImpl.isAbstract () == true) ) ;
                   
                  // bind implementor: UMLClass
                  implementor = operationImpl.getParent () ;
                  JavaSDM.ensure ( implementor != null ) ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (implementor.isAbstract () == true) ) ;
                   
                  // bind operation: UMLMethod
                  fujaba__IterNeighborCall15ElementsOperation = neighborCall15.iteratorOfElements ("caller") ;
                  while ( fujaba__IterNeighborCall15ElementsOperation.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterNeighborCall15ElementsOperation.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        operation = (UMLMethod) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                         
                        // bind abstraction: UMLClass
                        abstraction = operation.getParent () ;
                        JavaSDM.ensure ( abstraction != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                         
                        // bind reference14: ReferenceAnnotation
                        fujaba__IterImplementorAnnotationsReference14 = implementor.iteratorOfAnnotations () ;
                        while ( fujaba__IterImplementorAnnotationsReference14.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterImplementorAnnotationsReference14.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                              reference14 = (ReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between reference14 and implementor
                              JavaSDM.ensure ( reference14.hasInElements ("references", implementor) ) ;
                               
                              // check To-Many-Link 'elements' between reference14 and abstraction
                              JavaSDM.ensure ( reference14.hasInElements ("referencingClass", abstraction) ) ;
                               
                              // check negative application condition
                              try
                              {
                                 fujaba__Success = false ;
                                  
                                 // bind generalization13: GeneralizationAnnotation
                                 fujaba__IterImplementorAnnotationsGeneralization13 = implementor.iteratorOfAnnotations () ;
                                 while ( fujaba__IterImplementorAnnotationsGeneralization13.hasNext () )
                                 {
                                    try
                                    {
                                       fujaba__TmpObject = fujaba__IterImplementorAnnotationsGeneralization13.next () ;
                                       JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                       generalization13 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                        
                                       // check Reverse-Qualified-Link 'elements' between generalization13 and implementor
                                       JavaSDM.ensure ( generalization13.hasInElements ("superClass", implementor) ) ;
                                        
                                       // check To-Many-Link 'elements' between generalization13 and abstraction
                                       JavaSDM.ensure ( generalization13.hasInElements ("subClass", abstraction) ) ;
                                        
                                       fujaba__Success = true ;
                                    }
                                    catch ( JavaSDMException fujaba__InternalException )
                                    {
                                    }
                                 }
                              }
                              catch ( JavaSDMException fujaba__InternalException )
                              {
                                 fujaba__Success = false ;
                              }
                               
                              fujaba__Success = !(fujaba__Success);
                              JavaSDM.ensure ( fujaba__Success ) ;
                              fujaba__Success = false;
                              // end of negative application condition
                               
                              // bind generalization16: GeneralizationAnnotation
                              fujaba__IterAbstractionAnnotationsGeneralization16 = abstraction.iteratorOfAnnotations () ;
                              while ( fujaba__IterAbstractionAnnotationsGeneralization16.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterAbstractionAnnotationsGeneralization16.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                    generalization16 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between generalization16 and abstraction
                                    JavaSDM.ensure ( generalization16.hasInElements ("superClass", abstraction) ) ;
                                     
                                    {
                                       //  for each flow
                                       try
                                       {
                                          fujaba__Success = false ;
                                           
                                          // check object abstraction is really bound
                                          JavaSDM.ensure ( abstraction != null ) ;
                                           
                                          // check object implementor is really bound
                                          JavaSDM.ensure ( implementor != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                           
                                          // bind bridge: BridgeAnnotation
                                          fujaba__IterAbstractionAnnotationsBridge = abstraction.iteratorOfAnnotations () ;
                                          while ( !(fujaba__Success) && fujaba__IterAbstractionAnnotationsBridge.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterAbstractionAnnotationsBridge.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof BridgeAnnotation ) ;
                                                bridge = (BridgeAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between bridge and abstraction
                                                JavaSDM.ensure ( bridge.hasInElements ("abstraction", abstraction) ) ;
                                                 
                                                // check To-Many-Link 'elements' between bridge and implementor
                                                JavaSDM.ensure ( bridge.hasInElements ("implementor", implementor) ) ;
                                                 
                                                fujaba__Success = true ;
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                          fujaba__Success = false ;
                                       }
                                        
                                       if ( !(fujaba__Success) )
                                       {
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object abstraction is really bound
                                             JavaSDM.ensure ( abstraction != null ) ;
                                              
                                             // check object implementor is really bound
                                             JavaSDM.ensure ( implementor != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                              
                                             // check object operationImpl is really bound
                                             JavaSDM.ensure ( operationImpl != null ) ;
                                              
                                             // check object operation is really bound
                                             JavaSDM.ensure ( operation != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                                              
                                             // create object
                                             bridge = new BridgeAnnotation ( ) ;
                                              
                                             // assign statement
                                             bridge.setClassification (1);
                                              
                                             // create link
                                             bridge.addToElements ("abstraction", abstraction);
                                              
                                             // create link
                                             bridge.addToElements ("implementor", implementor);
                                              
                                             // create link
                                             bridge.addToBoundObjects ("abstraction", abstraction);
                                              
                                             // create link
                                             bridge.addToBoundObjects ("implementor", implementor);
                                              
                                             // create link
                                             bridge.addToBoundObjects ("operationImpl", operationImpl);
                                              
                                             // create link
                                             bridge.addToBoundObjects ("operation", operation);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object reference14 is really bound
                                             JavaSDM.ensure ( reference14 != null ) ;
                                              
                                             // check object neighborCall15 is really bound
                                             JavaSDM.ensure ( neighborCall15 != null ) ;
                                              
                                             // check object generalization16 is really bound
                                             JavaSDM.ensure ( generalization16 != null ) ;
                                              
                                             // check object bridge is really bound
                                             JavaSDM.ensure ( bridge != null ) ;
                                              
                                             // create link
                                             bridge.addToAntecedentAnnos (reference14);
                                              
                                             // create link
                                             bridge.addToAntecedentAnnos (neighborCall15);
                                              
                                             // create link
                                             bridge.addToAntecedentAnnos (generalization16);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          return (bridge) ;
                                       }
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object bridge is really bound
            JavaSDM.ensure ( bridge != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_NeighborCall", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (bridge) ;
   }


   private GFRNAnnotation annotateUsingTrigger_ReferenceRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BridgeAnnotation bridge = null ;
      Iterator fujaba__IterAbstractionAnnotationsGeneralization8 = null ;
      Iterator fujaba__IterAbstractionMethodsOperation = null ;
      Iterator fujaba__IterImplementorAnnotationsBridge = null ;
      Iterator fujaba__IterImplementorAnnotationsGeneralization5 = null ;
      Iterator fujaba__IterImplementorMethodsOperationImpl = null ;
      Iterator fujaba__IterOperationImplAnnotationsNeighborCall7 = null ;
      Iterator fujaba__IterReference6ElementsAbstraction = null ;
      Iterator fujaba__IterReference6ElementsImplementor = null ;
      GeneralizationAnnotation generalization5 = null ;
      GeneralizationAnnotation generalization8 = null ;
      NeighborCallAnnotation neighborCall7 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ReferenceAnnotation reference6 = null ;
      UMLClass abstraction = null ;
      UMLClass implementor = null ;
      UMLMethod operation = null ;
      UMLMethod operationImpl = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Reference", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference6 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind implementor: UMLClass
            fujaba__IterReference6ElementsImplementor = reference6.iteratorOfElements ("references") ;
            while ( fujaba__IterReference6ElementsImplementor.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference6ElementsImplementor.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  implementor = (UMLClass) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (implementor.isAbstract () == true) ) ;
                   
                  // bind abstraction: UMLClass
                  fujaba__IterReference6ElementsAbstraction = reference6.iteratorOfElements ("referencingClass") ;
                  while ( fujaba__IterReference6ElementsAbstraction.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterReference6ElementsAbstraction.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        abstraction = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                         
                        // bind operationImpl: UMLMethod
                        fujaba__IterImplementorMethodsOperationImpl = implementor.iteratorOfMethods () ;
                        while ( fujaba__IterImplementorMethodsOperationImpl.hasNext () )
                        {
                           try
                           {
                              operationImpl = (UMLMethod) fujaba__IterImplementorMethodsOperationImpl.next () ;
                               
                              // attribute condition
                              JavaSDM.ensure ( (operationImpl.isAbstract () == true) ) ;
                               
                              // check negative application condition
                              try
                              {
                                 fujaba__Success = false ;
                                  
                                 // bind generalization5: GeneralizationAnnotation
                                 fujaba__IterImplementorAnnotationsGeneralization5 = implementor.iteratorOfAnnotations () ;
                                 while ( fujaba__IterImplementorAnnotationsGeneralization5.hasNext () )
                                 {
                                    try
                                    {
                                       fujaba__TmpObject = fujaba__IterImplementorAnnotationsGeneralization5.next () ;
                                       JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                       generalization5 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                        
                                       // check Reverse-Qualified-Link 'elements' between generalization5 and implementor
                                       JavaSDM.ensure ( generalization5.hasInElements ("superClass", implementor) ) ;
                                        
                                       // check To-Many-Link 'elements' between generalization5 and abstraction
                                       JavaSDM.ensure ( generalization5.hasInElements ("subClass", abstraction) ) ;
                                        
                                       fujaba__Success = true ;
                                    }
                                    catch ( JavaSDMException fujaba__InternalException )
                                    {
                                    }
                                 }
                              }
                              catch ( JavaSDMException fujaba__InternalException )
                              {
                                 fujaba__Success = false ;
                              }
                               
                              fujaba__Success = !(fujaba__Success);
                              JavaSDM.ensure ( fujaba__Success ) ;
                              fujaba__Success = false;
                              // end of negative application condition
                               
                              // bind operation: UMLMethod
                              fujaba__IterAbstractionMethodsOperation = abstraction.iteratorOfMethods () ;
                              while ( fujaba__IterAbstractionMethodsOperation.hasNext () )
                              {
                                 try
                                 {
                                    operation = (UMLMethod) fujaba__IterAbstractionMethodsOperation.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                                     
                                    // bind generalization8: GeneralizationAnnotation
                                    fujaba__IterAbstractionAnnotationsGeneralization8 = abstraction.iteratorOfAnnotations () ;
                                    while ( fujaba__IterAbstractionAnnotationsGeneralization8.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterAbstractionAnnotationsGeneralization8.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                          generalization8 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between generalization8 and abstraction
                                          JavaSDM.ensure ( generalization8.hasInElements ("superClass", abstraction) ) ;
                                           
                                          // bind neighborCall7: NeighborCallAnnotation
                                          fujaba__IterOperationImplAnnotationsNeighborCall7 = operationImpl.iteratorOfAnnotations () ;
                                          while ( fujaba__IterOperationImplAnnotationsNeighborCall7.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterOperationImplAnnotationsNeighborCall7.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                                neighborCall7 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between neighborCall7 and operationImpl
                                                JavaSDM.ensure ( neighborCall7.hasInElements ("callee", operationImpl) ) ;
                                                 
                                                // check To-Many-Link 'elements' between neighborCall7 and operation
                                                JavaSDM.ensure ( neighborCall7.hasInElements ("caller", operation) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object abstraction is really bound
                                                      JavaSDM.ensure ( abstraction != null ) ;
                                                       
                                                      // check object implementor is really bound
                                                      JavaSDM.ensure ( implementor != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                                       
                                                      // bind bridge: BridgeAnnotation
                                                      fujaba__IterImplementorAnnotationsBridge = implementor.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterImplementorAnnotationsBridge.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterImplementorAnnotationsBridge.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof BridgeAnnotation ) ;
                                                            bridge = (BridgeAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between bridge and implementor
                                                            JavaSDM.ensure ( bridge.hasInElements ("implementor", implementor) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between bridge and abstraction
                                                            JavaSDM.ensure ( bridge.hasInElements ("abstraction", abstraction) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object abstraction is really bound
                                                         JavaSDM.ensure ( abstraction != null ) ;
                                                          
                                                         // check object implementor is really bound
                                                         JavaSDM.ensure ( implementor != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                                          
                                                         // check object operationImpl is really bound
                                                         JavaSDM.ensure ( operationImpl != null ) ;
                                                          
                                                         // check object operation is really bound
                                                         JavaSDM.ensure ( operation != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                                                          
                                                         // create object
                                                         bridge = new BridgeAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         bridge.setClassification (1);
                                                          
                                                         // create link
                                                         bridge.addToElements ("abstraction", abstraction);
                                                          
                                                         // create link
                                                         bridge.addToElements ("implementor", implementor);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("abstraction", abstraction);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("implementor", implementor);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("operationImpl", operationImpl);
                                                          
                                                         // create link
                                                         bridge.addToBoundObjects ("operation", operation);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object reference6 is really bound
                                                         JavaSDM.ensure ( reference6 != null ) ;
                                                          
                                                         // check object neighborCall7 is really bound
                                                         JavaSDM.ensure ( neighborCall7 != null ) ;
                                                          
                                                         // check object generalization8 is really bound
                                                         JavaSDM.ensure ( generalization8 != null ) ;
                                                          
                                                         // check object bridge is really bound
                                                         JavaSDM.ensure ( bridge != null ) ;
                                                          
                                                         // create link
                                                         bridge.addToAntecedentAnnos (reference6);
                                                          
                                                         // create link
                                                         bridge.addToAntecedentAnnos (neighborCall7);
                                                          
                                                         // create link
                                                         bridge.addToAntecedentAnnos (generalization8);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (bridge) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object bridge is really bound
            JavaSDM.ensure ( bridge != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_Reference", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (bridge) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("abstraction", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("implementor", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof GeneralizationAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof ReferenceAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Reference", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof NeighborCallAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof GeneralizationAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAbstractionMethodsOperation = null ;
      Iterator fujaba__IterGeneralization20ElementsAbstraction = null ;
      Iterator fujaba__IterImplementorAnnotationsReference23 = null ;
      Iterator fujaba__IterImplementorMethodsOperationImpl = null ;
      Iterator fujaba__IterNeighborCall19ElementsOperationImpl = null ;
      Iterator fujaba__IterNeighborCall21ElementsOperation = null ;
      Iterator fujaba__IterNeighborCall22ElementsOperation = null ;
      Iterator fujaba__IterNeighborCall22ElementsOperationImpl = null ;
      Iterator fujaba__IterOperationImplAnnotationsNeighborCall21 = null ;
      Iterator fujaba__IterOperationImplAnnotationsNeighborCall22 = null ;
      Iterator fujaba__IterReference18ElementsImplementor = null ;
      Iterator fujaba__IterReference23ElementsAbstraction = null ;
      GeneralizationAnnotation generalization20 = null ;
      NeighborCallAnnotation neighborCall19 = null ;
      NeighborCallAnnotation neighborCall21 = null ;
      NeighborCallAnnotation neighborCall22 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ReferenceAnnotation reference18 = null ;
      ReferenceAnnotation reference23 = null ;
      UMLClass abstraction = null ;
      UMLClass implementor = null ;
      UMLMethod operation = null ;
      UMLMethod operationImpl = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("Generalization") || annotation.equals ("MultiLevelGeneralization") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstraction = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (abstraction);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            implementor = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (implementor);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference18 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind implementor: UMLClass
            fujaba__IterReference18ElementsImplementor = reference18.iteratorOfElements ("references") ;
            while ( fujaba__IterReference18ElementsImplementor.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference18ElementsImplementor.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  implementor = (UMLClass) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (implementor.isAbstract () == true) ) ;
                   
                  {
                     //  for each flow
                     set.add (implementor);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall19 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind operationImpl: UMLMethod
            fujaba__IterNeighborCall19ElementsOperationImpl = neighborCall19.iteratorOfElements ("callee") ;
            while ( fujaba__IterNeighborCall19ElementsOperationImpl.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall19ElementsOperationImpl.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  operationImpl = (UMLMethod) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (operationImpl.isAbstract () == true) ) ;
                   
                  // bind implementor: UMLClass
                  implementor = operationImpl.getParent () ;
                  JavaSDM.ensure ( implementor != null ) ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (implementor.isAbstract () == true) ) ;
                   
                  {
                     //  for each flow
                     set.add (implementor);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization20 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind abstraction: UMLClass
            fujaba__IterGeneralization20ElementsAbstraction = generalization20.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization20ElementsAbstraction.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization20ElementsAbstraction.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  abstraction = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (abstraction);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("Reference") || annotation.equals ("MultiReference") || annotation.equals ("ArrayReference") || annotation.equals ("SingleReference") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstraction = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (abstraction);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            implementor = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (implementor);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall19 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind operationImpl: UMLMethod
            fujaba__IterNeighborCall19ElementsOperationImpl = neighborCall19.iteratorOfElements ("callee") ;
            while ( fujaba__IterNeighborCall19ElementsOperationImpl.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall19ElementsOperationImpl.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  operationImpl = (UMLMethod) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (operationImpl.isAbstract () == true) ) ;
                   
                  // bind implementor: UMLClass
                  implementor = operationImpl.getParent () ;
                  JavaSDM.ensure ( implementor != null ) ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (implementor.isAbstract () == true) ) ;
                   
                  {
                     //  for each flow
                     set.add (implementor);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization20 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind abstraction: UMLClass
            fujaba__IterGeneralization20ElementsAbstraction = generalization20.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization20ElementsAbstraction.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization20ElementsAbstraction.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  abstraction = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (abstraction);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("NeighborCall") || annotation.equals ("Delegation") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstraction = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind operation: UMLMethod
            fujaba__IterAbstractionMethodsOperation = abstraction.iteratorOfMethods () ;
            while ( fujaba__IterAbstractionMethodsOperation.hasNext () )
            {
               try
               {
                  operation = (UMLMethod) fujaba__IterAbstractionMethodsOperation.next () ;
                   
                  {
                     //  for each flow
                     set.add (operation);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            implementor = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind operationImpl: UMLMethod
            fujaba__IterImplementorMethodsOperationImpl = implementor.iteratorOfMethods () ;
            while ( fujaba__IterImplementorMethodsOperationImpl.hasNext () )
            {
               try
               {
                  operationImpl = (UMLMethod) fujaba__IterImplementorMethodsOperationImpl.next () ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (operationImpl.isAbstract () == true) ) ;
                   
                  {
                     //  for each flow
                     set.add (operationImpl);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference18 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind implementor: UMLClass
            fujaba__IterReference18ElementsImplementor = reference18.iteratorOfElements ("references") ;
            while ( fujaba__IterReference18ElementsImplementor.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference18ElementsImplementor.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  implementor = (UMLClass) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (implementor.isAbstract () == true) ) ;
                   
                  // bind operationImpl: UMLMethod
                  fujaba__IterImplementorMethodsOperationImpl = implementor.iteratorOfMethods () ;
                  while ( fujaba__IterImplementorMethodsOperationImpl.hasNext () )
                  {
                     try
                     {
                        operationImpl = (UMLMethod) fujaba__IterImplementorMethodsOperationImpl.next () ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (operationImpl.isAbstract () == true) ) ;
                         
                        {
                           //  for each flow
                           set.add (operationImpl);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization20 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind abstraction: UMLClass
            fujaba__IterGeneralization20ElementsAbstraction = generalization20.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization20ElementsAbstraction.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization20ElementsAbstraction.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  abstraction = (UMLClass) fujaba__TmpObject ;
                   
                  // bind operation: UMLMethod
                  fujaba__IterAbstractionMethodsOperation = abstraction.iteratorOfMethods () ;
                  while ( fujaba__IterAbstractionMethodsOperation.hasNext () )
                  {
                     try
                     {
                        operation = (UMLMethod) fujaba__IterAbstractionMethodsOperation.next () ;
                         
                        {
                           //  for each flow
                           set.add (operation);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("Generalization") || annotation.equals ("MultiLevelGeneralization") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstraction = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (abstraction);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            implementor = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind operationImpl: UMLMethod
            fujaba__IterImplementorMethodsOperationImpl = implementor.iteratorOfMethods () ;
            while ( fujaba__IterImplementorMethodsOperationImpl.hasNext () )
            {
               try
               {
                  operationImpl = (UMLMethod) fujaba__IterImplementorMethodsOperationImpl.next () ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (operationImpl.isAbstract () == true) ) ;
                   
                  // bind neighborCall21: NeighborCallAnnotation
                  fujaba__IterOperationImplAnnotationsNeighborCall21 = operationImpl.iteratorOfAnnotations () ;
                  while ( fujaba__IterOperationImplAnnotationsNeighborCall21.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterOperationImplAnnotationsNeighborCall21.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        neighborCall21 = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between neighborCall21 and operationImpl
                        JavaSDM.ensure ( neighborCall21.hasInElements ("callee", operationImpl) ) ;
                         
                        // bind operation: UMLMethod
                        fujaba__IterNeighborCall21ElementsOperation = neighborCall21.iteratorOfElements ("caller") ;
                        while ( fujaba__IterNeighborCall21ElementsOperation.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterNeighborCall21ElementsOperation.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                              operation = (UMLMethod) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                               
                              // bind abstraction: UMLClass
                              abstraction = operation.getParent () ;
                              JavaSDM.ensure ( abstraction != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                               
                              {
                                 //  for each flow
                                 set.add (abstraction);
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference18 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind implementor: UMLClass
            fujaba__IterReference18ElementsImplementor = reference18.iteratorOfElements ("references") ;
            while ( fujaba__IterReference18ElementsImplementor.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference18ElementsImplementor.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  implementor = (UMLClass) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (implementor.isAbstract () == true) ) ;
                   
                  // bind operationImpl: UMLMethod
                  fujaba__IterImplementorMethodsOperationImpl = implementor.iteratorOfMethods () ;
                  while ( fujaba__IterImplementorMethodsOperationImpl.hasNext () )
                  {
                     try
                     {
                        operationImpl = (UMLMethod) fujaba__IterImplementorMethodsOperationImpl.next () ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (operationImpl.isAbstract () == true) ) ;
                         
                        // bind neighborCall22: NeighborCallAnnotation
                        fujaba__IterOperationImplAnnotationsNeighborCall22 = operationImpl.iteratorOfAnnotations () ;
                        while ( fujaba__IterOperationImplAnnotationsNeighborCall22.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterOperationImplAnnotationsNeighborCall22.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                              neighborCall22 = (NeighborCallAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between neighborCall22 and operationImpl
                              JavaSDM.ensure ( neighborCall22.hasInElements ("callee", operationImpl) ) ;
                               
                              // bind operation: UMLMethod
                              fujaba__IterNeighborCall22ElementsOperation = neighborCall22.iteratorOfElements ("caller") ;
                              while ( fujaba__IterNeighborCall22ElementsOperation.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterNeighborCall22ElementsOperation.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                    operation = (UMLMethod) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                                     
                                    // bind abstraction: UMLClass
                                    abstraction = operation.getParent () ;
                                    JavaSDM.ensure ( abstraction != null ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                     
                                    {
                                       //  for each flow
                                       set.add (abstraction);
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall22 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind operationImpl: UMLMethod
            fujaba__IterNeighborCall22ElementsOperationImpl = neighborCall22.iteratorOfElements ("callee") ;
            while ( fujaba__IterNeighborCall22ElementsOperationImpl.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall22ElementsOperationImpl.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  operationImpl = (UMLMethod) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (operationImpl.isAbstract () == true) ) ;
                   
                  // bind implementor: UMLClass
                  implementor = operationImpl.getParent () ;
                  JavaSDM.ensure ( implementor != null ) ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (implementor.isAbstract () == true) ) ;
                   
                  // bind reference23: ReferenceAnnotation
                  fujaba__IterImplementorAnnotationsReference23 = implementor.iteratorOfAnnotations () ;
                  while ( fujaba__IterImplementorAnnotationsReference23.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterImplementorAnnotationsReference23.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                        reference23 = (ReferenceAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between reference23 and implementor
                        JavaSDM.ensure ( reference23.hasInElements ("references", implementor) ) ;
                         
                        // bind abstraction: UMLClass
                        fujaba__IterReference23ElementsAbstraction = reference23.iteratorOfElements ("referencingClass") ;
                        while ( fujaba__IterReference23ElementsAbstraction.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterReference23ElementsAbstraction.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                              abstraction = (UMLClass) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                               
                              {
                                 //  for each flow
                                 set.add (abstraction);
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
