/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.xmlreflect.util;

import de.tu_bs.xmlreflect.util.EmptyIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SameHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private static final transient boolean debug = true;
    private transient Element[] table;
    private transient int size = 0;
    private transient int clearCount = 0;
    private int threshold;
    private float loadFactor;
    private transient Element header = new Element(0, null, null, null);
    private transient Set keySet = null;
    private transient Collection valuesCollection = null;
    private transient Set entrySet = null;

    public SameHashMap() {
        this(11, 0.75f);
    }

    public SameHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public SameHashMap(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    public SameHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Element[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public Object clone() {
        return new SameHashMap(this);
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized boolean containsValue(Object value) {
        Element[] tab = this.table;
        if (value != null) {
            for (int i = tab.length - 1; i >= 0; --i) {
                Element elem = tab[i];
                while (elem != null) {
                    if (value.equals(elem.getValue())) {
                        return true;
                    }
                    elem = elem.nextKey;
                }
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                Element elem = tab[i];
                while (elem != null) {
                    if (elem.getValue() == null) {
                        return true;
                    }
                    elem = elem.nextKey;
                }
            }
        }
        return false;
    }

    public synchronized boolean containsKey(Object key) {
        Element[] tab = this.table;
        if (key != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Element elem = tab[index];
            while (elem != null) {
                if (key == elem.key) {
                    return true;
                }
                elem = elem.nextKey;
            }
        } else {
            Element elem = tab[0];
            while (elem != null) {
                if (elem.key == null) {
                    return true;
                }
                elem = elem.nextKey;
            }
        }
        return false;
    }

    public synchronized Object get(Object key) {
        Element[] tab = this.table;
        if (key != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Element elem = tab[index];
            while (elem != null) {
                if (key == elem.key) {
                    return elem.getValue();
                }
                elem = elem.nextKey;
            }
        } else {
            Element elem = tab[0];
            while (elem != null) {
                if (elem.key == null) {
                    return elem.getValue();
                }
                elem = elem.nextKey;
            }
        }
        return null;
    }

    public synchronized Object put(Object key, Object value) {
        Element e;
        Element elem;
        Element[] tab = this.table;
        int hash = 0;
        int index = 0;
        if (key != null) {
            hash = key.hashCode();
            index = (hash & Integer.MAX_VALUE) % tab.length;
            elem = tab[index];
            while (elem != null) {
                if (key == elem.key) {
                    Object old = elem.getValue();
                    elem.setValue(value);
                    return old;
                }
                elem = elem.nextKey;
            }
        } else {
            elem = tab[0];
            while (elem != null) {
                if (elem.key == null) {
                    Object old = elem.getValue();
                    elem.setValue(value);
                    return old;
                }
                elem = elem.nextKey;
            }
        }
        if (this.size >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = this.createElement(hash, key, value, tab[index]);
        this.addElementToList(e);
        ++this.size;
        return null;
    }

    public synchronized void removeValue(Object value) {
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Object entryValue = entry.getValue();
            if ((value != null || entryValue != null) && (value == null || !value.equals(entryValue))) continue;
            iter.remove();
        }
    }

    public synchronized Object remove(Object key) {
        Element[] tab = this.table;
        Element prev = null;
        if (key != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Element e = tab[index];
            while (e != null) {
                if (key == e.key) {
                    if (prev != null) {
                        prev.nextKey = e.nextKey;
                    } else {
                        tab[index] = e.nextKey;
                    }
                    this.removeElementFromList(e);
                    --this.size;
                    return e.getValue();
                }
                prev = e;
                e = e.nextKey;
            }
        } else {
            Element e = tab[0];
            while (e != null) {
                if (e.key == null) {
                    if (prev != null) {
                        prev.nextKey = e.nextKey;
                    } else {
                        tab[0] = e.nextKey;
                    }
                    this.removeElementFromList(e);
                    --this.size;
                    return e.getValue();
                }
                prev = e;
                e = e.nextKey;
            }
        }
        return null;
    }

    public synchronized void putAll(Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void clear() {
        Element[] tab = this.table;
        ++this.clearCount;
        for (int i = tab.length - 1; i >= 0; --i) {
            tab[i] = null;
        }
        this.header.nextElem = this.header;
        this.header.prevElem = this.header;
        this.size = 0;
    }

    public synchronized Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public synchronized Collection values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new ValuesCollection();
        }
        return this.valuesCollection;
    }

    public synchronized Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    protected Element createElement(int hash, Object key, Object value, Element nextKey) {
        return new Element(hash, key, value, nextKey);
    }

    protected Element createElement(int hash, Object key, Object value, Element nextKey, Element nextElem, Element prevElem) {
        return new Element(hash, key, value, nextKey, nextElem, prevElem);
    }

    private final void rehash() {
        int oldCapacity = this.table.length;
        Element[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Element[] newMap = new Element[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Element old = oldMap[i];
            while (old != null) {
                Element e = old;
                old = old.nextKey;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.nextKey = newMap[index];
                newMap[index] = e;
            }
        }
    }

    private final synchronized boolean contains(Map.Entry entry) {
        Object key = entry.getKey();
        Element[] tab = this.table;
        int hash = key == null ? 0 : key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Element e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.equals(entry)) {
                return true;
            }
            e = e.nextKey;
        }
        return false;
    }

    private final synchronized boolean remove(Map.Entry entry) {
        Object key = entry.getKey();
        Element prev = null;
        Element[] tab = this.table;
        int hash = key == null ? 0 : key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Element e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.equals(entry)) {
                if (prev != null) {
                    prev.nextKey = e.nextKey;
                } else {
                    tab[index] = e.nextKey;
                }
                this.removeElementFromList(e);
                --this.size;
                return true;
            }
            prev = e;
            e = e.nextKey;
        }
        return false;
    }

    private static final boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private final void addElementToList(Element elem) {
        Element head;
        elem.nextElem = head = this.header;
        elem.prevElem = head.prevElem;
        head.prevElem.nextElem = elem;
        head.prevElem = elem;
    }

    private final void removeElementFromList(Element elem) {
        elem.prevElem.nextElem = elem.nextElem;
        elem.nextElem.prevElem = elem.prevElem;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.table.length);
        out.writeInt(this.size);
        for (int index = this.table.length - 1; index >= 0; --index) {
            Element elem = this.table[index];
            while (elem != null) {
                out.writeObject(elem.key);
                out.writeObject(elem.getValue());
                elem = elem.nextKey;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.header = new Element(0, null, null, null);
        int numBuckets = in.readInt();
        this.table = new Element[numBuckets];
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.put(key, value);
        }
    }

    public int capacity() {
        return this.table.length;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    static class Element
    implements Map.Entry {
        int hash;
        Object key;
        private Object value;
        Element nextKey;
        Element nextElem;
        Element prevElem;

        public Element(int hash, Object key, Object value, Element nextKey) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.nextKey = nextKey;
            this.nextElem = this;
            this.prevElem = this;
        }

        public Element(int hash, Object key, Object value, Element nextKey, Element nextElem, Element prevElem) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.nextKey = nextKey;
            this.nextElem = nextElem;
            this.prevElem = prevElem;
        }

        protected Object clone() {
            return new Element(this.hash, this.key, this.value, this.nextKey == null ? null : (Element)this.nextKey.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return this.key == entry.getKey() && SameHashMap.valEquals(this.value, entry.getValue());
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }

    private class SameHashMapIterator
    extends EmptyIterator {
        private static final int KEYS = 0;
        private static final int VALUES = 1;
        private static final int ENTRIES = 2;
        private int expectedClearCount;
        private Element head;
        private int type;
        private Element current;
        private boolean fetched;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SameHashMapIterator(int type) {
            this.expectedClearCount = SameHashMap.this.clearCount;
            this.head = SameHashMap.this.header;
            this.current = null;
            this.fetched = false;
            SameHashMap sameHashMap = SameHashMap.this;
            synchronized (sameHashMap) {
                this.type = type;
                this.current = this.head.nextElem;
                this.fetched = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean hasNext() {
            SameHashMap sameHashMap = SameHashMap.this;
            synchronized (sameHashMap) {
                if (!this.fetched) {
                    if (this.expectedClearCount != SameHashMap.this.clearCount) {
                        this.current = this.head;
                    } else if (this.current != this.head) {
                        do {
                            this.current = this.current.nextElem;
                        } while (this.current != this.head && this.current.prevElem.nextElem != this.current);
                    }
                    this.fetched = true;
                }
                return this.current != this.head;
            }
        }

        public synchronized Object next() {
            if (!this.fetched) {
                this.hasNext();
            }
            if (this.current == this.head) {
                throw new NoSuchElementException();
            }
            this.fetched = false;
            if (this.type == 0) {
                return this.current.key;
            }
            if (this.type == 1) {
                return this.current.getValue();
            }
            return this.current;
        }

        public void remove() {
            new RuntimeException("@@@@@please remove this method call!").printStackTrace();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new SameHashMapIterator(2);
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return SameHashMap.this.contains((Map.Entry)o);
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return SameHashMap.this.remove((Map.Entry)o);
        }

        public int size() {
            return SameHashMap.this.size();
        }

        public void clear() {
            SameHashMap.this.clear();
        }
    }

    private class ValuesCollection
    extends AbstractCollection {
        private ValuesCollection() {
        }

        public Iterator iterator() {
            return new SameHashMapIterator(1);
        }

        public int size() {
            return SameHashMap.this.size();
        }

        public boolean contains(Object obj) {
            return SameHashMap.this.containsValue(obj);
        }

        public void clear() {
            SameHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new SameHashMapIterator(0);
        }

        public int size() {
            return SameHashMap.this.size();
        }

        public boolean contains(Object o) {
            return SameHashMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return SameHashMap.this.remove(o) != null;
        }

        public void clear() {
            SameHashMap.this.clear();
        }
    }
}

