/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.xmlreflect;

import de.tu_bs.xmlreflect.DefaultXMLReflectImpl;
import de.tu_bs.xmlreflect.Link;
import de.tu_bs.xmlreflect.LinkFactory;
import de.tu_bs.xmlreflect.ObjectNotReflectableException;
import de.tu_bs.xmlreflect.util.AccessorMethodsUtilizer;
import de.tu_bs.xmlreflect.util.SameHashMap;
import de.tu_bs.xmlreflect.util.errors.AccessorException;
import de.upb.tools.fca.FEmptyIterator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class XMLReflect
extends DefaultXMLReflectImpl {
    private static final Logger L = Logger.getLogger((Class)(class$de$tu_bs$xmlreflect$XMLReflect == null ? (class$de$tu_bs$xmlreflect$XMLReflect = XMLReflect.class$("de.tu_bs.xmlreflect.XMLReflect")) : class$de$tu_bs$xmlreflect$XMLReflect));
    private SameHashMap reflectedValues;
    private Map ignoredClasses;
    private static Map primitiveMap;
    private static Map classCache;
    public static final int INFINITE_DEPTH = -1;
    private LinkFactory linkFactory;
    protected static Object NONE;
    private static Map singletons;
    private SameHashMap reflectedXML = new SameHashMap();
    private boolean quiet = false;
    private boolean tolerant = true;
    private boolean storingAllTypes = false;
    private boolean storingDefaultValues = false;
    boolean restoringIDs = false;
    int allReferencedObjectsStoringDepth = 0;
    private HashMap classDefaultValues = new HashMap();
    private TreeSet alreadyNotified = new TreeSet();
    private ClassLoader classLoader2;
    static /* synthetic */ Class class$de$tu_bs$xmlreflect$XMLReflect;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$de$tu_bs$xmlreflect$Link;

    protected ValueInfo getValueInfo(Object value) {
        if (this.reflectedValues == null) {
            return null;
        }
        return (ValueInfo)this.reflectedValues.get(value);
    }

    private void putValueInfo(Object value, ValueInfo valueInfo) {
        if (this.reflectedValues == null) {
            this.reflectedValues = new SameHashMap();
        }
        this.reflectedValues.put(value, valueInfo);
    }

    private boolean hasValueInfo(Object value) {
        if (this.reflectedValues == null) {
            return false;
        }
        return this.reflectedValues.containsKey(value);
    }

    protected Iterator iteratorOfValueInfos() {
        return this.reflectedValues.values().iterator();
    }

    protected String getStoredClassName(Class cls) {
        return cls.getName().replaceAll("\\$", "_._");
    }

    public Class getClassForStoredName(String name) {
        Object exception;
        Object v0 = exception = this.ignoredClasses != null ? this.ignoredClasses.get(name) : null;
        if (exception == null) {
            try {
                return XMLReflect.getClassForStoredName(name, this.getClassLoader());
            }
            catch (ObjectNotReflectableException e) {
                String fullName = name.replaceAll("_._", "\\$");
                if (this.ignoredClasses == null) {
                    this.ignoredClasses = new HashMap();
                }
                this.ignoredClasses.put(name, new ObjectNotReflectableException((Object)fullName));
                throw e;
            }
        }
        throw (ObjectNotReflectableException)exception;
    }

    public static Class getClassForStoredName(String name, ClassLoader loader) {
        Class<?> cls;
        if (primitiveMap == null) {
            primitiveMap = new HashMap();
            primitiveMap.put("boolean", Boolean.TYPE);
            primitiveMap.put("char", Character.TYPE);
            primitiveMap.put("double", Double.TYPE);
            primitiveMap.put("float", Float.TYPE);
            primitiveMap.put("int", Integer.TYPE);
            primitiveMap.put("long", Long.TYPE);
            primitiveMap.put("short", Short.TYPE);
        }
        if ((cls = (Class<?>)primitiveMap.get(name)) != null) {
            return cls;
        }
        if (classCache == null) {
            classCache = new HashMap();
        }
        if ((cls = (Class)classCache.get(name)) != null) {
            return cls;
        }
        String fullName = name.replaceAll("_._", "\\$");
        try {
            cls = Class.forName(fullName, true, loader);
            classCache.put(name, cls);
            return cls;
        }
        catch (ClassNotFoundException e) {
            throw new ObjectNotReflectableException((Object)fullName, (Throwable)e);
        }
    }

    public Element reflectField(String tagName, Object fieldValue, Class fieldType, Field field, int depth) throws ObjectNotReflectableException {
        Element fieldValueElement;
        if (depth == 0) {
            return null;
        }
        if (depth == -2) {
            depth = -1;
        }
        String part = tagName;
        if (tagName == null && field != null) {
            tagName = field.getName();
        }
        int fieldStoreMode = this.getStoreMode(field, part, fieldValue);
        switch (fieldStoreMode) {
            case 3: {
                return null;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                throw new RuntimeException("getStoreMode returned illegal store mode!");
            }
        }
        Element fieldElement = new Element(tagName);
        if (fieldValue != null) {
            if (!(fieldType.isPrimitive() || !this.isStoringAllTypes() && fieldValue.getClass().getName().equals(fieldType.getName()))) {
                fieldElement.setAttribute("type", this.getStoredClassName(fieldValue.getClass()));
            }
        } else {
            fieldElement.setAttribute("isNull", "true");
        }
        if (fieldValue instanceof Class) {
            fieldElement.addContent(this.getStoredClassName((Class)fieldValue));
            return fieldElement;
        }
        boolean reflectable = this.isReflectableObject(fieldValue);
        if (reflectable && (fieldValueElement = this.reflectObject(fieldValue, fieldStoreMode, depth)) != null) {
            fieldElement.addContent(fieldValueElement);
        }
        if (fieldValue != null) {
            if ((class$java$util$Map == null ? (class$java$util$Map = XMLReflect.class$("java.util.Map")) : class$java$util$Map).isInstance(fieldValue)) {
                TreeMap map = (TreeMap)fieldValue;
                if (map.getClass().getName().indexOf("Hash") >= 0) {
                    TreeMap tree = new TreeMap();
                    tree.putAll(map);
                    map = tree;
                }
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    Element entryElement = new Element("entry");
                    Element keyElement = this.reflectField("key", key, class$java$lang$Object == null ? XMLReflect.class$("java.lang.Object") : class$java$lang$Object, field, depth - 1);
                    Element valueElement = this.reflectField("value", map.get(key), class$java$lang$Object == null ? XMLReflect.class$("java.lang.Object") : class$java$lang$Object, field, depth - 1);
                    if (keyElement == null || valueElement == null) continue;
                    entryElement.addContent(keyElement);
                    entryElement.addContent(valueElement);
                    fieldElement.addContent(entryElement);
                }
            } else if ((class$java$util$Collection == null ? (class$java$util$Collection = XMLReflect.class$("java.util.Collection")) : class$java$util$Collection).isInstance(fieldValue)) {
                Collection collection = (Collection)fieldValue;
                Iterator it = collection.iterator();
                while (it.hasNext()) {
                    Object object = it.next();
                    Element valueElement = this.reflectField("value", object, class$java$lang$Object == null ? XMLReflect.class$("java.lang.Object") : class$java$lang$Object, field, depth - 1);
                    if (valueElement == null) continue;
                    fieldElement.addContent(valueElement);
                }
            } else if (fieldValue.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(fieldValue); ++i) {
                    Element valueValueElement;
                    Object arrayValue = Array.get(fieldValue, i);
                    if (arrayValue == null || (valueValueElement = this.reflectField("value", arrayValue, fieldValue.getClass().getComponentType(), field, depth - 1)) == null) continue;
                    fieldElement.addContent(valueValueElement);
                }
            } else if (!reflectable) {
                fieldElement.addContent(fieldValue.toString());
                if (!this.isQuiet()) {
                    Class<?> valueClass = fieldValue.getClass();
                    if (!fieldType.isPrimitive()) {
                        Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = XMLReflect.class$("java.lang.String")) : class$java$lang$String};
                        try {
                            valueClass.getDeclaredConstructor(paramTypes);
                        }
                        catch (NoSuchMethodException e) {
                            try {
                                valueClass.getDeclaredConstructor(null);
                                this.notifyUser("Value for field '" + field + "' (" + tagName + ") will not be restorable.", true);
                            }
                            catch (NoSuchMethodException e2) {
                                fieldValue = null;
                                this.notifyUser("Value for field '" + field + "' (" + tagName + ") will be set to null on restore.", true);
                            }
                        }
                    }
                }
            }
        } else if (!reflectable) {
            // empty if block
        }
        return fieldElement;
    }

    public Element reflectObject(Object objInstance) throws ObjectNotReflectableException {
        Element root = this.reflectObject(objInstance, 0, -1);
        int depth = this.getAllReferencedObjectsStoringDepth();
        if (depth > 0) {
            Element allReferencedObjects = new Element("allReferencedObjects");
            root.addContent(allReferencedObjects);
            Vector<Object> toBeReflected = new Vector<Object>();
            Iterator it = this.iteratorOfValueInfos();
            while (it.hasNext()) {
                ValueInfo info = (ValueInfo)it.next();
                if (info.stored) continue;
                toBeReflected.add(info.object);
            }
            while (!toBeReflected.isEmpty()) {
                Object object = toBeReflected.remove(0);
                Element ref = this.reflectObject(object, 0, depth + 1);
                allReferencedObjects.addContent(ref);
            }
        }
        this.clear(true);
        return root;
    }

    public String getIDForObject(Object objInstance) {
        Object fieldValue;
        block9: {
            Class<?> objClass = objInstance.getClass();
            fieldValue = null;
            try {
                try {
                    Method getID = objClass.getMethod("getID", null);
                    getID.setAccessible(true);
                    fieldValue = getID.invoke(objInstance, null);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Field idField = this.findDeclaredField(objClass, this.getIDString());
                        idField.setAccessible(true);
                        fieldValue = idField.get(objInstance);
                    }
                    catch (NoSuchFieldException ex) {
                    }
                }
                catch (InvocationTargetException e) {
                    if (!this.isQuiet()) {
                        this.notifyUser(e + " while reading id for object " + objInstance + "!", e);
                    }
                }
            }
            catch (IllegalAccessException e) {
                if (this.isQuiet()) break block9;
                this.notifyUser(e + " while reading id for object " + objInstance + "!", e);
            }
        }
        if (fieldValue != null) {
            return fieldValue.toString();
        }
        return null;
    }

    public void setIDForObject(Object objInstance, String id) {
        block6: {
            try {
                if (id != null && !id.equals("")) {
                    Class<?> objClass = objInstance.getClass();
                    try {
                        Field idField = this.findDeclaredField(objClass, this.getIDString());
                        idField.setAccessible(true);
                        idField.set(objInstance, id);
                    }
                    catch (NoSuchFieldException e) {
                        if (!this.isQuiet()) {
                            this.notifyUser("Ignored id for object '" + objInstance + "' as field was not found!", false);
                        }
                    }
                }
            }
            catch (IllegalAccessException e) {
                if (this.isQuiet()) break block6;
                this.notifyUser("Ignored id for object '" + objInstance + "' due to " + e + ".", false);
            }
        }
    }

    protected Element reflectObject(Object objInstance, int storeMode, int depth) throws ObjectNotReflectableException {
        ValueInfo info;
        if (depth == 0) {
            return null;
        }
        if (!this.hasValueInfo(objInstance) || storeMode == 2) {
            info = new ValueInfo();
            info.object = objInstance;
            info.stored = storeMode != 1;
            String id = this.getIDForObject(objInstance);
            if (!(id != null && !"".equals(id) || this.isQuiet() || (class$java$util$Collection == null ? (class$java$util$Collection = XMLReflect.class$("java.util.Collection")) : class$java$util$Collection).isInstance(objInstance) || (class$java$util$Map == null ? (class$java$util$Map = XMLReflect.class$("java.util.Map")) : class$java$util$Map).isInstance(objInstance))) {
                this.notifyUser("Id for object " + objInstance + " is empty!", false);
            }
            if (id != null && !id.equals("")) {
                info.id = id;
            } else {
                if (!(this.isQuiet() || (class$java$util$Collection == null ? (class$java$util$Collection = XMLReflect.class$("java.util.Collection")) : class$java$util$Collection).isInstance(objInstance) || (class$java$util$Map == null ? (class$java$util$Map = XMLReflect.class$("java.util.Map")) : class$java$util$Map).isInstance(objInstance))) {
                    this.notifyUser("Id for object " + objInstance + " is empty!", false);
                }
                info.id = null;
            }
            if (storeMode != 2) {
                this.putValueInfo(objInstance, info);
            }
        } else {
            info = this.getValueInfo(objInstance);
            if (info.object != objInstance) {
                throw new RuntimeException("The hashmap used to store visited object does not function properly!");
            }
            if (storeMode != 2 && info.stored) {
                storeMode = 1;
            }
        }
        if (storeMode != 1 && info.xml == null) {
            info.stored = true;
            try {
                TreeSet<String> fieldNames;
                Element objElement = null;
                if (this.isReflectableObject(objInstance)) {
                    this.initReflectedState(objInstance);
                    Class<?> objClass = objInstance.getClass();
                    objElement = new Element(this.getStoredClassName(objClass));
                    if (info.id != null) {
                        objElement.setAttribute(this.getIDString(), info.id);
                    }
                    Object fieldValue = null;
                    boolean hadIDField = false;
                    fieldNames = new TreeSet<String>();
                    for (Class<?> currentClass = objClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
                        Field[] fields = currentClass.getDeclaredFields();
                        for (int fieldNr = 0; fieldNr < fields.length; ++fieldNr) {
                            Field field = fields[fieldNr];
                            String fieldName = field.getName();
                            if (fieldName.equals(this.getIDString()) && !hadIDField) {
                                hadIDField = true;
                                continue;
                            }
                            if (fieldName.startsWith("this$")) continue;
                            int ignoreWhenHas = 24;
                            if (this.getStoreMode(field, null) == 0) {
                                ignoreWhenHas |= 0x80;
                            }
                            if ((field.getModifiers() & ignoreWhenHas) == 0) {
                                Element fieldElement;
                                boolean storeThis;
                                block30: {
                                    field.setAccessible(true);
                                    fieldValue = field.get(objInstance);
                                    boolean bl = this.isStoringDefaultValues() || !field.getType().isPrimitive() && !field.getType().isAssignableFrom(class$java$lang$String == null ? XMLReflect.class$("java.lang.String") : class$java$lang$String) && fieldValue != null ? true : (storeThis = false);
                                    if (!storeThis) {
                                        try {
                                            storeThis = fieldValue != null ? !fieldValue.equals(this.getDefaultValue(field, objClass)) : this.getDefaultValue(field, objClass) != null;
                                        }
                                        catch (Exception e) {
                                            if (this.isQuiet()) break block30;
                                            this.notifyUser("Could not determine default values for fields in " + objClass, true);
                                        }
                                    }
                                }
                                if (storeThis && (fieldElement = this.reflectField(null, fieldValue, field.getType(), field, depth - 1)) != null) {
                                    if (currentClass != objClass && (fieldName.equals(this.getIDString()) || fieldNames.contains(fieldName))) {
                                        fieldElement.setAttribute("declaringClass", this.getStoredClassName(currentClass));
                                    }
                                    objElement.addContent(fieldElement);
                                }
                            }
                            fieldNames.add(fieldName);
                        }
                    }
                } else {
                    if (objInstance != null) {
                        throw new ObjectNotReflectableException(objInstance);
                    }
                    if (!this.isQuiet()) {
                        this.notifyUser("Null value passed to reflectObject!", true);
                    }
                    return null;
                }
                fieldNames.clear();
                info.xml = objElement;
            }
            catch (IllegalAccessException e) {
                throw new ObjectNotReflectableException(objInstance, (Throwable)e);
            }
        }
        if (storeMode != 1) {
            return info.xml;
        }
        Link linkObject = this.getLinkFactory().createLinkTo(objInstance, info.id);
        if (linkObject == null) {
            throw new NullPointerException("Link must not be null!");
        }
        Element elem = new Element(this.getStoredClassName(linkObject.getClass()));
        elem.setAttribute("targetID", linkObject.toString());
        return elem;
    }

    public LinkFactory getLinkFactory() {
        if (this.linkFactory == null) {
            this.linkFactory = new LinkFactory();
            this.linkFactory.setQuiet(this.isQuiet());
        }
        return this.linkFactory;
    }

    public void setLinkFactory(LinkFactory linkFactory) {
        this.linkFactory = linkFactory;
    }

    private Field findDeclaredField(Class objClass, String fieldname) throws NoSuchFieldException {
        for (Class currentClass = objClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Field field = currentClass.getDeclaredField(fieldname);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(fieldname);
    }

    protected Field findDeclaredField(Class objClass, String fieldname, String declaringClass) throws NoSuchFieldException {
        for (Class currentClass = objClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            if (declaringClass != null && !this.getStoredClassName(currentClass).equals(declaringClass)) continue;
            try {
                Field field = currentClass.getDeclaredField(fieldname);
                return field;
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        throw new NoSuchFieldException(fieldname);
    }

    public static void addToSingletons(Class cls, Object instance) {
        if (instance != null) {
            if (singletons == null) {
                singletons = new HashMap();
            }
            singletons.put(cls, instance);
        }
    }

    public static Iterator iteratorOfSingletons() {
        return singletons != null ? singletons.keySet().iterator() : FEmptyIterator.get();
    }

    public Object createObjectInstance(Class objClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object singletonInstance = XMLReflect.getFromSingletons(objClass);
        if (singletonInstance != null) {
            return singletonInstance;
        }
        Constructor objConstructor = objClass.getDeclaredConstructor(null);
        objConstructor.setAccessible(true);
        return objConstructor.newInstance(null);
    }

    public static Object getFromSingletons(Class objClass) {
        return singletons != null ? singletons.get(objClass) : null;
    }

    public Object reflectXMLField(Element subTag, Class fieldClass, Object declaringObject) throws ObjectNotReflectableException {
        try {
            this.reflectXMLField(subTag, fieldClass, false, declaringObject);
            Object value = this.reflectXMLField(subTag, fieldClass, true, declaringObject);
            return value;
        }
        catch (InstantiationException e) {
            throw new ObjectNotReflectableException((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectNotReflectableException((Object)e);
        }
    }

    private Object reflectXMLField(Element subTag, Class fieldClass, boolean resolveLinks, Object declaringObject) throws ObjectNotReflectableException, InstantiationException, IllegalAccessException {
        Element slotElement;
        Iterator it;
        Object fieldValue;
        Class valueClass = null;
        String isNullString = subTag.getAttributeValue("isNull");
        if (isNullString != null) {
            return null;
        }
        String storedType = subTag.getAttributeValue("type");
        String fieldName = subTag.getName();
        try {
            if (storedType == null || storedType.equals("")) {
                valueClass = fieldClass;
                storedType = "";
            } else {
                valueClass = this.getClassForStoredName(storedType);
                if (!fieldClass.isAssignableFrom(valueClass)) {
                    if (!this.isQuiet()) {
                        this.notifyUser("Field " + subTag.getName() + " does not have type " + valueClass.getName() + ". Try to use " + fieldClass.getName() + " instead.", true);
                    }
                    valueClass = fieldClass;
                }
            }
            if ((class$java$lang$Class == null ? (class$java$lang$Class = XMLReflect.class$("java.lang.Class")) : class$java$lang$Class).isAssignableFrom(valueClass)) {
                String className = subTag.getText();
                if (className.startsWith("class ")) {
                    className = className.substring(6);
                }
                return this.getClassForStoredName(className);
            }
            Object onlyInstance = XMLReflect.getFromSingletons(valueClass);
            if (onlyInstance != null) {
                return onlyInstance;
            }
        }
        catch (Exception e) {
            this.notifyUser("Was not able to find class '" + subTag.getText() + "'.", true);
            if (this.isTolerant()) {
                if (!this.isQuiet() && L.isEnabledFor(Priority.INFO)) {
                    this.notifyUser("Class reference '" + subTag.getText() + "' discarded due to " + e, e.getCause());
                }
                return null;
            }
            throw new ObjectNotReflectableException(valueClass, (Throwable)e);
        }
        boolean reflectable = this.isReflectable(valueClass);
        boolean haveAdditionalChildren = false;
        if (reflectable) {
            Element firstChild = null;
            List children = subTag.getChildren();
            if (children.size() > 0) {
                for (int i = 0; i < children.size(); ++i) {
                    Object child = children.get(i);
                    if (!(child instanceof Element)) continue;
                    if (firstChild == null) {
                        firstChild = (Element)child;
                        continue;
                    }
                    haveAdditionalChildren = true;
                    break;
                }
            }
            if (firstChild != null) {
                fieldValue = this.reflectXMLObject(firstChild, resolveLinks);
                if (fieldValue == null && resolveLinks && !this.isQuiet()) {
                    this.notifyUser("restored null from non empty tag " + subTag + " (contains:" + subTag.getContent() + ")!", true);
                }
            } else {
                fieldValue = null;
            }
        } else {
            fieldValue = null;
        }
        Object collection = !reflectable ? null : fieldValue;
        if (((class$java$util$Map == null ? (class$java$util$Map = XMLReflect.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(valueClass) || (class$java$util$Collection == null ? (class$java$util$Collection = XMLReflect.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(valueClass)) && !reflectable) {
            try {
                Constructor ctor = valueClass.getDeclaredConstructor(null);
                ctor.setAccessible(true);
                fieldValue = collection = ctor.newInstance(null);
            }
            catch (NoSuchMethodException e) {
                throw new ObjectNotReflectableException(valueClass, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ObjectNotReflectableException(valueClass, (Throwable)e);
            }
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = XMLReflect.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(valueClass)) {
            haveAdditionalChildren = false;
            it = subTag.getChildren().iterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (!(child instanceof Element) || !(slotElement = (Element)child).getName().equals("entry")) continue;
                Element keyElement = slotElement.getChild("key");
                Element valueElement = slotElement.getChild("value");
                if (keyElement != null) {
                    Object key = this.reflectXMLField(keyElement, class$java$lang$Object == null ? XMLReflect.class$("java.lang.Object") : class$java$lang$Object, resolveLinks, declaringObject);
                    if (key == null && resolveLinks && !this.isQuiet()) {
                        this.notifyUser("Discarded key for a " + fieldClass.getName() + " as it evaluated to null!", false);
                        continue;
                    }
                    Object value = valueElement != null ? this.reflectXMLField(valueElement, class$java$lang$Object == null ? XMLReflect.class$("java.lang.Object") : class$java$lang$Object, resolveLinks, declaringObject) : null;
                    if (!resolveLinks || value == NONE || key == NONE) continue;
                    ((Map)collection).put(key, value);
                    continue;
                }
                if (this.isTolerant()) {
                    if (this.isQuiet()) continue;
                    this.notifyUser("Key tag for an entry in field '" + fieldName + "' not found - entry was discarded.", true);
                    continue;
                }
                throw new ObjectNotReflectableException(slotElement);
            }
        } else if ((class$java$util$Collection == null ? (class$java$util$Collection = XMLReflect.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(valueClass)) {
            haveAdditionalChildren = false;
            it = subTag.getChildren().iterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (!(child instanceof Element) || !(slotElement = (Element)child).getName().equals("value")) continue;
                Object object = this.reflectXMLField(slotElement, class$java$lang$Object == null ? XMLReflect.class$("java.lang.Object") : class$java$lang$Object, resolveLinks, declaringObject);
                if (object == null && resolveLinks && !this.isQuiet()) {
                    this.notifyUser("restored null object from " + this.toString(slotElement, true), true);
                }
                if (!resolveLinks || object == null || object == NONE) continue;
                ((Collection)collection).add(object);
            }
        } else if (valueClass.isArray()) {
            haveAdditionalChildren = false;
            int length = 0;
            Iterator it2 = subTag.getChildren().iterator();
            while (it2.hasNext()) {
                if (!(it2.next() instanceof Element)) continue;
                ++length;
            }
            fieldValue = Array.newInstance(valueClass.getComponentType(), length);
            int index = -1;
            it2 = subTag.getChildren().iterator();
            while (it2.hasNext()) {
                Object child = it2.next();
                if (!(child instanceof Element)) continue;
                Element slotElement2 = (Element)child;
                ++index;
                Object entry = this.reflectXMLField(slotElement2, valueClass.getComponentType(), resolveLinks, declaringObject);
                if (!resolveLinks || entry == NONE) continue;
                Array.set(fieldValue, index, entry);
            }
        } else if (!reflectable) {
            if (!this.isQuiet() && subTag.getChildren().size() > 0) {
                this.notifyUser("Sub tags of '" + fieldName + "' are discarded as type " + valueClass.getName() + " has no handling for sub tags.", true);
            }
            String fieldValueString = subTag.getText();
            fieldValue = XMLReflect.convertValue(fieldValueString, valueClass, this, fieldName);
        }
        if (haveAdditionalChildren && !this.isQuiet()) {
            this.notifyUser("Additional children found in tag " + subTag + ".", true);
        }
        return fieldValue;
    }

    public static Object convertValue(String valueString, Class valueClass) throws IllegalAccessException, InstantiationException {
        return XMLReflect.convertValue(valueString, valueClass, null, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object convertValue(String valueString, Class valueClass, XMLReflect xmlReflect, String fieldName) throws IllegalAccessException, InstantiationException {
        void var4_9;
        if (!valueString.equals("")) {
            Object fieldValue;
            Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = XMLReflect.class$("java.lang.String")) : class$java$lang$String};
            try {
                try {
                    if (valueClass.isPrimitive()) {
                        String fieldClassName = valueClass.getName();
                        if (fieldClassName.equals("boolean")) {
                            fieldValue = Boolean.valueOf(valueString);
                            return var4_9;
                        }
                        if (fieldClassName.equals("byte")) {
                            fieldValue = Byte.valueOf(valueString);
                            return var4_9;
                        }
                        if (fieldClassName.equals("char")) {
                            if (valueString.length() != 1) {
                                throw new IllegalArgumentException("Values for char fields may only be one charater long");
                            }
                            fieldValue = new Character(valueString.charAt(0));
                            return var4_9;
                        }
                        if (fieldClassName.equals("double")) {
                            fieldValue = Double.valueOf(valueString);
                            return var4_9;
                        }
                        if (fieldClassName.equals("float")) {
                            fieldValue = Float.valueOf(valueString);
                            return var4_9;
                        }
                        if (fieldClassName.equals("int")) {
                            fieldValue = Integer.valueOf(valueString);
                            return var4_9;
                        }
                        if (fieldClassName.equals("long")) {
                            fieldValue = Long.valueOf(valueString);
                            return var4_9;
                        }
                        if (!fieldClassName.equals("short")) throw new RuntimeException("Unhandled primitive type " + fieldClassName + "!");
                        fieldValue = Short.valueOf(valueString);
                        return var4_9;
                    }
                    Constructor valueConstructor = valueClass.getDeclaredConstructor(paramTypes);
                    Object[] params = new Object[]{valueString};
                    valueConstructor.setAccessible(true);
                    try {
                        fieldValue = valueConstructor.newInstance(params);
                        return var4_9;
                    }
                    catch (NumberFormatException e) {
                        if (xmlReflect == null || !xmlReflect.isTolerant()) {
                            throw new RuntimeException("Failed to convert to " + valueClass.getName(), e);
                        }
                        xmlReflect.notifyUser("Value '" + valueString + "' discarded due to exception in constructor for field '" + fieldName + "' of type " + valueClass.getName() + ".", e);
                        fieldValue = null;
                    }
                    return var4_9;
                }
                catch (NoSuchMethodException e) {
                    try {
                        if (xmlReflect == null) {
                            throw new RuntimeException("Value '" + valueString + "' cannot be converted due to missing constructor of type " + valueClass.getName() + ".");
                        }
                        Constructor valueConstructor = valueClass.getDeclaredConstructor(null);
                        valueConstructor.setAccessible(true);
                        fieldValue = valueConstructor.newInstance(null);
                        if (xmlReflect.isQuiet()) return var4_9;
                        xmlReflect.notifyUser("Value '" + valueString + "' discarded due to missing constructor for field '" + fieldName + "' of type " + valueClass.getName() + ".", true);
                        return var4_9;
                    }
                    catch (NoSuchMethodException e2) {
                        fieldValue = null;
                        if (xmlReflect != null && !xmlReflect.isQuiet()) {
                            xmlReflect.notifyUser("Value '" + valueString + "' discarded due to missing default constructor for field '" + fieldName + "' of type " + valueClass.getName() + ". Field set to null.", true);
                            return var4_9;
                        }
                        if (xmlReflect != null) return var4_9;
                        throw new RuntimeException("Value '" + valueString + "' connot be converted due to missing default constructor for of type " + valueClass.getName() + ".");
                    }
                }
            }
            catch (InvocationTargetException e) {
                if (xmlReflect == null || !xmlReflect.isTolerant()) throw new ObjectNotReflectableException(valueClass, (Throwable)e);
                if (!xmlReflect.isQuiet()) {
                    xmlReflect.notifyUser("Value '" + valueString + "' for field '" + fieldName + "' discarded due to " + e + " caused by:", e.getCause());
                }
                fieldValue = null;
                return var4_9;
            }
        } else {
            if (!(class$java$lang$String == null ? (class$java$lang$String = XMLReflect.class$("java.lang.String")) : class$java$lang$String).equals(valueClass)) return var4_9;
            return var4_9;
        }
    }

    public Object reflectXMLObject(Element xml) throws ObjectNotReflectableException {
        this.reflectXMLObject(xml, false);
        Object obj = this.reflectXMLObject(xml, true);
        this.clear(true);
        return obj;
    }

    private Object reflectXMLObject(Element xml, boolean resolveLinks) throws ObjectNotReflectableException {
        Class objClass;
        Object objInstance = this.reflectedXML.get(xml);
        if ((class$de$tu_bs$xmlreflect$Link == null ? (class$de$tu_bs$xmlreflect$Link = XMLReflect.class$("de.tu_bs.xmlreflect.Link")) : class$de$tu_bs$xmlreflect$Link).isAssignableFrom(objClass = this.getClassForStoredName(xml.getName()))) {
            if (resolveLinks) {
                Link link = this.getLinkFactory().getLinkTo(xml.getAttributeValue("targetID"), objClass, this);
                objInstance = link.getTarget();
            } else {
                objInstance = null;
            }
        } else {
            if (!this.isReflectable(objClass)) {
                throw new ObjectNotReflectableException(objClass);
            }
            try {
                if (objInstance == null) {
                    objInstance = this.createObjectInstance(objClass);
                    this.reflectedXML.put(xml, objInstance);
                }
                String id = xml.getAttributeValue(this.getIDString());
                if (this.isRestoringIDs()) {
                    this.setIDForObject(objInstance, id);
                }
                List subTags = xml.getChildren();
                Iterator it = subTags.iterator();
                while (it.hasNext()) {
                    Object child = it.next();
                    if (!(child instanceof Element)) continue;
                    Element subTag = (Element)child;
                    String fieldName = subTag.getName();
                    try {
                        Field field = this.findDeclaredField(objClass, fieldName, subTag.getAttributeValue("declaringClass"));
                        field.setAccessible(true);
                        Class<?> fieldClass = field.getType();
                        if (!fieldClass.isPrimitive()) {
                            Object fieldValue = this.reflectXMLField(subTag, fieldClass, resolveLinks, objInstance);
                            if (fieldValue == NONE || !resolveLinks) continue;
                            this.changeFieldValue(field, objInstance, fieldValue);
                            continue;
                        }
                        String fieldClassName = fieldClass.getName();
                        String fieldValueString = subTag.getText();
                        try {
                            if (fieldClassName.equals("boolean")) {
                                field.setBoolean(objInstance, Boolean.valueOf(fieldValueString));
                                continue;
                            }
                            if (fieldClassName.equals("char")) {
                                if (fieldValueString.length() != 1) {
                                    throw new IllegalArgumentException("Values for char fields may only be one charater long");
                                }
                                field.setChar(objInstance, fieldValueString.charAt(0));
                                continue;
                            }
                            if (fieldClassName.equals("double")) {
                                field.setDouble(objInstance, Double.parseDouble(fieldValueString));
                                continue;
                            }
                            if (fieldClassName.equals("float")) {
                                field.setFloat(objInstance, Float.parseFloat(fieldValueString));
                                continue;
                            }
                            if (fieldClassName.equals("int")) {
                                field.setInt(objInstance, Integer.parseInt(fieldValueString));
                                continue;
                            }
                            if (fieldClassName.equals("long")) {
                                field.setLong(objInstance, Long.parseLong(fieldValueString));
                                continue;
                            }
                            if (fieldClassName.equals("short")) {
                                field.setShort(objInstance, Short.parseShort(fieldValueString));
                                continue;
                            }
                            throw new RuntimeException("Unhandled primitive type " + fieldClassName + "!");
                        }
                        catch (NumberFormatException e) {
                            if (this.isQuiet()) continue;
                            this.notifyUser("Value discarded due to NumberFormatException '" + objInstance.toString() + "." + fieldName + "'.", true);
                        }
                    }
                    catch (NoSuchFieldException e) {
                        if ("___optional___".equals(fieldName)) {
                            this.handleOptionalTag(subTag, subTag.getAttribute("type").getValue(), objInstance, resolveLinks);
                            continue;
                        }
                        if (this.isQuiet()) continue;
                        this.notifyUser("Value discarded due to missing field '" + objInstance.toString() + "." + fieldName + "'.", true);
                    }
                    catch (IllegalArgumentException e) {
                        if (this.isQuiet()) continue;
                        this.notifyUser("Wrong type for field (IllegalArgumentException) '" + objInstance.toString() + "." + fieldName + "'.", true);
                    }
                }
                if (id != null && !id.equals("")) {
                    this.getLinkFactory().createLinkTo(objInstance, id);
                }
                if (resolveLinks) {
                    this.initTransientState(objInstance);
                }
            }
            catch (IllegalAccessException e) {
                throw new ObjectNotReflectableException(objClass, (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ObjectNotReflectableException(objClass, (Throwable)e);
            }
            catch (SecurityException e) {
                throw new ObjectNotReflectableException(objClass, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new ObjectNotReflectableException(objClass, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                if (this.isTolerant()) {
                    if (!this.isQuiet()) {
                        this.notifyUser("Value discarded due to InvocationTargetException:", e);
                    }
                    return null;
                }
                throw new ObjectNotReflectableException(objClass, (Throwable)e);
            }
        }
        return objInstance;
    }

    protected void changeFieldValue(Field field, Object objInstance, Object fieldValue) throws IllegalAccessException {
        if (!this.isUsingSetters()) {
            field.set(objInstance, fieldValue);
        } else {
            try {
                AccessorMethodsUtilizer.setField(objInstance, field.getName(), fieldValue);
            }
            catch (AccessorException e) {
                if (L.isEnabledFor(Priority.INFO)) {
                    L.info((Object)("accessor not used due to exception: " + e.getMessage()));
                }
                field.set(objInstance, fieldValue);
            }
        }
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
        this.getLinkFactory().setQuiet(quiet);
    }

    public boolean isTolerant() {
        return this.tolerant;
    }

    public void setTolerant(boolean tolerant) {
        this.tolerant = tolerant;
    }

    public boolean isStoringAllTypes() {
        return this.storingAllTypes;
    }

    public void setStoringAllTypes(boolean storingAllTypes) {
        this.storingAllTypes = storingAllTypes;
    }

    public boolean isStoringDefaultValues() {
        return this.storingDefaultValues;
    }

    public void setStoringDefaultValues(boolean storingDefaultValues) {
        this.storingDefaultValues = storingDefaultValues;
    }

    private boolean isReflectableObject(Object object) {
        if (object != null) {
            return this.isReflectable(object.getClass());
        }
        return false;
    }

    protected String getIDString() {
        return "ID";
    }

    public void removeYou() {
        if (this.reflectedValues != null) {
            this.reflectedValues.clear();
        }
        if (this.reflectedXML != null) {
            this.reflectedXML.clear();
        }
        if (this.classDefaultValues != null) {
            this.classDefaultValues.clear();
        }
        if (this.alreadyNotified != null) {
            this.alreadyNotified.clear();
        }
        this.linkFactory = null;
    }

    public void clear(boolean clearLinksToRestoredObjects) {
        this.reflectedValues = null;
        this.reflectedXML.clear();
        this.classDefaultValues.clear();
        if (classCache != null) {
            classCache.clear();
        }
        if (clearLinksToRestoredObjects) {
            this.getLinkFactory().clear();
        }
    }

    public Object reflectXML(String xmlAsString, boolean restoreIDs) {
        try {
            this.setRestoringIDs(restoreIDs);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(xmlAsString));
            return this.reflectXMLObject(doc.getRootElement());
        }
        catch (JDOMException e) {
            throw new RuntimeException("String value could not be parsed as XML correctly.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read XML.", e);
        }
    }

    public String toString(Object object) {
        return this.toString(this.reflectObject(object));
    }

    public String toString(Element element, boolean newLines, boolean documentHeader) {
        XMLOutputter xmlOutputter = new XMLOutputter();
        xmlOutputter.setNewlines(newLines);
        xmlOutputter.setIndent(newLines ? " " : null);
        String text = documentHeader ? xmlOutputter.outputString(new Document(element)) : xmlOutputter.outputString(element);
        return text.replaceAll("\r", "");
    }

    public String toString(Element element) {
        return this.toString(element, true, true);
    }

    public String toString(Element element, boolean singleLine) {
        if (!singleLine) {
            return this.toString(element);
        }
        XMLOutputter xmlOutputter = new XMLOutputter();
        return xmlOutputter.outputString(element);
    }

    public boolean isRestoringIDs() {
        return this.restoringIDs;
    }

    public void setRestoringIDs(boolean restoringIDs) {
        this.restoringIDs = restoringIDs;
    }

    public void setAllReferencedObjectsStoringDepth(int depth) {
        this.allReferencedObjectsStoringDepth = depth;
    }

    public int getAllReferencedObjectsStoringDepth() {
        return this.allReferencedObjectsStoringDepth;
    }

    public Object getDefaultValue(Field field, Class objClass) {
        HashMap<Field, Object> defaultValues = (HashMap<Field, Object>)this.classDefaultValues.get(objClass);
        if (defaultValues == null) {
            defaultValues = new HashMap<Field, Object>();
            this.classDefaultValues.put(objClass, defaultValues);
            try {
                Object defaultObj = this.createObjectInstance(objClass);
                for (Class currentClass = objClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
                    Field[] fields = currentClass.getDeclaredFields();
                    for (int fieldNr = 0; fieldNr < fields.length; ++fieldNr) {
                        Field foundField = fields[fieldNr];
                        foundField.setAccessible(true);
                        defaultValues.put(foundField, foundField.get(defaultObj));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Object defaultValue = defaultValues.get(field);
        return defaultValue;
    }

    protected void notifyUser(String message, boolean warn) {
        if (!this.alreadyNotified.contains(message)) {
            this.alreadyNotified.add(message);
            if (L.isEnabledFor(warn ? Priority.WARN : Priority.INFO)) {
                if (warn) {
                    L.warn((Object)message);
                } else {
                    L.info((Object)message);
                }
            }
        }
    }

    protected void notifyUser(String message, Throwable t) {
        if (!this.alreadyNotified.contains(message)) {
            this.alreadyNotified.add(message);
            if (L.isEnabledFor(Priority.ERROR)) {
                L.warn((Object)message, t);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader2 != null ? this.classLoader2 : this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader2 = classLoader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NONE = new NOClass();
    }

    private static class NOClass {
        private NOClass() {
        }
    }

    protected class ValueInfo {
        Element xml;
        String id;
        Object object;
        boolean stored;

        ValueInfo(Element xml, String id, Object object) {
            this.xml = xml;
            this.id = id;
            this.stored = false;
            this.object = object;
        }

        ValueInfo() {
        }
    }
}

