/*
 * Decompiled with CFR 0.152.
 */
package de.upb.javaparser.options;

import de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel;
import de.upb.javaparser.options.JavaParserOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class JavaParserOptionPane
extends PreferencesPanel {
    JCheckBox checkBoxRecursive;
    JCheckBox checkBoxDiagram;
    JCheckBox checkBoxIncremental;

    public JavaParserOptionPane() {
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gridBagLayout);
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 3.0;
        JPanel parserPanel = this.createParserPanel();
        mainPanel.add((Component)parserPanel, constraints);
        this.add(mainPanel, "North");
    }

    private JPanel createParserPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Options"));
        panel.setLayout(gridBagLayout);
        this.checkBoxIncremental = new JCheckBox("Enable incremental parsing");
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.gridwidth = 0;
        panel.add((Component)this.checkBoxIncremental, constraints);
        this.checkBoxRecursive = new JCheckBox("Parse directories recursively");
        this.checkBoxRecursive.addActionListener(new ToggleRecursiveListener());
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.checkBoxRecursive, constraints);
        this.checkBoxDiagram = new JCheckBox("Create new class diagram for each package/directory");
        constraints.insets = new Insets(0, 20, 3, 3);
        panel.add((Component)this.checkBoxDiagram, constraints);
        return panel;
    }

    public String getPreferredTabName() {
        return "Java Parser";
    }

    public void setDefaults() {
        JavaParserOptions.get().setDefaults();
        this.setPreferences();
    }

    public void setPreferences() {
        JavaParserOptions options = JavaParserOptions.get();
        this.checkBoxIncremental.setSelected(options.isIncrementalParsing());
        this.checkBoxRecursive.setSelected(options.isParseRecursively());
        this.checkBoxDiagram.setEnabled(options.isParseRecursively());
        this.checkBoxDiagram.setSelected(options.isDiagramPerPackage());
    }

    public void okPressed() {
        JavaParserOptions options = JavaParserOptions.get();
        options.setIncrementalParsing(this.checkBoxIncremental.isSelected());
        options.setParseRecursively(this.checkBoxRecursive.isSelected());
        options.setDiagramPerPackage(this.checkBoxDiagram.isSelected());
    }

    private class ToggleRecursiveListener
    implements ActionListener {
        ToggleRecursiveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (JavaParserOptionPane.this.checkBoxRecursive.isSelected()) {
                JavaParserOptionPane.this.checkBoxDiagram.setEnabled(true);
            } else {
                JavaParserOptionPane.this.checkBoxDiagram.setEnabled(false);
            }
        }
    }
}

