/*
 * Decompiled with CFR 0.152.
 */
package de.upb.javaparser;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.ProgressBarWrapper;
import de.uni_paderborn.fujaba.metamodel.FFile;
import de.uni_paderborn.fujaba.metamodel.FMethod;
import de.uni_paderborn.fujaba.parser.Parser;
import de.uni_paderborn.fujaba.parser.ParserPostProcessor;
import de.uni_paderborn.fujaba.uml.ASTRootNode;
import de.upb.javaparser.parser.JavaParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JFrame;

public class JavaParserFrontend
extends Parser
implements Runnable {
    private static JavaParserFrontend singletonInstance;
    private JavaParser javaParser;
    private HashSet files;
    private LinkedList postProcessors = new LinkedList();

    private JavaParserFrontend() {
        this.javaParser = new JavaParser(new StringReader(""));
    }

    public static JavaParserFrontend get() {
        if (singletonInstance == null) {
            singletonInstance = new JavaParserFrontend();
        }
        return singletonInstance;
    }

    public void parseFiles(HashSet files) {
        this.files = files;
        Thread parserThread = new Thread(this);
        parserThread.start();
    }

    public FFile parseCompilationUnit(String filename, Reader reader) {
        return this.javaParser.parseCompilationUnit(filename, reader);
    }

    public ASTRootNode parseMethodBody(FMethod fMethod) {
        return this.javaParser.parseMethodBody(fMethod);
    }

    public void run() {
        FrameMain frameMain = FrameMain.get();
        frameMain.setCursorWait();
        int progressBarLength = this.files.size() + this.postProcessors.size();
        ProgressBarWrapper progressBar = new ProgressBarWrapper((JFrame)frameMain, "Parsing Java Files...", progressBarLength);
        progressBar.openWindow();
        Iterator iter = this.files.iterator();
        while (iter.hasNext() && !progressBar.isAborted()) {
            File file = (File)iter.next();
            progressBar.increment(file.getName());
            try {
                this.javaParser.parseCompilationUnit(file.getAbsolutePath(), new FileReader(file));
            }
            catch (FileNotFoundException exception) {
                System.err.println("File " + file.getAbsolutePath() + " not found!");
            }
        }
        iter = this.postProcessors.iterator();
        while (iter.hasNext()) {
            ParserPostProcessor postProcessor = (ParserPostProcessor)iter.next();
            if (!postProcessor.isActive()) continue;
            progressBar.increment("Running " + postProcessor.getName());
            postProcessor.execute();
        }
        frameMain.createNewTreeItems();
        frameMain.setCursorDefault();
        progressBar.closeWindow();
    }

    public void addParserPostProcessor(ParserPostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    public void removeParserPostProcessor(ParserPostProcessor postProcessor) {
        this.postProcessors.remove(postProcessor);
    }
}

