/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.visitors;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.asg.ASGProject;
import de.uni_paderborn.fujaba.asg.ASGVisitor;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.upb.inferenceengine.ITriggerElementsCollector;
import de.upb.inferenceengine.engines.GFRNAnnotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CollectASGElementsVisitor
extends ASGVisitor
implements ITriggerElementsCollector {
    private HashSet collectedElements = new HashSet();
    private Collection axiomClasses;
    private HashSet typesToCollect = new HashSet();
    private HashSet checkedTypes = new HashSet();

    public List getTriggerElements(ASGProject project, Collection axiomClasses) {
        if (!(project instanceof UMLProject)) {
            throw new IllegalArgumentException("Expected a UMLProject but got a " + project.getClass());
        }
        this.axiomClasses = axiomClasses;
        this.visit((FElement)project);
        return new LinkedList(this.collectedElements);
    }

    private void addToElements(ASGElement element) {
        if (this.typesToCollect.contains(element.getClass())) {
            this.collectedElements.add(element);
        } else if (!this.checkedTypes.contains(element.getClass())) {
            if (this.axiomClasses.contains(element.getClass())) {
                this.typesToCollect.add(element.getClass());
                this.collectedElements.add(element);
            } else {
                Iterator iter = this.axiomClasses.iterator();
                while (iter.hasNext()) {
                    Class c = (Class)iter.next();
                    if (!c.isAssignableFrom(element.getClass())) continue;
                    this.typesToCollect.add(element.getClass());
                    this.collectedElements.add(element);
                    break;
                }
            }
            this.checkedTypes.add(element.getClass());
        }
    }

    public void visitASGElement(ASGElement asgElement) {
        Iterator iter = asgElement.iteratorOfAnnotations();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof GFRNAnnotation)) continue;
            GFRNAnnotation annotation = (GFRNAnnotation)((Object)obj);
            this.addToElements((ASGElement)annotation);
            this.visit((FElement)annotation);
        }
    }

    public void visitUMLProject(UMLProject umlProject) {
        this.visitASGElement((ASGElement)umlProject);
        Iterator iter = umlProject.iteratorOfDiags();
        while (iter.hasNext()) {
            ASGDiagram currentDiagram = (ASGDiagram)iter.next();
            if (!(currentDiagram instanceof UMLClassDiagram)) continue;
            UMLClassDiagram child = (UMLClassDiagram)currentDiagram;
            this.visit((FElement)child);
        }
    }

    public void visitUMLClassDiagram(UMLClassDiagram umlClassDiagram) {
        this.visitASGElement((ASGElement)umlClassDiagram);
        Iterator iter = umlClassDiagram.iteratorOfElements();
        while (iter.hasNext()) {
            ASGElement currentElement = (ASGElement)iter.next();
            this.addToElements(currentElement);
            this.visit((FElement)currentElement);
        }
    }

    public void visitUMLClass(UMLClass umlClass) {
        this.visitASGElement((ASGElement)umlClass);
        Iterator iter = umlClass.iteratorOfMethods();
        while (iter.hasNext()) {
            UMLMethod currentMethod = (UMLMethod)iter.next();
            this.addToElements((ASGElement)currentMethod);
            this.visit((FElement)currentMethod);
        }
        iter = umlClass.iteratorOfAttrs();
        while (iter.hasNext()) {
            UMLAttr currentAttr = (UMLAttr)iter.next();
            this.addToElements((ASGElement)currentAttr);
            this.visit((FElement)currentAttr);
        }
        iter = umlClass.iteratorOfStereotypes();
        while (iter.hasNext()) {
            UMLStereotype currentStereotype = (UMLStereotype)iter.next();
            this.addToElements((ASGElement)currentStereotype);
            this.visit((FElement)currentStereotype);
        }
    }

    public void visitUMLMethod(UMLMethod umlMethod) {
        this.visitASGElement((ASGElement)umlMethod);
        Iterator iter = umlMethod.iteratorOfParam();
        while (iter.hasNext()) {
            UMLParam currentParam = (UMLParam)iter.next();
            this.addToElements((ASGElement)currentParam);
            this.visit((FElement)currentParam);
        }
    }
}

