/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.visitors;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.asg.ASGVisitor;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.ASTNode;
import de.upb.javaast.methodast.BlockNode;
import de.upb.javaast.methodast.ExpressionNode;
import de.upb.javaast.methodast.IdentifierNode;
import de.upb.javaast.methodast.IfNode;
import de.upb.javaast.methodast.PrimaryExpressionNode;
import de.upb.javaast.methodast.StatementNode;
import de.upb.javaast.methodast.TypeNode;
import de.upb.javaast.methodast.VariableDeclarationNode;
import de.upb.javaast.methodast.VariableIdentifierDeclarationNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class ASTPathVisitorBottomUp
extends ASGVisitor
implements Iterator {
    private Class targetClass;
    private LinkedList queue = new LinkedList();
    private ASGElement currentMatchingNode;

    public ASTPathVisitorBottomUp(ASGElement startNode, Class targetClass) {
        this.queue.add(startNode);
        this.targetClass = targetClass;
    }

    public boolean hasNext() {
        if (this.currentMatchingNode == null) {
            while (this.currentMatchingNode == null && this.queue.size() > 0) {
                ASGElement tmp = (ASGElement)this.queue.removeFirst();
                this.visit((FElement)tmp);
            }
        }
        return this.currentMatchingNode != null;
    }

    public Object next() {
        if (this.hasNext()) {
            ASGElement tmpMatchingNode = this.currentMatchingNode;
            this.currentMatchingNode = null;
            return tmpMatchingNode;
        }
        throw new NoSuchElementException("ASTPathVisitor: No further matching element found on path.");
    }

    public void remove() {
        throw new UnsupportedOperationException("ASTPathVisitor: This iterator only implements read access.");
    }

    private void addToQueue(Object elem) {
        if (elem == null) {
            throw new IllegalArgumentException("given element is null");
        }
        this.queue.add(elem);
    }

    public void visitASTNode(ASTNode astNode) {
        if (this.targetClass.isInstance(astNode)) {
            this.currentMatchingNode = astNode;
        }
    }

    public void visitIdentifierNode(IdentifierNode identifierNode) {
        this.visitASTNode((ASTNode)identifierNode);
        if (identifierNode.getDeclaration() != null) {
            this.addToQueue(identifierNode.getDeclaration());
        }
        if (identifierNode.getPrimaryExpression() != null) {
            this.addToQueue(identifierNode.getPrimaryExpression());
        }
        if (identifierNode.getType() != null) {
            this.addToQueue(identifierNode.getType());
        }
    }

    public void visitVariableIdentifierDeclarationNode(VariableIdentifierDeclarationNode vidNode) {
        this.visitASTNode((ASTNode)vidNode);
        if (vidNode.getDeclaration() != null) {
            this.addToQueue(vidNode.getDeclaration());
        }
    }

    public void visitTypeNode(TypeNode typeNode) {
        this.visitASTNode((ASTNode)typeNode);
        if (typeNode.getDeclaration() != null) {
            this.addToQueue(typeNode.getDeclaration());
        }
        if (typeNode.getInstanceOfExpression() != null) {
            this.addToQueue(typeNode.getInstanceOfExpression());
        }
        if (typeNode.getTypeCast() != null) {
            this.addToQueue(typeNode.getTypeCast());
        }
    }

    public void visitVariableDeclarationNode(VariableDeclarationNode vdNode) {
        this.visitASTNode((ASTNode)vdNode);
        if (vdNode.getBlock() != null) {
            this.addToQueue(vdNode.getBlock());
        } else if (vdNode.getForInitStatement() != null) {
            this.addToQueue(vdNode.getForInitStatement());
        }
    }

    public void visitPrimaryExpressionNode(PrimaryExpressionNode peNode) {
        this.visitASTNode((ASTNode)peNode);
        if (peNode.getVariableDeclaration() != null) {
            this.addToQueue(peNode.getVariableDeclaration());
        }
        if (peNode.getPrevPrimaryExpression() != null) {
            this.addToQueue(peNode.getPrevPrimaryExpression());
        }
        if (peNode.getRevLeftExpression() != null) {
            this.addToQueue(peNode.getRevLeftExpression());
        }
        if (peNode.getRevRightExpression() != null) {
            this.addToQueue(peNode.getRevRightExpression());
        }
        if (peNode.getStatement() != null) {
            this.addToQueue(peNode.getStatement());
        }
        if (peNode.getIfStatement() != null) {
            this.addToQueue(peNode.getIfStatement());
        }
    }

    public void visitExpressionNode(ExpressionNode expressionNode) {
        this.visitASTNode((ASTNode)expressionNode);
        if (expressionNode.getPrimaryExpression() != null) {
            this.addToQueue(expressionNode.getPrimaryExpression());
        }
        if (expressionNode.getReturnNode() != null) {
            this.addToQueue(expressionNode.getReturnNode());
        }
        if (expressionNode.getIfStatement() != null) {
            this.addToQueue(expressionNode.getIfStatement());
        }
        if (expressionNode.getInstanceOfExpression() != null) {
            this.addToQueue(expressionNode.getInstanceOfExpression());
        }
    }

    public void visitStatementNode(StatementNode statementNode) {
        this.visitASTNode((ASTNode)statementNode);
        if (statementNode.getBlock() != null) {
            this.addToQueue(statementNode.getBlock());
        } else if (statementNode.getIfStatement() != null) {
            this.addToQueue(statementNode.getIfStatement());
        } else if (statementNode.getElseStatement() != null) {
            this.addToQueue(statementNode.getElseStatement());
        } else if (statementNode.getLoop() != null) {
            this.addToQueue(statementNode.getLoop());
        }
    }

    public void visitIfNode(IfNode ifNode) {
        this.visitASTNode((ASTNode)ifNode);
        if (ifNode.getBlock() != null) {
            this.addToQueue(ifNode.getBlock());
        }
        if (ifNode.getElseStatement() != null) {
            this.addToQueue(ifNode.getElseStatement());
        }
    }

    public void visitBlockNode(BlockNode blockNode) {
        this.visitASTNode((ASTNode)blockNode);
        if (blockNode.getBlock() != null) {
            this.addToQueue(blockNode.getBlock());
        }
        if (blockNode.getRootBlock() != null) {
            this.addToQueue(blockNode.getRootBlock());
        }
        if (blockNode.getIfStatement() != null) {
            this.addToQueue(blockNode.getIfStatement());
        }
        if (blockNode.getElseStatement() != null) {
            this.addToQueue(blockNode.getElseStatement());
        }
    }
}

